/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.client.proxy;

import com.elytradev.architecture.client.render.CustomBlockDispatcher;
import com.elytradev.architecture.client.render.PreviewRenderer;
import com.elytradev.architecture.client.render.RenderingManager;
import com.elytradev.architecture.client.render.shape.RenderCladding;
import com.elytradev.architecture.client.render.shape.RenderWindow;
import com.elytradev.architecture.client.render.shape.ShapeRenderDispatch;
import com.elytradev.architecture.common.ArchitectureContent;
import com.elytradev.architecture.common.ArchitectureMod;
import com.elytradev.architecture.common.proxy.CommonProxy;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.resgen.ConcreteResourcePack;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.resgen.IResourceHolder;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientProxy
extends CommonProxy {
    public static final ShapeRenderDispatch SHAPE_RENDER_DISPATCHER = new ShapeRenderDispatch();
    public static final RenderingManager RENDERING_MANAGER = new RenderingManager();

    @Override
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        RenderWindow.init();
    }

    @Override
    public void registerRenderers(LoaderState.ModState state) {
        if (state == LoaderState.ModState.PREINITIALIZED) {
            new ConcreteResourcePack("architecturecraft");
        }
        if (state == LoaderState.ModState.INITIALIZED) {
            this.registerTileEntitySpecialRenderers();
        }
        if (state == LoaderState.ModState.POSTINITIALIZED) {
            CustomBlockDispatcher.inject();
            MinecraftForge.EVENT_BUS.register(PreviewRenderer.class);
        }
    }

    public void registerTileEntitySpecialRenderers() {
    }

    public void registerDefaultModelLocations() {
        ModelResourceLocation modelResourceLocation;
        int i;
        for (i = 0; i < ArchitectureContent.registeredBlocks.size(); ++i) {
            modelResourceLocation = new ModelResourceLocation("architecturecraft:" + ArchitectureContent.registeredBlocks.keySet().toArray()[i], "inventory");
            Block block = (Block)ArchitectureContent.registeredBlocks.values().toArray()[i];
            Item itemFromBlock = Item.func_150898_a((Block)block);
            if (RENDERING_MANAGER.blockNeedsCustomRendering(block)) {
                ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)RENDERING_MANAGER.getBlockStateMapper());
                for (IBlockState state : block.func_176194_O().func_177619_a()) {
                    ModelResourceLocation location = RENDERING_MANAGER.getBlockStateMapper().func_178132_a(state);
                    IBakedModel model = RENDERING_MANAGER.getCustomBakedModel(state, location);
                    RENDERING_MANAGER.getBakedModels().add(model);
                }
                if (itemFromBlock == null) continue;
                RENDERING_MANAGER.registerModelLocationForItem(itemFromBlock, RENDERING_MANAGER.getItemBakedModel());
                continue;
            }
            this.registerMesh(itemFromBlock, 0, modelResourceLocation);
        }
        for (i = 0; i < ArchitectureContent.registeredItems.size(); ++i) {
            modelResourceLocation = new ModelResourceLocation("architecturecraft:" + ArchitectureContent.registeredItems.keySet().toArray()[i], "inventory");
            Item itemToRegister = (Item)ArchitectureContent.registeredItems.values().toArray()[i];
            if (itemToRegister instanceof IResourceHolder) continue;
            if (RENDERING_MANAGER.itemNeedsCustomRendering(itemToRegister)) {
                RENDERING_MANAGER.registerModelLocationForItem(itemToRegister, RENDERING_MANAGER.getItemBakedModel());
                continue;
            }
            this.registerMesh(itemToRegister, 0, modelResourceLocation);
        }
    }

    private void registerMesh(Item item, int meta, ModelResourceLocation resourceLocation) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_175599_af() != null && mc.func_175599_af().func_175037_a() != null) {
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, meta, resourceLocation);
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)resourceLocation);
        }
    }

    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent e) {
        RENDERING_MANAGER.getItemBakedModel().install(e);
    }

    @SubscribeEvent
    public void onModelRegistryEvent(ModelRegistryEvent event) {
        this.registerDefaultModelLocations();
    }

    @SubscribeEvent
    public void onStitch(TextureStitchEvent.Pre e) {
        RENDERING_MANAGER.clearTextureCache();
        for (Block block : ArchitectureContent.registeredBlocks.values()) {
            RENDERING_MANAGER.registerSprites(0, e.getMap(), block);
        }
        for (Item item : ArchitectureContent.registeredItems.values()) {
            RENDERING_MANAGER.registerSprites(1, e.getMap(), item);
        }
    }

    @Override
    public void registerHandlers() {
        super.registerHandlers();
    }

    @Override
    public void registerCustomRenderers() {
        RENDERING_MANAGER.addBlockRenderer((Block)ArchitectureMod.CONTENT.blockShape, SHAPE_RENDER_DISPATCHER);
        RENDERING_MANAGER.addItemRenderer(ArchitectureMod.CONTENT.itemCladding, new RenderCladding());
    }
}

