/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.common.shape;

import com.elytradev.architecture.client.render.model.IArchitectureModel;
import com.elytradev.architecture.client.render.model.OBJSONModel;
import com.elytradev.architecture.client.render.shape.RenderRoof;
import com.elytradev.architecture.client.render.shape.RenderWindow;
import com.elytradev.architecture.client.render.target.RenderTargetBase;
import com.elytradev.architecture.client.render.texture.ITexture;
import com.elytradev.architecture.common.ArchitectureLog;
import com.elytradev.architecture.common.ArchitectureMod;
import com.elytradev.architecture.common.block.BlockHelper;
import com.elytradev.architecture.common.block.BlockShape;
import com.elytradev.architecture.common.helpers.Profile;
import com.elytradev.architecture.common.helpers.Trans3;
import com.elytradev.architecture.common.helpers.Utils;
import com.elytradev.architecture.common.helpers.Vector3;
import com.elytradev.architecture.common.shape.Shape;
import com.elytradev.architecture.common.tile.TileArchitecture;
import com.elytradev.architecture.common.tile.TileShape;
import com.elytradev.architecture.common.utils.MiscUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class ShapeKind {
    public static Roof Roof = new Roof();
    public static Cladding Cladding = new Cladding();
    public Object[] profiles;

    public static Model Model(String name) {
        return new Model(name, null);
    }

    public static Model Model(String name, Object[] profiles) {
        return new Model(name, profiles);
    }

    public static Model Banister(String name) {
        return new Banister(name);
    }

    public Object profileForLocalFace(Shape shape, EnumFacing face) {
        if (this.profiles != null) {
            return this.profiles[face.ordinal()];
        }
        return null;
    }

    public double placementOffsetX() {
        return 0.0;
    }

    public abstract void renderShape(TileShape var1, ITexture[] var2, RenderTargetBase var3, Trans3 var4, boolean var5, boolean var6, int var7, int var8);

    public ItemStack newStack(Shape shape, IBlockState materialState, int stackSize) {
        TileShape te = new TileShape(shape, materialState);
        int light = te.getBaseBlockState().func_185906_d();
        return TileArchitecture.blockStackWithTileEntity((Block)ArchitectureMod.CONTENT.blockShape, stackSize, light, te);
    }

    public ItemStack newStack(Shape shape, Block materialBlock, int materialMeta, int stackSize) {
        return this.newStack(shape, materialBlock.func_176203_a(materialMeta), stackSize);
    }

    public boolean orientOnPlacement(EntityPlayer player, TileShape shape, BlockPos neighbourPos, IBlockState neighbourState, TileEntity neighbourTile, EnumFacing otherFace, Vector3 hit) {
        if (neighbourTile instanceof TileShape) {
            return this.orientOnPlacement(player, shape, (TileShape)neighbourTile, otherFace, hit);
        }
        return this.orientOnPlacement(player, shape, null, otherFace, hit);
    }

    public boolean orientOnPlacement(EntityPlayer player, TileShape shape, TileShape neighbourShape, EnumFacing otherFace, Vector3 hit) {
        Object otherProfile;
        if (neighbourShape != null && !player.func_70093_af() && (otherProfile = Profile.getProfileGlobal(neighbourShape.getShape(), neighbourShape.getSide(), neighbourShape.getTurn(), otherFace)) != null) {
            EnumFacing thisFace = otherFace.func_176734_d();
            for (int i = 0; i < 4; ++i) {
                int turn = neighbourShape.getTurn() + i & 3;
                Object thisProfile = Profile.getProfileGlobal(shape.getShape(), neighbourShape.getSide(), turn, thisFace);
                if (!Profile.matches(thisProfile, otherProfile)) continue;
                shape.setSide(neighbourShape.getSide());
                shape.setTurn(turn);
                shape.setOffsetX(neighbourShape.getOffsetX());
                return true;
            }
        }
        return false;
    }

    public boolean canPlaceUpsideDown() {
        return true;
    }

    public double sideZoneSize() {
        return 0.25;
    }

    public boolean highlightZones() {
        return false;
    }

    public void onChiselUse(TileShape te, EntityPlayer player, EnumFacing face, Vector3 hit) {
        EnumFacing side = this.zoneHit(face, hit);
        if (side != null) {
            this.chiselUsedOnSide(te, player, side);
        } else {
            this.chiselUsedOnCentre(te, player);
        }
    }

    public void chiselUsedOnSide(TileShape te, EntityPlayer player, EnumFacing side) {
        te.toggleConnectionGlobal(side);
    }

    public void chiselUsedOnCentre(TileShape te, EntityPlayer player) {
        ItemStack stack;
        if (te.hasSecondaryBlockState() && (stack = this.newSecondaryMaterialStack(te.getSecondaryBlockState())) != null) {
            if (!Utils.playerIsInCreativeMode(player)) {
                Block.func_180635_a((World)te.func_145831_w(), (BlockPos)te.func_174877_v(), (ItemStack)stack);
            }
            te.setSecondaryMaterial(null);
        }
    }

    public ItemStack newSecondaryMaterialStack(IBlockState state) {
        if (this.acceptsCladding()) {
            return ArchitectureMod.CONTENT.itemCladding.newStack(state, 1);
        }
        return null;
    }

    public void onHammerUse(TileShape te, EntityPlayer player, EnumFacing face, Vector3 hit) {
        if (player.func_70093_af()) {
            te.setSide((te.getSide() + 1) % 6);
        } else {
            double dx = te.getOffsetX();
            if (dx != 0.0) {
                dx = -dx;
                te.setOffsetX(dx);
            }
            if (dx >= 0.0) {
                te.setTurn((te.getTurn() + 1) % 4);
            }
        }
        te.markBlockChanged();
    }

    public EnumFacing zoneHit(EnumFacing face, Vector3 hit) {
        double r = 0.5 - this.sideZoneSize();
        if (hit.x <= -r && face != EnumFacing.WEST) {
            return EnumFacing.WEST;
        }
        if (hit.x >= r && face != EnumFacing.EAST) {
            return EnumFacing.EAST;
        }
        if (hit.y <= -r && face != EnumFacing.DOWN) {
            return EnumFacing.DOWN;
        }
        if (hit.y >= r && face != EnumFacing.UP) {
            return EnumFacing.UP;
        }
        if (hit.z <= -r && face != EnumFacing.NORTH) {
            return EnumFacing.NORTH;
        }
        if (hit.z >= r && face != EnumFacing.SOUTH) {
            return EnumFacing.SOUTH;
        }
        return null;
    }

    public boolean acceptsCladding() {
        return false;
    }

    public boolean isValidSecondaryMaterial(IBlockState state) {
        return false;
    }

    public boolean secondaryDefaultsToBase() {
        return false;
    }

    public AxisAlignedBB getBounds(TileShape te, IBlockAccess world, BlockPos pos, IBlockState state, Entity entity, Trans3 t) {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        this.addCollisionBoxesToList(te, world, pos, state, entity, t, list);
        return Utils.unionOfBoxes(list);
    }

    public void addCollisionBoxesToList(TileShape te, IBlockAccess world, BlockPos pos, IBlockState state, Entity entity, Trans3 t, List list) {
        int mask = te.getShape().occlusionMask;
        int param = mask & 0xFF;
        switch (mask & 0xFF00) {
            case 0: {
                for (int i = 0; i < 8; ++i) {
                    if ((mask & 1 << i) == 0) continue;
                    Vector3 p = new Vector3((i & 1) != 0 ? 0.5 : -0.5, (i & 4) != 0 ? 0.5 : -0.5, (i & 2) != 0 ? 0.5 : -0.5);
                    this.addBox(Vector3.zero, p, t, list);
                }
                break;
            }
            case 256: {
                double r = (double)param / 16.0;
                this.addBox(new Vector3(-r, -0.5, -r), new Vector3(r, 0.5, r), t, list);
                break;
            }
            case 512: {
                double r = (double)param / 32.0;
                this.addBox(new Vector3(-0.5, -0.5, -r), new Vector3(0.5, 0.5, r), t, list);
                break;
            }
            case 768: {
                double r = (double)((param & 0xF) + 1) / 16.0;
                double h = (double)((param >> 4) + 1) / 16.0;
                this.addBox(new Vector3(-0.5, -0.5, 0.5 - r), new Vector3(-0.5 + r, -0.5 + h, 0.5), t, list);
                break;
            }
            case 1024: 
            case 1280: {
                double r = (double)((param & 0xF) + 1) / 16.0;
                double h = (double)((param >> 4) + 1) / 16.0;
                this.addBox(new Vector3(-0.5, -0.5, 0.5 - r), new Vector3(0.5, -0.5 + h, 0.5), t, list);
                if ((mask & 0x100) == 0) break;
                this.addBox(new Vector3(-0.5, -0.5, -0.5), new Vector3(-0.5 + r, -0.5 + h, 0.5), t, list);
                break;
            }
            default: {
                this.addBox(new Vector3(-0.5, -0.5, -0.5), new Vector3(0.5, 0.5, 0.5), t, list);
            }
        }
    }

    protected void addBox(Vector3 p0, Vector3 p1, Trans3 t, List list) {
        t.addBox(p0, p1, list);
    }

    public static class Banister
    extends Model {
        public Banister(String modelName) {
            super(modelName, (Object[])Profile.Generic.tbOffset);
        }

        private static EnumFacing stairsFacing(IBlockState state) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockStairs.field_176309_a);
        }

        private static int stairsSide(IBlockState state) {
            if (state.func_177229_b((IProperty)BlockStairs.field_176308_b) == BlockStairs.EnumHalf.TOP) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean orientOnPlacement(EntityPlayer player, TileShape shape, BlockPos neighbourPos, IBlockState neighbourState, TileEntity neighbourTile, EnumFacing otherFace, Vector3 hit) {
            if (!player.func_70093_af()) {
                int side;
                Block nblock = neighbourState.func_177230_c();
                boolean placedOnStair = false;
                int nside = -1;
                int nturn = -1;
                if (BlockStairs.func_185709_i((IBlockState)neighbourState) && (otherFace == EnumFacing.UP || otherFace == EnumFacing.DOWN)) {
                    placedOnStair = true;
                    nside = Banister.stairsSide(neighbourState);
                    nturn = MiscUtils.turnToFace(EnumFacing.SOUTH, Banister.stairsFacing(neighbourState));
                    if (nside == 1 && (nturn & 1) == 0) {
                        nturn ^= 2;
                    }
                } else if (nblock instanceof BlockShape && neighbourTile instanceof TileShape) {
                    placedOnStair = true;
                    nside = ((TileShape)neighbourTile).getSide();
                    nturn = ((TileShape)neighbourTile).getTurn();
                }
                if (placedOnStair && (side = otherFace.func_176734_d().ordinal()) == nside) {
                    Vector3 h = Trans3.sideTurn(side, 0).ip(hit);
                    double offx = shape.getShape().offsetXForPlacementHit(side, nturn, hit);
                    shape.setSide(side);
                    shape.setTurn(nturn & 3);
                    shape.setOffsetX(offx);
                    return true;
                }
            }
            return super.orientOnPlacement(player, shape, neighbourPos, neighbourState, neighbourTile, otherFace, hit);
        }

        @Override
        public double placementOffsetX() {
            return 0.375;
        }
    }

    public static class Cladding
    extends ShapeKind {
        @Override
        public void renderShape(TileShape te, ITexture[] textures, RenderTargetBase target, Trans3 t, boolean renderBase, boolean renderSecondary, int baseColourMult, int secondaryColourMult) {
        }

        @Override
        public ItemStack newStack(Shape shape, Block materialBlock, int materialMeta, int stackSize) {
            return ArchitectureMod.CONTENT.itemCladding.newStack(materialBlock, materialMeta, stackSize);
        }
    }

    public static abstract class Window
    extends ShapeKind {
        public EnumFacing[] frameSides;
        public boolean[] frameAlways;
        public FrameKind[] frameKinds;
        public EnumFacing[] frameOrientations;
        public Trans3[] frameTrans;

        @Override
        public boolean orientOnPlacement(EntityPlayer player, TileShape shape, TileShape neighbourShape, EnumFacing otherFace, Vector3 hit) {
            int turn = -1;
            if (!(player.func_70093_af() || neighbourShape != null && neighbourShape.getShape().kind instanceof Window)) {
                switch (otherFace) {
                    case EAST: 
                    case WEST: {
                        turn = 0;
                        break;
                    }
                    case SOUTH: 
                    case NORTH: {
                        turn = 1;
                    }
                }
            }
            if (turn >= 0) {
                shape.setSide(0);
                shape.setTurn(turn);
                return true;
            }
            return false;
        }

        public FrameKind frameKindForLocalSide(EnumFacing side) {
            return this.frameKinds[side.ordinal()];
        }

        public EnumFacing frameOrientationForLocalSide(EnumFacing side) {
            return this.frameOrientations[side.ordinal()];
        }

        @Override
        public boolean canPlaceUpsideDown() {
            return false;
        }

        @Override
        public double sideZoneSize() {
            return 0.125;
        }

        @Override
        public boolean highlightZones() {
            return true;
        }

        @Override
        public void renderShape(TileShape te, ITexture[] textures, RenderTargetBase target, Trans3 t, boolean renderBase, boolean renderSecondary, int baseColourMult, int secondaryColourMult) {
            new RenderWindow(te, textures, t, target, renderBase, renderSecondary, baseColourMult, secondaryColourMult).render();
        }

        @Override
        public ItemStack newSecondaryMaterialStack(IBlockState state) {
            return BlockHelper.blockStackWithState(state, 1);
        }

        @Override
        public boolean isValidSecondaryMaterial(IBlockState state) {
            Block block = state.func_177230_c();
            return block == Blocks.field_150410_aZ || block == Blocks.field_150397_co;
        }

        @Override
        public void addCollisionBoxesToList(TileShape te, IBlockAccess world, BlockPos pos, IBlockState state, Entity entity, Trans3 t, List list) {
            double r = 0.125;
            double s = 0.09375;
            double[] e = new double[4];
            this.addCentreBoxesToList(0.125, 0.09375, t, list);
            for (int i = 0; i <= 3; ++i) {
                boolean frame;
                boolean bl = frame = this.frameAlways[i] || !this.isConnectedGlobal(te, t.t(this.frameSides[i]));
                if (entity == null || frame) {
                    Trans3 ts = t.t(this.frameTrans[i]);
                    this.addFrameBoxesToList(i, 0.125, 0.09375, ts, list);
                }
                e[i] = frame ? 0.375 : 0.5;
            }
            if (te.hasSecondaryBlockState()) {
                this.addGlassBoxesToList(0.125, 0.09375, 0.03125, e, t, list);
            }
            if (list.isEmpty()) {
                this.addBox(new Vector3(-0.5, -0.5, -0.5), new Vector3(0.5, 0.5, 0.5), t, list);
            }
        }

        protected void addCentreBoxesToList(double r, double s, Trans3 t, List list) {
        }

        protected void addFrameBoxesToList(int i, double r, double s, Trans3 ts, List list) {
            ts.addBox(-0.5, -0.5, -s, 0.5, -0.5 + r, s, list);
        }

        protected void addGlassBoxesToList(double r, double s, double w, double[] e, Trans3 t, List list) {
            t.addBox(-e[3], -e[0], -w, e[1], e[2], w, list);
        }

        protected boolean isConnectedGlobal(TileShape te, EnumFacing globalDir) {
            return this.getConnectedWindowGlobal(te, globalDir) != null;
        }

        public TileShape getConnectedWindowGlobal(TileShape te, EnumFacing globalDir) {
            EnumFacing thisLocalDir = te.localFace(globalDir);
            FrameKind thisFrameKind = this.frameKindForLocalSide(thisLocalDir);
            if (thisFrameKind != FrameKind.None) {
                EnumFacing otherLocalDir;
                Window otherKind;
                FrameKind otherFrameKind;
                EnumFacing thisOrient = this.frameOrientationForLocalSide(thisLocalDir);
                TileShape nte = te.getConnectedNeighbourGlobal(globalDir);
                if (nte != null && nte.getShape().kind instanceof Window && (otherFrameKind = (otherKind = (Window)nte.getShape().kind).frameKindForLocalSide(otherLocalDir = nte.localFace(globalDir.func_176734_d()))) != FrameKind.None) {
                    EnumFacing otherOrient = otherKind.frameOrientationForLocalSide(otherLocalDir);
                    if (this.framesMatch(thisFrameKind, otherFrameKind, te.globalFace(thisOrient), nte.globalFace(otherOrient))) {
                        return nte;
                    }
                }
            }
            return null;
        }

        protected boolean framesMatch(FrameKind kind1, FrameKind kind2, EnumFacing orient1, EnumFacing orient2) {
            if (kind1 == kind2) {
                switch (kind1) {
                    case Plain: {
                        return orient1.func_176740_k() == orient2.func_176740_k();
                    }
                }
                return orient1 == orient2;
            }
            return false;
        }

        public static enum FrameKind {
            None,
            Plain,
            Corner;

        }
    }

    public static class Model
    extends ShapeKind {
        protected String modelName;
        private IArchitectureModel model;

        public Model(String name, Object[] profiles) {
            this.modelName = "shape/" + name + ".objson";
            this.profiles = profiles;
        }

        @Override
        public boolean secondaryDefaultsToBase() {
            return true;
        }

        @Override
        public AxisAlignedBB getBounds(TileShape te, IBlockAccess world, BlockPos pos, IBlockState state, Entity entity, Trans3 t) {
            return t.t(this.getModel().getBounds());
        }

        @Override
        public void renderShape(TileShape te, ITexture[] textures, RenderTargetBase target, Trans3 t, boolean renderBase, boolean renderSecondary, int baseColourMult, int secondaryColourMult) {
            IArchitectureModel model = this.getModel();
            model.render(t, target, baseColourMult, secondaryColourMult, textures);
        }

        protected IArchitectureModel getModel() {
            if (this.model == null) {
                this.model = ArchitectureMod.PROXY.getModel(this.modelName);
            }
            return this.model;
        }

        @Override
        public boolean acceptsCladding() {
            OBJSONModel model = (OBJSONModel)this.getModel();
            for (OBJSONModel.Face face : model.faces) {
                if (face.texture < 2) continue;
                return true;
            }
            return false;
        }

        @Override
        public void addCollisionBoxesToList(TileShape te, IBlockAccess world, BlockPos pos, IBlockState state, Entity entity, Trans3 t, List list) {
            if (te.getShape().occlusionMask == 0) {
                this.getModel().addBoxesToList(t, list);
            } else {
                super.addCollisionBoxesToList(te, world, pos, state, entity, t, list);
            }
        }

        @Override
        public double placementOffsetX() {
            ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
            this.getModel().addBoxesToList(Trans3.ident, list);
            AxisAlignedBB bounds = Utils.unionOfBoxes(list);
            if (Shape.debugPlacement) {
                for (AxisAlignedBB box : list) {
                    ArchitectureLog.info("ShapeKind.Model.placementOffsetX: %s\n", box);
                }
                ArchitectureLog.info("ShapeKind.Model.placementOffsetX: bounds = %s\n", bounds);
            }
            return 0.5 * (1.0 - (bounds.field_72336_d - bounds.field_72340_a));
        }
    }

    public static class Roof
    extends ShapeKind {
        @Override
        public boolean acceptsCladding() {
            return true;
        }

        @Override
        public boolean secondaryDefaultsToBase() {
            return true;
        }

        @Override
        public void renderShape(TileShape te, ITexture[] textures, RenderTargetBase target, Trans3 t, boolean renderBase, boolean renderSecondary, int baseColourMult, int secondaryColourMult) {
            new RenderRoof(te, textures, t, target, renderBase, renderSecondary, baseColourMult, secondaryColourMult).render();
        }

        @Override
        public Object profileForLocalFace(Shape shape, EnumFacing face) {
            switch (shape) {
                case ROOF_TILE: 
                case ROOF_OVERHANG: {
                    switch (face) {
                        case EAST: {
                            return RoofProfile.Left;
                        }
                        case WEST: {
                            return RoofProfile.Right;
                        }
                    }
                    break;
                }
                case ROOF_OUTER_CORNER: 
                case ROOF_OVERHANG_OUTER_CORNER: {
                    switch (face) {
                        case SOUTH: {
                            return RoofProfile.Left;
                        }
                        case WEST: {
                            return RoofProfile.Right;
                        }
                    }
                    break;
                }
                case ROOF_INNER_CORNER: 
                case ROOF_OVERHANG_INNER_CORNER: {
                    switch (face) {
                        case EAST: {
                            return RoofProfile.Left;
                        }
                        case NORTH: {
                            return RoofProfile.Right;
                        }
                    }
                    break;
                }
                case ROOF_RIDGE: 
                case ROOF_SMART_RIDGE: 
                case ROOF_OVERHANG_RIDGE: {
                    return RoofProfile.Ridge;
                }
                case ROOF_VALLEY: 
                case ROOF_SMART_VALLEY: 
                case ROOF_OVERHANG_VALLEY: {
                    return RoofProfile.Valley;
                }
            }
            return RoofProfile.None;
        }

        static {
            Profile.declareOpposite((Object)RoofProfile.Left, (Object)RoofProfile.Right);
        }

        protected static enum RoofProfile {
            None,
            Left,
            Right,
            Ridge,
            Valley;

        }
    }
}

