/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.common.tile;

import com.elytradev.architecture.common.tile.TileArchitecture;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;

public abstract class TileArchitectureInventory
extends TileArchitecture
implements IInventory,
ISidedInventory {
    protected int[] allSlots;

    protected IInventory getInventory() {
        return null;
    }

    public void readInventoryFromNBT(NBTTagCompound nbt) {
        IInventory inventory = this.getInventory();
        if (inventory != null) {
            NBTTagList list = nbt.func_150295_c("inventory", 10);
            int n = list.func_74745_c();
            for (int i = 0; i < n; ++i) {
                NBTTagCompound item = list.func_150305_b(i);
                int slot = item.func_74762_e("slot");
                ItemStack stack = new ItemStack(item);
                inventory.func_70299_a(slot, stack);
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readInventoryFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.writeInventoryToNBT(nbt);
        return nbt;
    }

    public void writeInventoryToNBT(NBTTagCompound nbt) {
        IInventory inventory = this.getInventory();
        if (inventory != null) {
            NBTTagList list = new NBTTagList();
            int n = inventory.func_70302_i_();
            for (int i = 0; i < n; ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                if (stack == null) continue;
                NBTTagCompound item = new NBTTagCompound();
                item.func_74768_a("slot", i);
                stack.func_77955_b(item);
                list.func_74742_a((NBTBase)item);
            }
            nbt.func_74782_a("inventory", (NBTBase)list);
        }
    }

    protected void onInventoryChanged(int slot) {
        this.func_70296_d();
    }

    public String func_70005_c_() {
        IInventory inventory = this.getInventory();
        return inventory != null ? inventory.func_70005_c_() : "";
    }

    public boolean func_145818_k_() {
        IInventory inventory = this.getInventory();
        return inventory != null && inventory.func_145818_k_();
    }

    public ITextComponent func_145748_c_() {
        IInventory inventory = this.getInventory();
        return inventory != null ? inventory.func_145748_c_() : null;
    }

    public int func_70302_i_() {
        IInventory inventory = this.getInventory();
        return inventory != null ? inventory.func_70302_i_() : 0;
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        IInventory inventory = this.getInventory();
        return inventory != null ? inventory.func_70301_a(slot) : null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        IInventory inventory = this.getInventory();
        if (inventory != null) {
            ItemStack result = inventory.func_70298_a(slot, amount);
            this.onInventoryChanged(slot);
            return result;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        IInventory inventory = this.getInventory();
        if (inventory != null) {
            ItemStack result = inventory.func_70304_b(slot);
            this.onInventoryChanged(slot);
            return result;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        IInventory inventory = this.getInventory();
        if (inventory != null) {
            inventory.func_70299_a(slot, stack);
            this.onInventoryChanged(slot);
        }
    }

    public int func_70297_j_() {
        IInventory inventory = this.getInventory();
        return inventory != null ? inventory.func_70297_j_() : 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        IInventory inventory = this.getInventory();
        return inventory == null || inventory.func_70300_a(player);
    }

    public void func_174889_b(EntityPlayer player) {
        IInventory inventory = this.getInventory();
        if (inventory != null) {
            inventory.func_174889_b(player);
        }
    }

    public void func_174886_c(EntityPlayer player) {
        IInventory inventory = this.getInventory();
        if (inventory != null) {
            inventory.func_174886_c(player);
        }
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        IInventory inventory = this.getInventory();
        if (inventory != null) {
            return inventory.func_94041_b(slot, stack);
        }
        return false;
    }

    public int func_174887_a_(int id) {
        IInventory inventory = this.getInventory();
        if (inventory != null) {
            return inventory.func_174887_a_(id);
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        IInventory inventory = this.getInventory();
        if (inventory != null) {
            inventory.func_174885_b(id, value);
        }
    }

    public int func_174890_g() {
        IInventory inventory = this.getInventory();
        if (inventory != null) {
            return inventory.func_174890_g();
        }
        return 0;
    }

    public void func_174888_l() {
        IInventory inventory = this.getInventory();
        if (inventory != null) {
            inventory.func_174888_l();
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        IInventory inventory = this.getInventory();
        if (inventory instanceof ISidedInventory) {
            return ((ISidedInventory)inventory).func_180463_a(side);
        }
        if (this.allSlots == null) {
            int n = this.func_70302_i_();
            this.allSlots = new int[n];
            for (int i = 0; i < n; ++i) {
                this.allSlots[i] = i;
            }
        }
        return this.allSlots;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        IInventory inventory = this.getInventory();
        if (inventory instanceof ISidedInventory) {
            return ((ISidedInventory)inventory).func_180462_a(slot, stack, side);
        }
        return true;
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        IInventory inventory = this.getInventory();
        if (inventory instanceof ISidedInventory) {
            return ((ISidedInventory)inventory).func_180461_b(slot, stack, side);
        }
        return true;
    }
}

