/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.integration.ModHelper;
import com.brandon3055.draconicevolution.items.armor.DraconicArmor;
import com.brandon3055.draconicevolution.items.armor.ICustomArmor;
import com.brandon3055.draconicevolution.items.tools.ToolStats;
import com.brandon3055.draconicevolution.network.PacketShieldHit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CustomArmorHandler {
    public static final UUID WALK_SPEED_UUID = UUID.fromString("0ea6ce8e-d2e8-11e5-ab30-625662870761");
    private static final DamageSource ADMIN_KILL = new DamageSource("administrative.kill").func_76359_i().func_76348_h().func_151518_m();
    public static Map<EntityPlayer, Boolean> playersWithFlight = new WeakHashMap<EntityPlayer, Boolean>();
    public static List<String> playersWithUphillStep = new ArrayList<String>();

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerAttacked(LivingAttackEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer) || event.isCanceled() || event.getAmount() <= 0.0f) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        ArmorSummery summery = new ArmorSummery().getSummery(player);
        float hitAmount = ModHelper.applyModDamageAdjustments(summery, event);
        if (CustomArmorHandler.applyArmorDamageBlocking(event, summery)) {
            return;
        }
        if (summery == null || summery.protectionPoints <= 0.0f || event.getSource() == ADMIN_KILL) {
            return;
        }
        event.setCanceled(true);
        if (hitAmount == Float.MAX_VALUE && !event.getSource().field_76373_n.equals(CustomArmorHandler.ADMIN_KILL.field_76373_n)) {
            player.func_70097_a(ADMIN_KILL, Float.MAX_VALUE);
            return;
        }
        if ((float)player.field_70172_ad > (float)player.field_70771_an - 4.0f) {
            return;
        }
        float newEntropy = Math.min(summery.entropy + 1.0f + hitAmount / 20.0f, 100.0f);
        float totalAbsorbed = 0.0f;
        int remainingPoints = 0;
        for (int i = 0; i < summery.allocation.length; ++i) {
            if (summery.allocation[i] == 0.0f) continue;
            ItemStack armorPiece = (ItemStack)summery.armorStacks.get(i);
            float dmgShear = summery.allocation[i] / summery.protectionPoints;
            float dmg = dmgShear * hitAmount;
            float absorbed = Math.min(dmg, summery.allocation[i]);
            totalAbsorbed += absorbed;
            int n = i;
            summery.allocation[n] = summery.allocation[n] - absorbed;
            remainingPoints = (int)((float)remainingPoints + summery.allocation[i]);
            ItemNBTHelper.setFloat((ItemStack)armorPiece, (String)"ProtectionPoints", (float)summery.allocation[i]);
            ItemNBTHelper.setFloat((ItemStack)armorPiece, (String)"ShieldEntropy", (float)newEntropy);
        }
        summery.saveStacks(player);
        DraconicEvolution.network.sendToAllAround((IMessage)new PacketShieldHit(player, (float)remainingPoints / summery.maxProtectionPoints), new NetworkRegistry.TargetPoint(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 64.0));
        if (remainingPoints > 0) {
            player.field_70172_ad = 20;
        } else if (hitAmount - totalAbsorbed > 0.0f) {
            player.func_70097_a(event.getSource(), hitAmount - totalAbsorbed);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerDeath(LivingDeathEvent event) {
        int i;
        if (!(event.getEntityLiving() instanceof EntityPlayer) || event.isCanceled()) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        if (!player.func_70613_aW()) {
            return;
        }
        ArmorSummery summery = new ArmorSummery().getSummery(player);
        if (summery == null || event.getSource() == ADMIN_KILL) {
            return;
        }
        if (summery.protectionPoints > 500.0f) {
            event.setCanceled(true);
            event.getEntityLiving().func_70606_j(10.0f);
            return;
        }
        if (!summery.hasDraconic) {
            return;
        }
        int[] charge = new int[summery.armorStacks.size()];
        long totalCharge = 0L;
        for (i = 0; i < summery.armorStacks.size(); ++i) {
            if (((ItemStack)summery.armorStacks.get(i)).func_190926_b()) continue;
            charge[i] = ((ICustomArmor)((ItemStack)summery.armorStacks.get(i)).func_77973_b()).getEnergyStored((ItemStack)summery.armorStacks.get(i));
            totalCharge += (long)charge[i];
        }
        if (totalCharge < (long)ToolStats.LAST_STAND_ENERGY) {
            return;
        }
        for (i = 0; i < summery.armorStacks.size(); ++i) {
            if (((ItemStack)summery.armorStacks.get(i)).func_190926_b()) continue;
            ((ICustomArmor)((ItemStack)summery.armorStacks.get(i)).func_77973_b()).modifyEnergy((ItemStack)summery.armorStacks.get(i), -((int)((double)charge[i] / (double)totalCharge * 1.0E7)));
        }
        summery.saveStacks(player);
        player.func_145747_a(new TextComponentTranslation("msg.de.shieldDepleted.txt", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)));
        event.setCanceled(true);
        player.func_70606_j(1.0f);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        EntityPlayer player = event.player;
        ArmorSummery summery = new ArmorSummery().getSummery(player);
        CustomArmorHandler.tickShield(summery, player);
        CustomArmorHandler.tickArmorEffects(summery, player);
    }

    @SubscribeEvent
    public void onLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntity();
        ArmorSummery summery = new ArmorSummery().getSummery(player);
        if (summery != null && summery.jumpModifier > 0.0f) {
            player.field_70181_x += (double)(summery.jumpModifier * 0.135f);
        }
    }

    public static void tickShield(ArmorSummery summery, EntityPlayer player) {
        if (summery == null || (double)(summery.maxProtectionPoints - summery.protectionPoints) < 0.01 && summery.entropy == 0.0f || player.field_70170_p.field_72995_K) {
            return;
        }
        float totalPointsToAdd = Math.min(summery.maxProtectionPoints - summery.protectionPoints, summery.maxProtectionPoints / 60.0f);
        totalPointsToAdd *= 1.0f - summery.entropy / 100.0f;
        if ((totalPointsToAdd = Math.min(totalPointsToAdd, (float)(summery.totalEnergyStored / 1000L))) < 0.0f) {
            totalPointsToAdd = 0.0f;
        }
        summery.entropy -= summery.meanRecoveryPoints / 100.0f;
        if (summery.entropy < 0.0f) {
            summery.entropy = 0.0f;
        }
        for (int i = 0; i < summery.armorStacks.size(); ++i) {
            ItemStack stack = (ItemStack)summery.armorStacks.get(i);
            if (stack.func_190926_b() || summery.totalEnergyStored <= 0L) continue;
            float maxForPiece = ((ICustomArmor)stack.func_77973_b()).getProtectionPoints(stack);
            int energyAmount = ((ICustomArmor)((ItemStack)summery.armorStacks.get(i)).func_77973_b()).getEnergyPerProtectionPoint();
            ((ICustomArmor)stack.func_77973_b()).modifyEnergy(stack, -((int)((double)summery.energyAllocation[i] / (double)summery.totalEnergyStored * (double)(totalPointsToAdd * (float)energyAmount))));
            float pointsForPiece = summery.pointsDown[i] / Math.max(1.0f, summery.maxProtectionPoints - summery.protectionPoints) * totalPointsToAdd;
            int n = i;
            summery.allocation[n] = summery.allocation[n] + pointsForPiece;
            if (summery.allocation[i] > maxForPiece || maxForPiece - summery.allocation[i] < 0.1f) {
                summery.allocation[i] = maxForPiece;
            }
            ItemNBTHelper.setFloat((ItemStack)stack, (String)"ProtectionPoints", (float)summery.allocation[i]);
            if (player.field_70172_ad > 0) continue;
            ItemNBTHelper.setFloat((ItemStack)stack, (String)"ShieldEntropy", (float)summery.entropy);
        }
        summery.saveStacks(player);
    }

    public static void tickArmorEffects(ArmorSummery summery, EntityPlayer player) {
        if (DEConfig.enableFlight) {
            if (summery != null && summery.flight[0]) {
                playersWithFlight.put(player, true);
                player.field_71075_bZ.field_75101_c = true;
                if (summery.flight[1]) {
                    player.field_71075_bZ.field_75100_b = true;
                }
                if (player.field_70170_p.field_72995_K) {
                    CustomArmorHandler.setPlayerFlySpeed(player, 0.05f + 0.05f * summery.flightSpeedModifier * (float)ToolStats.FLIGHT_SPEED_MODIFIER);
                }
                if (!player.field_70122_E && player.field_71075_bZ.field_75100_b && player.field_70181_x != 0.0 && summery.flightVModifier > 0.0f) {
                    if (BrandonsCore.proxy.isJumpKeyDown() && !BrandonsCore.proxy.isSneakKeyDown()) {
                        player.field_70181_x = 0.225f * summery.flightVModifier;
                    }
                    if (BrandonsCore.proxy.isSneakKeyDown() && !BrandonsCore.proxy.isJumpKeyDown()) {
                        player.field_70181_x = -0.225f * summery.flightVModifier;
                    }
                }
                if (summery.flight[2] && player.field_191988_bg == 0.0f && player.field_70702_br == 0.0f && player.field_71075_bZ.field_75100_b) {
                    player.field_70159_w *= 0.5;
                    player.field_70179_y *= 0.5;
                }
            } else {
                if (!playersWithFlight.containsKey(player)) {
                    playersWithFlight.put(player, false);
                }
                if (playersWithFlight.get(player).booleanValue() && !player.field_70170_p.field_72995_K) {
                    playersWithFlight.put(player, false);
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71075_bZ.field_75101_c = false;
                        player.field_71075_bZ.field_75100_b = false;
                        player.func_71016_p();
                    }
                }
                if (player.field_70170_p.field_72995_K && playersWithFlight.get(player).booleanValue()) {
                    playersWithFlight.put(player, false);
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71075_bZ.field_75101_c = false;
                        player.field_71075_bZ.field_75100_b = false;
                    }
                    CustomArmorHandler.setPlayerFlySpeed(player, 0.05f);
                }
            }
        }
        IAttribute speedAttr = SharedMonsterAttributes.field_111263_d;
        if (summery != null && summery.speedModifier > 0.0f) {
            double value = summery.speedModifier;
            if (player.func_110148_a(speedAttr).func_111127_a(WALK_SPEED_UUID) == null) {
                player.func_110148_a(speedAttr).func_111121_a(new AttributeModifier(WALK_SPEED_UUID, speedAttr.func_111108_a(), value, 1));
            } else if (player.func_110148_a(speedAttr).func_111127_a(WALK_SPEED_UUID).func_111164_d() != value) {
                player.func_110148_a(speedAttr).func_111124_b(player.func_110148_a(speedAttr).func_111127_a(WALK_SPEED_UUID));
                player.func_110148_a(speedAttr).func_111121_a(new AttributeModifier(WALK_SPEED_UUID, speedAttr.func_111108_a(), value, 1));
            }
            if (!player.field_70122_E && player.func_184187_bx() == null) {
                player.field_70747_aH = 0.02f + 0.02f * summery.speedModifier;
            }
        } else if (player.func_110148_a(speedAttr).func_111127_a(WALK_SPEED_UUID) != null) {
            player.func_110148_a(speedAttr).func_111124_b(player.func_110148_a(speedAttr).func_111127_a(WALK_SPEED_UUID));
        }
        if (summery != null && player.field_70170_p.field_72995_K) {
            boolean highStepListed = playersWithUphillStep.contains(player.getDisplayNameString()) && player.field_70138_W >= 1.0f;
            boolean hasHighStep = summery.hasHillStep;
            if (hasHighStep && !highStepListed) {
                playersWithUphillStep.add(player.getDisplayNameString());
                player.field_70138_W = 1.0625f;
            }
            if (!hasHighStep && highStepListed) {
                playersWithUphillStep.remove(player.getDisplayNameString());
                player.field_70138_W = 0.6f;
            }
        }
    }

    private static void setPlayerFlySpeed(EntityPlayer player, float speed) {
        player.field_71075_bZ.func_75092_a(speed);
    }

    private static boolean applyArmorDamageBlocking(LivingAttackEvent event, ArmorSummery summery) {
        if (summery == null) {
            return false;
        }
        if (event.getSource().func_76347_k() && summery.fireResistance >= 1.0f) {
            event.setCanceled(true);
            event.getEntityLiving().func_70066_B();
            return true;
        }
        if (event.getSource().field_76373_n.equals("fall") && summery.jumpModifier > 0.0f && event.getAmount() < summery.jumpModifier * 5.0f) {
            event.setCanceled(true);
            return true;
        }
        if ((event.getSource().field_76373_n.equals("inWall") || event.getSource().field_76373_n.equals("drown")) && !((ItemStack)summery.armorStacks.get(3)).func_190926_b()) {
            if (event.getAmount() <= 2.0f) {
                event.setCanceled(true);
            }
            return true;
        }
        return false;
    }

    public static class ArmorSummery {
        public float maxProtectionPoints = 0.0f;
        public float protectionPoints = 0.0f;
        public int pieces = 0;
        public float[] allocation;
        public float[] pointsDown;
        public NonNullList<ItemStack> armorStacks;
        public NonNullList<ItemStack> baublesStacks = null;
        public float entropy = 0.0f;
        public float meanRecoveryPoints = 0.0f;
        public long totalEnergyStored = 0L;
        public long maxTotalEnergyStorage = 0L;
        public int[] energyAllocation;
        public boolean[] flight = new boolean[]{false, false, false};
        public float flightVModifier = 0.0f;
        public float speedModifier = 0.0f;
        public float jumpModifier = 0.0f;
        public float fireResistance = 0.0f;
        public float flightSpeedModifier = 0.0f;
        public boolean hasHillStep = false;
        public boolean hasDraconic = false;

        public ArmorSummery getSummery(EntityPlayer player) {
            ArrayList<ItemStack> armorStacks = new ArrayList<ItemStack>((Collection<ItemStack>)player.field_71071_by.field_70460_b);
            float totalEntropy = 0.0f;
            float totalRecoveryPoints = 0.0f;
            if (ModHelper.isBaublesInstalled) {
                this.getBaubles(player, armorStacks);
            }
            this.allocation = new float[armorStacks.size()];
            this.armorStacks = NonNullList.func_191197_a((int)armorStacks.size(), (Object)ItemStack.field_190927_a);
            this.pointsDown = new float[armorStacks.size()];
            this.energyAllocation = new int[armorStacks.size()];
            block6: for (int i = 0; i < armorStacks.size(); ++i) {
                ItemStack stack = (ItemStack)armorStacks.get(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ICustomArmor)) continue;
                ICustomArmor armor = (ICustomArmor)stack.func_77973_b();
                ++this.pieces;
                this.allocation[i] = ItemNBTHelper.getFloat((ItemStack)stack, (String)"ProtectionPoints", (float)0.0f);
                this.protectionPoints += this.allocation[i];
                totalEntropy += ItemNBTHelper.getFloat((ItemStack)stack, (String)"ShieldEntropy", (float)0.0f);
                this.armorStacks.set(i, (Object)stack);
                totalRecoveryPoints += armor.getRecoveryRate(stack);
                float maxPoints = armor.getProtectionPoints(stack);
                this.pointsDown[i] = maxPoints - this.allocation[i];
                this.maxProtectionPoints += maxPoints;
                this.energyAllocation[i] = armor.getEnergyStored(stack);
                this.totalEnergyStored += (long)this.energyAllocation[i];
                this.maxTotalEnergyStorage += (long)armor.getMaxEnergyStored(stack);
                if (stack.func_77973_b() instanceof DraconicArmor) {
                    this.hasDraconic = true;
                }
                this.fireResistance += armor.getFireResistance(stack);
                switch (i) {
                    case 3: {
                        continue block6;
                    }
                    case 2: {
                        boolean[] fa = armor.hasFlight(stack);
                        this.flight[0] = this.flight[0] || fa[0];
                        this.flight[1] = this.flight[1] || fa[1];
                        boolean bl = this.flight[2] = this.flight[2] || fa[2];
                        if (!this.flight[0]) continue block6;
                        this.flightVModifier = Math.max(this.flightVModifier, armor.getFlightVModifier(stack, player));
                        this.flightSpeedModifier = Math.max(this.flightVModifier, armor.getFlightSpeedModifier(stack, player));
                        continue block6;
                    }
                    case 1: {
                        this.speedModifier = Math.max(this.speedModifier, armor.getSpeedModifier(stack, player));
                        continue block6;
                    }
                    case 0: {
                        this.hasHillStep = this.hasHillStep || armor.hasHillStep(stack, player);
                        this.jumpModifier = Math.max(this.jumpModifier, armor.getJumpModifier(stack, player));
                        continue block6;
                    }
                    default: {
                        boolean[] fa = armor.hasFlight(stack);
                        this.flight[0] = this.flight[0] || fa[0];
                        this.flight[1] = this.flight[1] || fa[1];
                        boolean bl = this.flight[2] = this.flight[2] || fa[2];
                        if (this.flight[0]) {
                            this.flightVModifier = Math.max(this.flightVModifier, armor.getFlightVModifier(stack, player));
                            this.flightSpeedModifier = Math.max(this.flightSpeedModifier, armor.getFlightSpeedModifier(stack, player));
                        }
                        this.speedModifier = Math.max(this.speedModifier, armor.getSpeedModifier(stack, player));
                        this.hasHillStep = this.hasHillStep || armor.hasHillStep(stack, player);
                        this.jumpModifier = Math.max(this.jumpModifier, armor.getJumpModifier(stack, player));
                    }
                }
            }
            if (this.pieces == 0) {
                return null;
            }
            this.entropy = totalEntropy / (float)this.pieces;
            this.meanRecoveryPoints = totalRecoveryPoints / (float)this.pieces;
            return this;
        }

        private void getBaubles(EntityPlayer player, List<ItemStack> stacks) {
            IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
            this.baublesStacks = NonNullList.func_191197_a((int)baubles.getSlots(), (Object)ItemStack.field_190927_a);
            for (int i = 0; i < baubles.getSlots(); ++i) {
                this.baublesStacks.set(i, (Object)baubles.getStackInSlot(i).func_77946_l());
            }
            stacks.addAll((Collection<ItemStack>)this.baublesStacks);
        }

        public void saveStacks(EntityPlayer player) {
            if (ModHelper.isBaublesInstalled) {
                this.saveBaubles(player);
            }
        }

        private void saveBaubles(EntityPlayer player) {
            if (this.baublesStacks != null) {
                IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
                for (int i = 0; i < baubles.getSlots(); ++i) {
                    baubles.setStackInSlot(i, (ItemStack)this.baublesStacks.get(i));
                }
            }
        }
    }
}

