/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks;

import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.blocks.BlockContainerBase;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;
import vswe.stevescarts.helpers.Pair;
import vswe.stevescarts.packet.PacketStevesCarts;

public class BlockCartAssembler
extends BlockContainerBase {
    public BlockCartAssembler() {
        super(Material.field_151576_e);
        this.func_149647_a(StevesCarts.tabsSC2Blocks);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (entityplayer.func_70093_af()) {
            return false;
        }
        TileEntityCartAssembler assembler = (TileEntityCartAssembler)world.func_175625_s(pos);
        if (assembler != null) {
            if (!world.field_72995_K) {
                entityplayer.openGui((Object)StevesCarts.instance, 3, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return false;
    }

    public void updateMultiBlock(World world, BlockPos pos) {
        TileEntity master = world.func_175625_s(pos);
        if (master instanceof TileEntityCartAssembler) {
            ((TileEntityCartAssembler)master).clearUpgrades();
        }
        this.checkForUpgrades(world, pos);
        if (!world.field_72995_K) {
            PacketStevesCarts.sendBlockInfoToClients(world, new byte[0], pos);
        }
        if (master instanceof TileEntityCartAssembler) {
            ((TileEntityCartAssembler)master).onUpgradeUpdate();
        }
    }

    private void checkForUpgrades(World world, BlockPos pos) {
        BlockPos.PooledMutableBlockPos blockPos = BlockPos.PooledMutableBlockPos.func_185339_c((int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            blockPos.func_181079_c(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.checkForUpgrade(world, (BlockPos)blockPos.func_189536_c(facing));
        }
        blockPos.func_185344_t();
    }

    private TileEntityCartAssembler checkForUpgrade(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntityUpgrade) {
            TileEntityUpgrade upgrade = (TileEntityUpgrade)tile;
            ArrayList<Pair<TileEntityCartAssembler, EnumFacing>> masters = this.getMasters(world, pos);
            if (masters.size() == 1) {
                Pair<TileEntityCartAssembler, EnumFacing> pair = masters.get(0);
                TileEntityCartAssembler master = pair.first();
                master.addUpgrade(upgrade);
                upgrade.setMaster(master, pair.second().func_176734_d());
                return master;
            }
            world.func_175646_b(pos, tile);
            for (Pair<TileEntityCartAssembler, EnumFacing> master2 : masters) {
                master2.first().removeUpgrade(upgrade);
            }
            upgrade.setMaster(null, null);
        }
        return null;
    }

    private ArrayList<Pair<TileEntityCartAssembler, EnumFacing>> getMasters(World world, BlockPos pos) {
        ArrayList<Pair<TileEntityCartAssembler, EnumFacing>> masters = new ArrayList<Pair<TileEntityCartAssembler, EnumFacing>>();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntityCartAssembler temp = this.getMaster(world, pos.func_177972_a(facing));
            if (temp == null) continue;
            masters.add(Pair.of(temp, facing));
        }
        return masters;
    }

    private TileEntityCartAssembler getValidMaster(World world, BlockPos pos) {
        TileEntityCartAssembler master = null;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntityCartAssembler temp = this.getMaster(world, pos.func_177972_a(facing));
            if (temp == null) continue;
            if (master != null) {
                return null;
            }
            master = temp;
        }
        return master;
    }

    private TileEntityCartAssembler getMaster(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntityCartAssembler) {
            TileEntityCartAssembler master = (TileEntityCartAssembler)tile;
            if (!master.isDead) {
                return master;
            }
        }
        return null;
    }

    public void addUpgrade(World world, BlockPos pos) {
        TileEntityCartAssembler master = this.getValidMaster(world, pos);
        if (master != null) {
            this.updateMultiBlock(world, master.func_174877_v());
        }
    }

    public void removeUpgrade(World world, BlockPos pos) {
        TileEntityCartAssembler master = this.getValidMaster(world, pos);
        if (master != null) {
            this.updateMultiBlock(world, master.func_174877_v());
        }
    }

    public TileEntity func_149915_a(World world, int var2) {
        return new TileEntityCartAssembler();
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        this.updateMultiBlock(worldIn, pos);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityCartAssembler tile = (TileEntityCartAssembler)world.func_175625_s(pos);
        tile.isDead = true;
        this.updateMultiBlock(world, pos);
        if (!tile.func_191420_l()) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int i = 0; i < tile.func_70302_i_(); ++i) {
                ItemStack stack2 = tile.func_70301_a(i);
                if (TileEntityCartAssembler.getSlotStatus(stack2) <= 0) continue;
                stacks.add(stack2);
            }
            stacks.forEach(stack -> InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack));
            ItemStack outputItem = tile.getOutputOnInterupt();
            if (!outputItem.func_190926_b()) {
                EntityItem eItem = new EntityItem(world, (double)pos.func_177958_n() + (double)0.2f, (double)pos.func_177956_o() + (double)0.2f, (double)((float)pos.func_177952_p() + 0.2f), outputItem);
                eItem.field_70159_w = (float)world.field_73012_v.nextGaussian() * 0.05f;
                eItem.field_70181_x = (float)world.field_73012_v.nextGaussian() * 0.25f;
                eItem.field_70179_y = (float)world.field_73012_v.nextGaussian() * 0.05f;
                if (outputItem.func_77942_o()) {
                    eItem.func_92059_d().func_77982_d(outputItem.func_77978_p().func_74737_b());
                }
                world.func_72838_d((Entity)eItem);
            }
        }
        super.func_180663_b(world, pos, this.func_176223_P());
    }
}

