/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.guis.buttons;

import net.minecraft.entity.player.EntityPlayer;
import vswe.stevescarts.computer.ComputerTask;
import vswe.stevescarts.guis.buttons.ButtonBase;
import vswe.stevescarts.guis.buttons.ButtonFlowFor;
import vswe.stevescarts.modules.workers.ModuleComputer;

public abstract class ButtonFlowForInteger
extends ButtonFlowFor {
    private int dif;

    public ButtonFlowForInteger(ModuleComputer module, ButtonBase.LOCATION loc, int dif) {
        super(module, loc);
        this.dif = dif;
    }

    @Override
    public String toString() {
        if (this.dif < 0) {
            return "Decrease " + this.getName() + " by " + -1 * this.dif;
        }
        return "Increase " + this.getName() + " by " + this.dif;
    }

    @Override
    public int texture() {
        if (this.dif == 1) {
            return 40;
        }
        if (this.dif == -1) {
            return 41;
        }
        if (this.dif == 10) {
            return 42;
        }
        if (this.dif == -10) {
            return 43;
        }
        return super.texture();
    }

    @Override
    public boolean isVisible() {
        if (((ModuleComputer)this.module).getSelectedTasks() != null) {
            for (ComputerTask task : ((ModuleComputer)this.module).getSelectedTasks()) {
                if (!this.isVarVisible(task)) continue;
                return false;
            }
        }
        return super.isVisible();
    }

    @Override
    public boolean isEnabled() {
        for (ComputerTask task : ((ModuleComputer)this.module).getSelectedTasks()) {
            if (-128 > this.getInteger(task) + this.dif || this.getInteger(task) + this.dif > 127) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onServerClick(EntityPlayer player, int mousebutton, boolean ctrlKey, boolean shiftKey) {
        for (ComputerTask task : ((ModuleComputer)this.module).getSelectedTasks()) {
            this.setInteger(task, this.getInteger(task) + this.dif);
        }
    }

    protected abstract String getName();

    protected abstract boolean isVarVisible(ComputerTask var1);

    protected abstract int getInteger(ComputerTask var1);

    protected abstract void setInteger(ComputerTask var1, int var2);
}

