/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.items;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.items.ModItems;
import vswe.stevescarts.modules.ModuleBase;
import vswe.stevescarts.modules.data.ModuleData;

public class ItemCartModule
extends Item
implements ModItems.IMultipleItemModelDefinition {
    public ItemCartModule() {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(StevesCarts.tabsSC2);
    }

    public String getName(@Nonnull ItemStack par1ItemStack) {
        ModuleData data = this.getModuleData(par1ItemStack, true);
        if (data == null) {
            return "Unknown SC2 module";
        }
        return data.getName();
    }

    public String func_77658_a() {
        return "item.SC2:unknownmodule";
    }

    public String func_77667_c(@Nonnull ItemStack item) {
        ModuleData data = this.getModuleData(item, true);
        if (data != null) {
            return "item.SC2:" + data.getRawName();
        }
        return this.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (ModuleData module : ModuleData.getList().values()) {
            if (module.getIsLocked() || !module.getIsValid()) continue;
            items.add((Object)module.getItemStack());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        ModuleData module = this.getModuleData(stack, true);
        if (module != null) {
            module.addInformation(tooltip, stack.func_77978_p());
        } else if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemCartModule) {
            tooltip.add("Module id " + stack.func_77952_i());
        } else {
            tooltip.add("Unknown module id");
        }
    }

    public ModuleData getModuleData(@Nonnull ItemStack itemstack) {
        return this.getModuleData(itemstack, false);
    }

    public ModuleData getModuleData(@Nonnull ItemStack itemstack, boolean ignoreSize) {
        if (!itemstack.func_190926_b() && itemstack.func_77973_b() instanceof ItemCartModule && (ignoreSize || TileEntityCartAssembler.getSlotStatus(itemstack) != TileEntityCartAssembler.getRemovedSize())) {
            return ModuleData.getList().get((byte)itemstack.func_77952_i());
        }
        return null;
    }

    public void addExtraDataToCart(NBTTagCompound save, @Nonnull ItemStack module, int i) {
        if (module.func_77978_p() != null && module.func_77978_p().func_74764_b("Data")) {
            save.func_74774_a("Data" + i, module.func_77978_p().func_74771_c("Data"));
        } else {
            ModuleData data = this.getModuleData(module, true);
            if (data.isUsingExtraData()) {
                save.func_74774_a("Data" + i, data.getDefaultExtraData());
            }
        }
    }

    public void addExtraDataToModule(NBTTagCompound save, ModuleBase module, int i) {
        if (module.hasExtraData()) {
            save.func_74774_a("Data" + i, module.getExtraData());
        }
    }

    public void addExtraDataToModule(@Nonnull ItemStack module, NBTTagCompound info, int i) {
        NBTTagCompound save = module.func_77978_p();
        if (save == null) {
            save = new NBTTagCompound();
            module.func_77982_d(save);
        }
        if (info != null && info.func_74764_b("Data" + i)) {
            save.func_74774_a("Data", info.func_74771_c("Data" + i));
        } else {
            ModuleData data = this.getModuleData(module, true);
            if (data.isUsingExtraData()) {
                save.func_74774_a("Data", data.getDefaultExtraData());
            }
        }
    }

    @Override
    public Map<Integer, ResourceLocation> getModels() {
        HashMap<Integer, ResourceLocation> map = new HashMap<Integer, ResourceLocation>();
        for (ModuleData data : ModuleData.getList().values()) {
            String name = data.getRawName();
            if (name == null) continue;
            map.put(Integer.valueOf(data.getID()), new ResourceLocation("stevescarts", "module_" + name));
        }
        return map;
    }
}

