/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.models.engines;

import java.util.ArrayList;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.models.engines.ModelSolarPanel;
import vswe.stevescarts.modules.ModuleBase;
import vswe.stevescarts.modules.engines.ModuleSolarTop;

@SideOnly(value=Side.CLIENT)
public class ModelSolarPanelHeads
extends ModelSolarPanel {
    private static ResourceLocation texture = ResourceHelper.getResource("/models/panelModelActive.png");
    private static ResourceLocation texture2 = ResourceHelper.getResource("/models/panelModelIdle.png");
    ArrayList<ModelRenderer> panels = new ArrayList();

    @Override
    public ResourceLocation getResource(ModuleBase module) {
        if (module != null && ((ModuleSolarTop)module).getLight() == 15) {
            return texture;
        }
        return texture2;
    }

    @Override
    protected int getTextureWidth() {
        return 32;
    }

    @Override
    protected int getTextureHeight() {
        return 16;
    }

    public ModelSolarPanelHeads(int panelCount) {
        ModelRenderer moving = this.createMovingHolder(0, 0);
        for (int i = 0; i < panelCount; ++i) {
            this.createPanel(moving, i);
        }
    }

    private void createPanel(ModelRenderer base, int index) {
        float rotation = 0.0f;
        float f = 0.0f;
        switch (index) {
            case 0: {
                rotation = 0.0f;
                f = -1.5f;
                break;
            }
            case 1: {
                rotation = (float)Math.PI;
                f = -1.5f;
                break;
            }
            case 2: {
                rotation = 4.712389f;
                f = -6.0f;
                break;
            }
            case 3: {
                rotation = 1.5707964f;
                f = -6.0f;
                break;
            }
            default: {
                return;
            }
        }
        this.createPanel(base, rotation, f);
    }

    private void createPanel(ModelRenderer base, float rotation, float f) {
        ModelRenderer panel = new ModelRenderer((ModelBase)this, 0, 0);
        this.fixSize(panel);
        base.func_78792_a(panel);
        panel.func_78790_a(-6.0f, 0.0f, -2.0f, 12, 13, 2, 0.0f);
        panel.func_78793_a((float)Math.sin(rotation) * f, -5.0f, (float)Math.cos(rotation) * f);
        panel.field_78796_g = rotation;
        this.panels.add(panel);
    }

    @Override
    public void applyEffects(ModuleBase module, float yaw, float pitch, float roll) {
        super.applyEffects(module, yaw, pitch, roll);
        for (ModelRenderer panel : this.panels) {
            panel.field_78795_f = module == null ? 0.0f : -((ModuleSolarTop)module).getInnerRotation();
        }
    }
}

