/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.blocks.tiles;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import p455w0rd.danknull.api.IRedstoneControllable;
import p455w0rd.danknull.init.ModDataFixing;
import p455w0rd.danknull.integration.Albedo;
import p455w0rd.danknull.integration.PwLib;
import p455w0rd.danknull.inventory.DankNullSidedInvWrapper;
import p455w0rd.danknull.items.ItemDankNull;
import p455w0rd.danknull.network.VanillaPacketDispatcher;
import p455w0rd.danknull.util.DankNullUtils;

public class TileDankNullDock
extends TileEntity
implements IRedstoneControllable,
ISidedInventory {
    private RedstoneMode redstoneMode = RedstoneMode.REQUIRED;
    private boolean hasRedstoneSignal = false;
    private final NonNullList<ItemStack> slots = NonNullList.func_191196_a();
    ItemStack dankNull = ItemStack.field_190927_a;
    private final ModDataFixing.DankNullFixer fixer = new ModDataFixing.DankNullFixer(FixTypes.BLOCK_ENTITY);

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return !this.getDankNull().func_190926_b() && (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (facing == EnumFacing.DOWN || facing == EnumFacing.UP) || p455w0rdslib.integration.Albedo.albedoCapCheck(capability) || PwLib.checkCap(capability) || super.hasCapability(capability, facing));
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (!this.getDankNull().func_190926_b()) {
            if (p455w0rdslib.integration.Albedo.albedoCapCheck(capability)) {
                return Albedo.getTileCapability(this.func_174877_v(), this.getDankNull());
            }
            if (PwLib.checkCap(capability)) {
                return PwLib.getTileCapability(this);
            }
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (facing == EnumFacing.DOWN || facing == EnumFacing.UP)) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new DankNullSidedInvWrapper(this, facing));
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public void removeDankNull() {
        if (!this.getDankNull().func_190926_b()) {
            this.setDankNull(ItemStack.field_190927_a);
        }
    }

    public void setDankNull(ItemStack dankNull) {
        this.dankNull = new ItemStack(this.fixer.func_188217_a(dankNull.serializeNBT()));
        this.func_70296_d();
    }

    public int slotCount() {
        return !this.getDankNull().func_190926_b() ? DankNullUtils.getMeta(this.getDankNull()) + 9 : 0;
    }

    public ItemStack getSelectedStack() {
        return this.getDankNull().func_190926_b() ? ItemStack.field_190927_a : DankNullUtils.getSelectedStack(DankNullUtils.getNewDankNullInventory(this.getDankNull()));
    }

    public ItemStack getDankNull() {
        return this.dankNull;
    }

    public NonNullList<ItemStack> getSlots() {
        return this.slots;
    }

    @Override
    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
        this.redstoneMode = mode;
        this.func_70296_d();
    }

    @Override
    public boolean isRedstoneRequirementMet() {
        switch (this.getRedstoneMode()) {
            default: {
                return true;
            }
            case REQUIRED: {
                return this.hasRSSignal();
            }
            case REQUIRE_NONE: 
        }
        return !this.hasRSSignal();
    }

    @Override
    public boolean hasRSSignal() {
        return this.hasRedstoneSignal;
    }

    @Override
    public void setRSSignal(boolean isPowered) {
        this.hasRedstoneSignal = isPowered;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 255, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public void func_70296_d() {
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        super.func_70296_d();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_150297_b("DankNullStack", 10)) {
            this.setDankNull(new ItemStack(nbt.func_74775_l("DankNullStack")));
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74782_a("DankNullStack", (NBTBase)this.getDankNull().serializeNBT());
        return compound;
    }

    public int func_70302_i_() {
        return !this.getDankNull().func_190926_b() ? DankNullUtils.getSizeInventory(this.getDankNull()) : 0;
    }

    public ItemStack func_70301_a(int index) {
        ItemStack stack;
        if (!this.getDankNull().func_190926_b() && !(stack = DankNullUtils.getStackInDankNullSlotWithSize(this.getDankNull(), index)).func_190926_b()) {
            int amountToBeKept = DankNullUtils.getExtractionModeForStack(this.getDankNull(), stack).getNumberToKeep();
            if (stack.func_190916_E() > amountToBeKept) {
                ItemStack availableStack = stack.func_77946_l();
                availableStack.func_190920_e(stack.func_190916_E() - amountToBeKept);
                return availableStack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getActualStackInSlot(int index) {
        if (!this.getDankNull().func_190926_b()) {
            return DankNullUtils.getStackInDankNullSlotWithSize(this.getDankNull(), index);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack ret;
        ItemStack itemStack = ret = !this.getDankNull().func_190926_b() ? DankNullUtils.decrStackSize(this.getDankNull(), index, count) : ItemStack.field_190927_a;
        if (!this.getDankNull().func_190926_b()) {
            DankNullUtils.reArrangeStacks(this.getDankNull());
        }
        this.func_70296_d();
        return ret;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (!this.getDankNull().func_190926_b()) {
            DankNullUtils.setStackInSlot(this.getDankNull(), index, stack);
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return !this.getDankNull().func_190926_b() ? Integer.MAX_VALUE : 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.getDankNull().func_190926_b() ? false : !(stack.func_77973_b() instanceof ItemDankNull);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return "danknull-inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (!this.getDankNull().func_190926_b() && side == EnumFacing.DOWN || side == EnumFacing.UP) {
            int[] slots = new int[this.func_70302_i_()];
            for (int i = 0; i < slots.length; ++i) {
                slots[i] = i;
            }
            return slots;
        }
        return new int[0];
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing side) {
        return side == EnumFacing.UP && DankNullUtils.isFiltered(this.getDankNull(), stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing side) {
        return !this.getDankNull().func_190926_b() && DankNullUtils.getExtractionModeForStack(this.getDankNull(), stack) != DankNullUtils.ItemExtractionMode.KEEP_ALL;
    }

    public boolean func_191420_l() {
        return !this.getDankNull().func_190926_b();
    }

    public static enum RedstoneMode {
        REQUIRED,
        REQUIRE_NONE,
        IGNORED;

    }
}

