/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import p455w0rd.danknull.init.ModGlobals;
import p455w0rd.danknull.inventory.PlayerSlot;
import p455w0rd.danknull.items.ItemDankNull;
import p455w0rd.danknull.util.DankNullUtils;
import p455w0rdslib.util.ItemNBTUtils;

public class InventoryDankNull
implements IInventory {
    private final NonNullList<ItemStack> itemStacks;
    private int[] stackSizes;
    private EntityPlayer player;
    private PlayerSlot dankNullSlot = null;
    private String itemUUID = "";
    private ItemStack tileStack = null;

    public InventoryDankNull(PlayerSlot dankNullSlot, EntityPlayer player) {
        this.dankNullSlot = dankNullSlot;
        this.player = player;
        this.itemUUID = ItemNBTUtils.getString((ItemStack)this.getDankNull(), (String)"UUID");
        this.itemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        this.stackSizes = new int[this.func_70302_i_()];
        this.loadInventory(this.getDNTag());
    }

    public InventoryDankNull(ItemStack stack) {
        this.tileStack = stack;
        this.itemUUID = ItemNBTUtils.getString((ItemStack)this.getDankNull(), (String)"UUID");
        this.itemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        this.stackSizes = new int[this.func_70302_i_()];
        this.loadInventory(this.getDNTag());
    }

    public int func_70302_i_() {
        int numRows = DankNullUtils.getMeta(this.getDankNull()) + 1;
        if (DankNullUtils.isCreativeDankNull(this.getDankNull())) {
            --numRows;
        }
        return numRows * 9;
    }

    public ItemStack func_70301_a(int index) {
        if (DankNullUtils.isCreativeDankNull(this.getDankNull()) && index < this.func_70302_i_() && !((ItemStack)this.itemStacks.get(index)).func_190926_b()) {
            ItemStack tmp = ((ItemStack)this.itemStacks.get(index)).func_77946_l();
            tmp.func_190920_e(Integer.MAX_VALUE);
            return tmp;
        }
        return index < this.itemStacks.size() ? (ItemStack)this.itemStacks.get(index) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int amount) {
        if (!this.func_70301_a(index).func_190926_b()) {
            if (DankNullUtils.isCreativeDankNull(this.getDankNull())) {
                ItemStack tmp = this.func_70301_a(index).func_77946_l();
                tmp.func_190920_e(Integer.MAX_VALUE);
                return tmp;
            }
            if (this.func_70301_a(index).func_190916_E() <= amount) {
                ItemStack itemstack = this.func_70301_a(index);
                this.itemStacks.set(index, (Object)ItemStack.field_190927_a);
                this.setSizeForSlot(index, 0);
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack1 = this.func_70301_a(index).func_77979_a(amount);
            this.setSizeForSlot(index, this.getSizeForSlot(index) - amount);
            if (this.func_70301_a(index).func_190916_E() == 0) {
                this.itemStacks.set(index, (Object)ItemStack.field_190927_a);
            }
            this.func_70296_d();
            return itemstack1;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack itemStack) {
        this.itemStacks.set(index, (Object)itemStack);
        this.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return !(stack.func_77973_b() instanceof ItemDankNull);
    }

    public String func_70005_c_() {
        return "danknull-inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        if (!stack.func_190926_b()) {
            this.itemStacks.set(index, (Object)ItemStack.field_190927_a);
        }
        this.func_70296_d();
        return stack;
    }

    public int func_70297_j_() {
        return Integer.MAX_VALUE;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.itemStacks.clear();
    }

    public ModGlobals.DankNullTier getTier() {
        return DankNullUtils.getTier(this.getDankNull());
    }

    public NonNullList<ItemStack> getStacks() {
        return this.itemStacks;
    }

    public int getSizeForSlot(int index) {
        return index >= 0 ? (DankNullUtils.isCreativeDankNull(this.getDankNull()) ? Integer.MAX_VALUE : this.stackSizes[index]) : 0;
    }

    public void setSizeForSlot(int index, int size) {
        if (DankNullUtils.isCreativeDankNull(this.getDankNull())) {
            size = Integer.MAX_VALUE;
        }
        if (index >= this.stackSizes.length) {
            int[] oldSizes = this.stackSizes;
            int[] newSizes = new int[index - 1];
            for (int i : oldSizes) {
                newSizes[i] = oldSizes[i];
            }
            this.stackSizes = newSizes;
        }
        this.stackSizes[index] = size < 0 ? 0 : size;
    }

    public long getMaxStackSize() {
        return this.getTier().getMaxStackSize();
    }

    public boolean func_191420_l() {
        for (int x = 0; x < this.func_70302_i_(); ++x) {
            if (this.func_70301_a(x).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getDankNull() {
        if (this.tileStack != null) {
            return this.tileStack;
        }
        return this.dankNullSlot.getStackInSlot(this.getPlayer());
    }

    public int getPlayerSlotIndex() {
        return this.dankNullSlot.getSlotIndex();
    }

    public PlayerSlot getPlayerSlot() {
        return this.dankNullSlot;
    }

    public NBTTagCompound getDNTag() {
        ItemStack dn = this.getDankNull();
        if (!dn.func_77942_o()) {
            dn.func_77982_d(this.saveInventory(new NBTTagCompound()));
        }
        return dn.func_77978_p();
    }

    public void func_70296_d() {
        if (!this.isValid()) {
            return;
        }
        ItemStack stack = this.getDankNull();
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        this.saveInventory(stack.func_77978_p());
        if (this.dankNullSlot != null) {
            this.dankNullSlot.setStackInSlot(this.getPlayer(), stack);
        }
    }

    public NBTTagCompound saveInventory(NBTTagCompound compound) {
        NBTTagList nbtTL = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            NBTTagCompound nbtTC = new NBTTagCompound();
            nbtTC.func_74768_a("Slot", i);
            nbtTC.func_74768_a("RealCount", this.func_70301_a(i).func_190916_E() <= this.getTier().getMaxStackSize() ? this.func_70301_a(i).func_190916_E() : this.getTier().getMaxStackSize());
            this.writeStackToNBT(this.func_70301_a(i), nbtTC);
            nbtTL.func_74742_a((NBTBase)nbtTC);
        }
        if (this.itemUUID != null && !this.itemUUID.isEmpty()) {
            compound.func_74778_a("UUID", this.itemUUID);
        }
        compound.func_74782_a(this.func_70005_c_(), (NBTBase)nbtTL);
        return compound;
    }

    private NBTTagCompound writeStackToNBT(ItemStack stack, NBTTagCompound nbt) {
        NBTTagCompound cnbt;
        CapabilityDispatcher caps;
        ResourceLocation resourcelocation = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b());
        nbt.func_74778_a("id", resourcelocation == null ? "minecraft:air" : resourcelocation.toString());
        nbt.func_74768_a("Count", stack.func_190916_E());
        nbt.func_74777_a("Damage", (short)((byte)stack.func_77952_i()));
        if (stack.func_77942_o()) {
            nbt.func_74782_a("tag", (NBTBase)stack.func_77978_p());
        }
        if ((caps = this.getStackCaps(stack)) != null && !(cnbt = caps.serializeNBT()).func_82582_d()) {
            nbt.func_74782_a("ForgeCaps", (NBTBase)cnbt);
        }
        return nbt;
    }

    private CapabilityDispatcher getStackCaps(ItemStack stack) {
        return (CapabilityDispatcher)ObfuscationReflectionHelper.getPrivateValue(ItemStack.class, (Object)stack, (String)"capabilities");
    }

    public void loadInventory(NBTTagCompound compound) {
        NBTTagList nbtTL = compound.func_150295_c(this.func_70005_c_(), 10);
        for (int i = 0; i < nbtTL.func_74745_c(); ++i) {
            NBTTagCompound nbtTC = nbtTL.func_150305_b(i);
            int slot = nbtTC.func_74762_e("Slot");
            ItemStack stack = new ItemStack(nbtTC);
            if (nbtTC.func_74764_b("RealCount")) {
                stack.func_190920_e(nbtTC.func_74762_e("RealCount"));
                this.setSizeForSlot(slot, nbtTC.func_74762_e("RealCount"));
            }
            this.itemStacks.set(slot, (Object)stack);
        }
        if (compound.func_150297_b("UUID", 8)) {
            this.itemUUID = compound.func_74779_i("UUID");
        }
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public boolean isValid() {
        if (this.itemUUID.isEmpty()) {
            return false;
        }
        String itemUUID = ItemNBTUtils.getString((ItemStack)this.getDankNull(), (String)"UUID");
        return itemUUID.equals(this.itemUUID);
    }
}

