/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;
import p455w0rd.danknull.DankNull;
import p455w0rd.danknull.inventory.InventoryDankNull;
import p455w0rd.danknull.inventory.PlayerSlot;
import p455w0rd.danknull.util.DankNullUtils;
import p455w0rdslib.util.EasyMappings;

public class PacketSyncDankNull
implements IMessage {
    private int[] stackSizes;
    private int slot;
    private ItemStack dankNull;
    private boolean isLocked;

    public void fromBytes(ByteBuf buf) {
        this.slot = buf.readInt();
        this.dankNull = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.stackSizes = new int[buf.readInt()];
        for (int i = 0; i < this.stackSizes.length - 1; ++i) {
            this.stackSizes[i] = buf.readInt();
        }
        this.isLocked = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.slot);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.dankNull);
        InventoryDankNull inv = DankNullUtils.getNewDankNullInventory(this.dankNull);
        buf.writeInt(inv.func_70302_i_());
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            buf.writeInt(DankNullUtils.getNewDankNullInventory(this.dankNull).getSizeForSlot(i));
        }
        buf.writeBoolean(this.isLocked);
    }

    public PacketSyncDankNull() {
    }

    public PacketSyncDankNull(PlayerSlot slot, ItemStack dankNull) {
        this(slot.getSlotIndex(), dankNull);
    }

    public PacketSyncDankNull(Pair<Integer, ItemStack> syncedDankNull) {
        this((Integer)syncedDankNull.getLeft(), (ItemStack)syncedDankNull.getRight());
    }

    public PacketSyncDankNull(int slot, ItemStack stack) {
        this.slot = slot;
        this.dankNull = stack;
        this.isLocked = DankNullUtils.isCreativeDankNullLocked(stack);
    }

    public static class Handler
    implements IMessageHandler<PacketSyncDankNull, IMessage> {
        public IMessage onMessage(PacketSyncDankNull message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                if (ctx.side == Side.CLIENT) {
                    this.handleToClient(message, ctx);
                } else {
                    this.handleToServer(message, ctx);
                }
            });
            return null;
        }

        private void handleToServer(PacketSyncDankNull message, MessageContext ctx) {
            this.handle(message, (EntityPlayer)ctx.getServerHandler().field_147369_b, ctx.side);
        }

        private void handleToClient(PacketSyncDankNull message, MessageContext ctx) {
            this.handle(message, EasyMappings.player(), ctx.side);
            DankNull.PROXY.setGuiInventory(DankNullUtils.getNewDankNullInventory(message.dankNull));
        }

        private void handle(PacketSyncDankNull message, EntityPlayer player, Side side) {
            ItemStack stack = message.dankNull;
            player.field_71071_by.func_70299_a(message.slot, stack);
            DankNullUtils.setLocked(stack, message.isLocked);
        }
    }
}

