/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.common.inventory;

import c4.conarm.client.gui.GuiArmorStation;
import c4.conarm.common.inventory.SlotArmorStationIn;
import c4.conarm.common.inventory.SlotArmorStationOut;
import c4.conarm.common.network.ArmorStationSelectionPacket;
import c4.conarm.common.network.ArmorStationTextPacket;
import c4.conarm.common.tileentities.TileArmorStation;
import c4.conarm.lib.ArmoryRegistry;
import c4.conarm.lib.armor.ArmorCore;
import c4.conarm.lib.modifiers.IArmorModifyable;
import c4.conarm.lib.tinkering.ArmorBuilder;
import c4.conarm.lib.tinkering.TinkersArmor;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.StringUtils;
import net.minecraft.world.WorldServer;
import slimeknights.mantle.inventory.BaseContainer;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.mantle.util.ItemStackList;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.events.TinkerCraftingEvent;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.tinkering.IRepairable;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolBuilder;
import slimeknights.tconstruct.tools.common.inventory.ContainerTinkerStation;

public class ContainerArmorStation
extends ContainerTinkerStation<TileArmorStation> {
    private final EntityPlayer player;
    protected SlotArmorStationOut out;
    protected ArmorCore selectedArmor;
    protected int activeSlots;
    public String armorName;
    protected boolean isUpgraded;

    public ContainerArmorStation(InventoryPlayer playerInventory, TileArmorStation tile, boolean isUpgraded) {
        super((TileEntity)tile);
        int i;
        this.player = playerInventory.field_70458_d;
        this.isUpgraded = isUpgraded;
        for (i = 0; i < tile.func_70302_i_(); ++i) {
            this.func_75146_a(new SlotArmorStationIn((IInventory)tile, i, 0, 0, (Container)this));
        }
        this.out = new SlotArmorStationOut(i, 124, 38, this);
        this.func_75146_a(this.out);
        this.addPlayerInventory(playerInventory, 8, 92);
        this.func_75130_a((IInventory)playerInventory);
    }

    public ItemStack getResult() {
        return this.out.func_75211_c();
    }

    protected void syncNewContainer(EntityPlayerMP player) {
        this.activeSlots = ((TileArmorStation)this.tile).func_70302_i_();
        TinkerNetwork.sendTo((AbstractPacket)new ArmorStationSelectionPacket(null, ((TileArmorStation)this.tile).func_70302_i_()), (EntityPlayerMP)player);
    }

    protected void syncWithOtherContainer(BaseContainer<TileArmorStation> otherContainer, EntityPlayerMP player) {
        this.syncWithOtherContainer((ContainerArmorStation)otherContainer, player);
    }

    protected void syncWithOtherContainer(ContainerArmorStation otherContainer, EntityPlayerMP player) {
        this.setArmorSelection(otherContainer.selectedArmor, otherContainer.activeSlots);
        this.setArmorName(otherContainer.armorName);
        TinkerNetwork.sendTo((AbstractPacket)new ArmorStationSelectionPacket(otherContainer.selectedArmor, otherContainer.activeSlots), (EntityPlayerMP)player);
        if (otherContainer.armorName != null && !otherContainer.armorName.isEmpty()) {
            TinkerNetwork.sendTo((AbstractPacket)new ArmorStationTextPacket(otherContainer.armorName), (EntityPlayerMP)player);
        }
    }

    public void setArmorSelection(ArmorCore armor, int activeSlots) {
        if (activeSlots > ((TileArmorStation)this.tile).func_70302_i_()) {
            activeSlots = ((TileArmorStation)this.tile).func_70302_i_();
        }
        this.activeSlots = activeSlots;
        this.selectedArmor = armor;
        for (int i = 0; i < ((TileArmorStation)this.tile).func_70302_i_(); ++i) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            if (!(slot instanceof SlotArmorStationIn)) continue;
            SlotArmorStationIn slotArmorPart = (SlotArmorStationIn)slot;
            slotArmorPart.setRestriction(null);
            if (i >= activeSlots) {
                slotArmorPart.deactivate();
            } else {
                List<PartMaterialType> pmts;
                slotArmorPart.activate();
                if (armor != null && i < (pmts = armor.getArmorBuildComponents()).size()) {
                    slotArmorPart.setRestriction(pmts.get(i));
                }
            }
            if (!this.world.field_72995_K) continue;
            slotArmorPart.updateIcon();
        }
    }

    public void setArmorName(String name) {
        GuiScreen screen;
        this.armorName = name;
        if (this.world.field_72995_K && (screen = Minecraft.func_71410_x().field_71462_r) instanceof GuiArmorStation) {
            ((GuiArmorStation)screen).textField.func_146180_a(name);
        }
        this.func_75130_a((IInventory)this.tile);
        if (this.out.func_75216_d()) {
            if (name != null && !name.isEmpty()) {
                this.out.field_75224_c.func_70301_a(0).func_151001_c(name);
            } else {
                this.out.field_75224_c.func_70301_a(0).func_135074_t();
            }
        }
    }

    public void func_75130_a(IInventory inventoryIn) {
        this.updateGUI();
        try {
            ItemStack result = this.repairArmor(false);
            if (result.func_190926_b()) {
                result = this.replaceArmorParts(false);
            }
            if (result.func_190926_b()) {
                result = this.modifyArmor(false);
            }
            if (result.func_190926_b()) {
                result = this.renameArmor();
            }
            if (result.func_190926_b()) {
                result = this.buildArmor();
            }
            this.out.field_75224_c.func_70299_a(0, result);
            this.updateGUI();
        }
        catch (TinkerGuiException e) {
            this.out.field_75224_c.func_70299_a(0, ItemStack.field_190927_a);
            this.error(e.getMessage());
        }
        if (!this.world.field_72995_K) {
            WorldServer server = (WorldServer)this.world;
            for (EntityPlayer player : server.field_73010_i) {
                if (player.field_71070_bA == this || !(player.field_71070_bA instanceof ContainerArmorStation) || !this.sameGui((BaseContainer)((ContainerArmorStation)player.field_71070_bA))) continue;
                ((ContainerArmorStation)player.field_71070_bA).out.field_75224_c.func_70299_a(0, this.out.func_75211_c());
            }
        }
    }

    public void onResultTaken(EntityPlayer playerIn, ItemStack stack) {
        boolean resultTaken = false;
        try {
            resultTaken = !this.repairArmor(true).func_190926_b() || !this.replaceArmorParts(true).func_190926_b() || !this.modifyArmor(true).func_190926_b() || !this.renameArmor().func_190926_b();
        }
        catch (TinkerGuiException e) {
            e.printStackTrace();
        }
        if (resultTaken) {
            this.updateSlotsAfterArmorAction();
        } else {
            try {
                ItemStack tool = this.buildArmor();
                if (!tool.func_190926_b()) {
                    for (int i = 0; i < ((TileArmorStation)this.tile).func_70302_i_(); ++i) {
                        ((TileArmorStation)this.tile).func_70298_a(i, 1);
                    }
                    this.setArmorName("");
                }
            }
            catch (TinkerGuiException e) {
                e.printStackTrace();
            }
        }
        this.func_75130_a(null);
        this.playCraftSound(playerIn);
    }

    protected void playCraftSound(EntityPlayer player) {
        Sounds.playSoundForAll((Entity)player, (SoundEvent)Sounds.saw, (float)0.8f, (float)(0.8f + 0.4f * TConstruct.random.nextFloat()));
    }

    private ItemStack repairArmor(boolean remove) {
        ItemStack repairable = ((Slot)this.field_75151_b.get(0)).func_75211_c();
        if (repairable.func_190926_b() || !(repairable.func_77973_b() instanceof IRepairable)) {
            return ItemStack.field_190927_a;
        }
        return ToolBuilder.tryRepairTool(this.getInputs(), (ItemStack)repairable, (boolean)remove);
    }

    private ItemStack replaceArmorParts(boolean remove) throws TinkerGuiException {
        ItemStack armor = ((Slot)this.field_75151_b.get(0)).func_75211_c();
        if (armor.func_190926_b() || !(armor.func_77973_b() instanceof TinkersArmor)) {
            return ItemStack.field_190927_a;
        }
        NonNullList<ItemStack> inputs = this.getInputs();
        ItemStack result = ArmorBuilder.tryReplaceArmorParts(armor, inputs, remove);
        if (!result.func_190926_b()) {
            TinkerCraftingEvent.ToolPartReplaceEvent.fireEvent((ItemStack)result, (EntityPlayer)this.player, inputs);
        }
        return result;
    }

    private ItemStack modifyArmor(boolean remove) throws TinkerGuiException {
        ItemStack modifyable = ((Slot)this.field_75151_b.get(0)).func_75211_c();
        if (modifyable.func_190926_b() || !(modifyable.func_77973_b() instanceof IArmorModifyable)) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = ArmorBuilder.tryModifyArmor(this.getInputs(), modifyable, remove);
        if (!result.func_190926_b()) {
            if (!this.isUpgraded) {
                throw new TinkerGuiException(Util.translate((String)"gui.error.modifier_on_station", (Object[])new Object[0]));
            }
            TinkerCraftingEvent.ToolModifyEvent.fireEvent((ItemStack)result, (EntityPlayer)this.player, (ItemStack)modifyable.func_77946_l());
        }
        return result;
    }

    private ItemStack renameArmor() throws TinkerGuiException {
        ItemStack armorStack = this.getArmorStack();
        if (armorStack.func_190926_b() || !(armorStack.func_77973_b() instanceof TinkersArmor) || StringUtils.func_151246_b((String)this.armorName) || armorStack.func_82833_r().equals(this.armorName)) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = armorStack.func_77946_l();
        if (TagUtil.getNoRenameFlag((ItemStack)result)) {
            throw new TinkerGuiException(Util.translate((String)"gui.error.no_rename", (Object[])new Object[0]));
        }
        result.func_151001_c(this.armorName);
        return result;
    }

    private ItemStack buildArmor() throws TinkerGuiException {
        ItemStackList input = ItemStackList.withSize((int)((TileArmorStation)this.tile).func_70302_i_());
        for (int i = 0; i < input.size(); ++i) {
            input.set(i, (Object)((TileArmorStation)this.tile).func_70301_a(i));
        }
        ItemStack result = ArmorBuilder.tryBuildArmor((NonNullList<ItemStack>)input, this.armorName, this.getBuildableArmor());
        if (!result.func_190926_b()) {
            TinkerCraftingEvent.ToolCraftingEvent.fireEvent((ItemStack)result, (EntityPlayer)this.player, (NonNullList)input);
        }
        return result;
    }

    private ItemStack getArmorStack() {
        return ((Slot)this.field_75151_b.get(0)).func_75211_c();
    }

    protected Set<ArmorCore> getBuildableArmor() {
        return ArmoryRegistry.getArmorCrafting();
    }

    private void updateSlotsAfterArmorAction() {
        ((TileArmorStation)this.tile).func_70299_a(0, ItemStack.field_190927_a);
        for (int i = 1; i < ((TileArmorStation)this.tile).func_70302_i_(); ++i) {
            if (((TileArmorStation)this.tile).func_70301_a(i).func_190926_b() || ((TileArmorStation)this.tile).func_70301_a(i).func_190916_E() != 0) continue;
            ((TileArmorStation)this.tile).func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    private NonNullList<ItemStack> getInputs() {
        NonNullList input = NonNullList.func_191197_a((int)(((TileArmorStation)this.tile).func_70302_i_() - 1), (Object)ItemStack.field_190927_a);
        for (int i = 1; i < ((TileArmorStation)this.tile).func_70302_i_(); ++i) {
            input.set(i - 1, (Object)((TileArmorStation)this.tile).func_70301_a(i));
        }
        return input;
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot != this.out && super.func_94530_a(stack, slot);
    }
}

