/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.chat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.creeperhost.minetogether.chat.ChatUtil;
import net.creeperhost.minetogether.chat.Message;
import net.creeperhost.minetogether.chat.PrivateChat;
import net.creeperhost.minetogether.common.IHost;
import net.creeperhost.minetogether.common.LimitedSizeQueue;
import net.creeperhost.minetogether.net.engio.mbassy.listener.Handler;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.WhoisCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.Channel;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.User;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.WhoisData;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ChannelMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ChannelUserMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ModeStatus;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelInviteEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelJoinEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelKickEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelMessageEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelModeEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelNoticeEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelPartEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientNegotiationCompleteEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.NickRejectedEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.connection.ClientConnectionClosedEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.connection.ClientConnectionEndedEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.PrivateCtcpQueryEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.PrivateMessageEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.PrivateNoticeEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.UserQuitEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.WhoisEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Format;
import net.creeperhost.minetogether.serverlist.data.Friend;

public class ChatHandler {
    public static final Object ircLock = new Object();
    public static TreeMap<String, Boolean> newMessages = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private static ChatUtil.IRCServer IRC_SERVER;
    public static String CHANNEL;
    public static ConnectionStatus connectionStatus;
    public static HashMap<String, String> curseSync;
    public static TreeMap<String, LimitedSizeQueue<Message>> messages;
    private static Client client;
    private static IHost host;
    private static boolean online;
    public static boolean isInitting;
    public static int tries;
    private static boolean inited;
    public static List<String> badwords;
    public static String badwordsFormat;
    public static String currentGroup;
    public static String initedString;
    private static String nick;
    private static String realName;
    public static PrivateChat privateChatList;
    public static PrivateChat privateChatInvite;
    public static boolean hasGroup;
    public static HashMap<String, String> friends;
    public static HashMap<String, String> anonUsers;
    public static HashMap<String, String> anonUsersReverse;
    public static ArrayList<String> autocompleteNames;
    public static Random random;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String nickIn, String realNameIn, boolean onlineIn, IHost _host) {
        if (inited || isInitting) {
            return;
        }
        if (!connectionStatus.equals((Object)ConnectionStatus.DISCONNECTED)) {
            return;
        }
        client = null;
        isInitting = true;
        online = onlineIn;
        realName = realNameIn;
        initedString = nickIn;
        badwords = ChatUtil.getBadWords();
        badwordsFormat = ChatUtil.getAllowedCharactersRegex();
        IRC_SERVER = ChatUtil.getIRCServerDetails();
        CHANNEL = online ? ChatHandler.IRC_SERVER.channel : "#SuperSpecialPirateClub";
        host = _host;
        tries = 0;
        nick = nickIn;
        host.updateChatChannel();
        Object object = ircLock;
        synchronized (object) {
            messages = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            new Thread(() -> {
                Client.Builder mineTogether = Client.builder().nick(nickIn).realName(realName).user("MineTogether");
                mineTogether.server().host(ChatHandler.IRC_SERVER.address).port(ChatHandler.IRC_SERVER.port).secure(ChatHandler.IRC_SERVER.ssl);
                mineTogether.listeners().exception(e -> {});
                if (client != null) {
                    return;
                }
                client = mineTogether.buildAndConnect();
                ((Client.WithManagement)client).getActorTracker().setQueryChannelInformation(true);
                client.getEventManager().registerEventListener(new Listener());
                client.addChannel(CHANNEL);
                inited = true;
                isInitting = false;
            }).start();
        }
    }

    public static void reInit() {
        if (!isInitting && host != null && initedString != null && realName != null) {
            inited = false;
            ChatHandler.init(initedString, realName, online, host);
        }
    }

    private static void addMessageToChat(String target, String user, String message) {
        LimitedSizeQueue<Message> tempQueue = messages.get(target);
        if (tempQueue == null) {
            tempQueue = new LimitedSizeQueue(150);
            messages.put(target, tempQueue);
        }
        Message messagePair = new Message(System.currentTimeMillis(), user, message);
        tempQueue.add(messagePair);
        host.messageReceived(target, messagePair);
        newMessages.put(target, new Boolean(true));
    }

    public static void addStatusMessage(String message) {
        ChatHandler.addMessageToChat(CHANNEL, "System", message);
    }

    public static String getNameForUser(String nick) {
        return host.getNameForUser(nick);
    }

    private static void updateFriends(List<String> users) {
        List<Friend> friendsCall = host.getFriends();
        HashMap<String, String> oldFriends = friends;
        friends = new HashMap();
        for (Friend friend : friendsCall) {
            if (!friend.isAccepted()) continue;
            String friendCode = "MT" + friend.getCode().substring(0, 15);
            for (String user : users) {
                if (!user.equals(friendCode)) continue;
                friends.put(friendCode, friend.getName());
            }
        }
        for (Map.Entry entry : friends.entrySet()) {
            if (oldFriends.containsKey(entry.getKey())) continue;
            host.friendEvent((String)entry.getKey(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void sendMessage(String currentTarget, String text) {
        String nick;
        block9: {
            block10: {
                if (!ChatHandler.isOnline()) break block10;
                nick = client.getNick();
                if (currentTarget.equals(CHANNEL)) {
                    client.getChannel(CHANNEL).get().sendMessage(text);
                    break block9;
                } else if (privateChatList != null && currentTarget.equals(ChatHandler.privateChatList.channelname)) {
                    try {
                        client.addChannel(privateChatList.getChannelname());
                        client.getChannel(privateChatList.getChannelname()).get().sendMessage(text);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block9;
                } else {
                    if (!client.getChannel(CHANNEL).get().getUser(currentTarget).isPresent()) {
                        ChatHandler.updateFriends(client.getChannel(CHANNEL).get().getNicknames());
                        return;
                    }
                    client.getChannel(CHANNEL).get().getUser(currentTarget).get().sendMessage(text);
                }
                break block9;
            }
            text = "Message not sent as not connected.";
            nick = "System";
        }
        Object object = ircLock;
        synchronized (object) {
            ChatHandler.addMessageToChat(currentTarget, nick, text);
            return;
        }
    }

    public static void sendFriendRequest(String target, String desiredName) {
        Optional<User> userOpt = client.getChannel(CHANNEL).get().getUser(target);
        if (userOpt.isPresent()) {
            User user = userOpt.get();
            user.sendCtcpMessage("FRIENDREQ " + host.getFriendCode() + " " + desiredName);
        } else {
            ChatHandler.addMessageToChat(CHANNEL, "System", "User is not online.");
        }
    }

    public static void sendChannelInvite(String target, String owner) {
        Optional<User> userOpt = client.getChannel(CHANNEL).get().getUser(target);
        String channelName = "#" + owner;
        if (!userOpt.isPresent()) {
            userOpt = client.getChannel(CHANNEL).get().getUser(target + "`");
        }
        if (userOpt.isPresent()) {
            if (privateChatList != null && !privateChatList.getChannelname().equals(channelName)) {
                ChatHandler.closePrivateChat();
            }
            User user = userOpt.get();
            client.addChannel(channelName);
            Optional<Channel> channel = client.getChannel(channelName);
            channel.ifPresent(channel1 -> channel1.commands().mode().add(ModeStatus.Action.ADD, client.getServerInfo().getChannelMode('i').get()).execute());
            hasGroup = true;
            currentGroup = channelName;
            privateChatList = new PrivateChat(channelName, owner);
            String inviteStr = "INVITE " + user.getNick() + " " + channelName;
            client.sendRawLine(inviteStr);
        } else {
            ChatHandler.addMessageToChat(CHANNEL, "System", "User is not online.");
        }
    }

    public static boolean isOnline() {
        return connectionStatus == ConnectionStatus.CONNECTED && client.getChannel(CHANNEL).isPresent();
    }

    public static boolean hasNewMessages(String target) {
        return newMessages.get(target) != null && newMessages.get(target) != false;
    }

    public static void setMessagesRead(String target) {
        newMessages.put(target, false);
    }

    public static void acceptFriendRequest(String chatInternalName, String desiredName) {
        Optional<Channel> channelOpt = client.getChannel(CHANNEL);
        if (!channelOpt.isPresent()) {
            return;
        }
        Channel channel = channelOpt.get();
        Optional<User> userOpt = channel.getUser(chatInternalName);
        if (!userOpt.isPresent()) {
            return;
        }
        User user = userOpt.get();
        user.sendCtcpMessage("FRIENDACC " + host.getFriendCode() + " " + desiredName);
        ChatHandler.addMessageToChat(CHANNEL, "System", "Friend request accepted.");
    }

    public static void acceptPrivateChatInvite(PrivateChat invite) {
        if (hasGroup) {
            ChatHandler.closePrivateChat();
        }
        privateChatList = invite;
        client.addChannel(invite.getChannelname());
        currentGroup = invite.getChannelname();
        hasGroup = true;
        privateChatInvite = null;
    }

    public static void closePrivateChat() {
        String channelName = privateChatList.getChannelname();
        Optional<Channel> channel = client.getChannel(channelName);
        channel.ifPresent(channel1 -> channel1.part("My buddy left :("));
        privateChatList = null;
        hasGroup = false;
    }

    public static List<String> getOnlineUsers() {
        return client.getChannel(CHANNEL).map(channel1 -> channel1.getUsers().stream().map(User::getNick).collect(Collectors.toList())).orElse(new ArrayList());
    }

    public static void createChannel(String name) {
        client.addChannel(name);
    }

    static {
        CHANNEL = "#MineTogether";
        connectionStatus = ConnectionStatus.DISCONNECTED;
        curseSync = new HashMap();
        messages = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        client = null;
        online = false;
        isInitting = false;
        tries = 0;
        inited = false;
        currentGroup = "";
        initedString = null;
        privateChatList = null;
        privateChatInvite = null;
        hasGroup = false;
        friends = new HashMap();
        anonUsers = new HashMap();
        anonUsersReverse = new HashMap();
        autocompleteNames = new ArrayList();
        random = new Random();
    }

    public static enum ConnectionStatus {
        CONNECTED("Connected", "GREEN"),
        CONNECTING("Connecting", "GOLD"),
        DISCONNECTED("Disconnected", "RED"),
        NOT_IN_CHANNEL("Not in channel", "RED");

        public final String display;
        public final String colour;

        private ConnectionStatus(String display, String colour) {
            this.display = display;
            this.colour = colour;
        }
    }

    public static class Listener {
        private WhoisCommand whoisCommand = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Handler
        public void onChannnelLeave(ChannelKickEvent event) {
            if (!event.getTarget().getNick().equals(client.getNick())) {
                return;
            }
            String reason = "Kicked - " + event.getMessage();
            event.getChannel().join();
            Object object = ircLock;
            synchronized (object) {
                if (tries >= 4) {
                    client.shutdown();
                    ChatHandler.addMessageToChat(event.getChannel().getName(), "System", "Unable to rejoin chat. Disconnected from server");
                }
                ChatHandler.addMessageToChat(event.getChannel().getName(), "System", Format.stripAll("Removed from chat (Reason: " + reason + "). Rejoining"));
                connectionStatus = ConnectionStatus.NOT_IN_CHANNEL;
            }
        }

        @Handler
        public void onConnected(ClientNegotiationCompleteEvent event) {
            tries = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Handler
        public void onQuit(ClientConnectionEndedEvent event) {
            String cause = "Unknown";
            if (event.getCause().isPresent()) {
                cause = event.getCause().get().getMessage();
            } else if (event instanceof ClientConnectionClosedEvent && ((ClientConnectionClosedEvent)event).getLastMessage().isPresent()) {
                cause = ((ClientConnectionClosedEvent)event).getLastMessage().get();
            }
            ++tries;
            Object object = ircLock;
            synchronized (object) {
                connectionStatus = ConnectionStatus.DISCONNECTED;
                if (tries >= 5) {
                    event.setAttemptReconnect(false);
                    ChatHandler.addMessageToChat(CHANNEL, "System", Format.stripAll("Disconnected (Reason: " + cause + "). Too many tries, not reconnecting"));
                    return;
                }
                ChatHandler.addMessageToChat(CHANNEL, "System", Format.stripAll("Disconnected (Reason: " + cause + "). Reconnecting"));
                event.setReconnectionDelay(10000);
                event.setAttemptReconnect(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Handler
        public void onChannelJoin(ChannelJoinEvent event) {
            if (client.isUser(event.getUser())) {
                Object object = ircLock;
                synchronized (object) {
                    connectionStatus = ConnectionStatus.CONNECTED;
                    Channel channel = event.getAffectedChannel().get();
                    if (channel.getName().toUpperCase().equals("#" + client.getNick().toUpperCase())) {
                        channel.commands().mode().add(ModeStatus.Action.ADD, client.getServerInfo().getChannelMode('i').get()).execute();
                    }
                }
            }
            ChatHandler.updateFriends(event.getChannel().getNicknames());
        }

        @Handler
        public void onChannelLeave(ChannelPartEvent event) {
            try {
                String channelName = event.getAffectedChannel().get().getName();
                if (channelName.equals(CHANNEL)) {
                    String friendNick = event.getUser().getNick();
                    friends.remove(friendNick);
                } else if (privateChatList != null && channelName.equals(ChatHandler.privateChatList.channelname) && ChatHandler.privateChatList.owner.equals(event.getUser().getNick())) {
                    host.closeGroupChat();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Handler
        public void onUserQuit(UserQuitEvent event) {
            String friendNick = event.getUser().getNick();
            friends.remove(friendNick);
            if (privateChatList != null && ChatHandler.privateChatList.owner.equals(friendNick)) {
                host.closeGroupChat();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Handler
        public void onChannelMessage(ChannelMessageEvent event) {
            User user = (User)event.getActor();
            String message = event.getMessage();
            try {
                if (!curseSync.containsKey(user.getNick())) {
                    if (user.getRealName().isPresent()) {
                        curseSync.put(user.getNick(), user.getRealName().get());
                    } else {
                        this.doWhois(user);
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            Object object = ircLock;
            synchronized (object) {
                ChatHandler.addMessageToChat(event.getChannel().getName(), user.getNick(), Format.stripAll(message));
            }
            ChatHandler.updateFriends(client.getChannel(CHANNEL).get().getNicknames());
        }

        private void doWhois(User user) {
            if (this.whoisCommand == null || this.whoisCommand.getClient() != client) {
                this.whoisCommand = new WhoisCommand(client);
            }
            this.whoisCommand.target(user.getNick()).execute();
        }

        @Handler
        public void onWhoisReturn(WhoisEvent event) {
            WhoisData whoisData = event.getWhoisData();
            if (whoisData.getRealName().isPresent()) {
                curseSync.put(whoisData.getNick(), whoisData.getRealName().get());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Handler
        public void onChannelNotice(ChannelNoticeEvent event) {
            Optional<SortedSet<ChannelUserMode>> userModes = event.getChannel().getUserModes((User)event.getActor());
            if (userModes.isPresent()) {
                SortedSet<ChannelUserMode> channelUserModes = userModes.get();
                boolean valid = false;
                for (ChannelUserMode mode : channelUserModes) {
                    switch (mode.getNickPrefix()) {
                        case '@': 
                        case '~': {
                            valid = true;
                        }
                    }
                }
                if (valid) {
                    Object object = ircLock;
                    synchronized (object) {
                        ChatHandler.addMessageToChat(CHANNEL, "System", event.getMessage());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Handler
        public void onNotice(PrivateNoticeEvent event) {
            Channel channel;
            Optional<SortedSet<ChannelUserMode>> userModesOpt;
            User user = (User)event.getActor();
            Optional<Channel> optchannel = client.getChannel(CHANNEL);
            if (optchannel.isPresent() && (userModesOpt = (channel = optchannel.get()).getUserModes(user)).isPresent()) {
                SortedSet<ChannelUserMode> channelUserModes = userModesOpt.get();
                boolean valid = false;
                for (ChannelUserMode mode : channelUserModes) {
                    switch (mode.getNickPrefix()) {
                        case '@': 
                        case '~': {
                            valid = true;
                        }
                    }
                }
                if (valid) {
                    Object object = ircLock;
                    synchronized (object) {
                        ChatHandler.addMessageToChat(CHANNEL, "System", event.getMessage());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Handler
        public void onPrivateMessage(PrivateMessageEvent event) {
            String message = Format.stripAll(event.getMessage());
            String user = ((User)event.getActor()).getNick();
            if (friends.containsKey(user)) {
                Object object = ircLock;
                synchronized (object) {
                    LimitedSizeQueue<Message> messageQueue = messages.get(user);
                    if (messageQueue == null) {
                        messages.put(user, new LimitedSizeQueue(150));
                    }
                    ChatHandler.addMessageToChat(user, user, message);
                    host.friendEvent(user, true);
                }
            }
        }

        @Handler
        public void onCTCP(PrivateCtcpQueryEvent event) {
            if (event.isToClient()) {
                String message = event.getMessage();
                String[] split = message.split(" ");
                if (split.length < 3) {
                    return;
                }
                if (split[0].equals("FRIENDREQ")) {
                    StringBuilder builder = new StringBuilder();
                    for (int i = 1; i < split.length; ++i) {
                        builder.append(split[i]).append(" ");
                    }
                    String chatMessage = builder.toString().trim();
                    ChatHandler.addMessageToChat(CHANNEL, "FR:" + ((User)event.getActor()).getNick(), chatMessage);
                } else if (split[0].equals("FRIENDACC")) {
                    StringBuilder builder = new StringBuilder();
                    for (int i = 2; i < split.length; ++i) {
                        builder.append(split[i]).append(" ");
                    }
                    host.acceptFriend(split[1], builder.toString().trim());
                    ChatHandler.addMessageToChat(CHANNEL, "FA:" + ((User)event.getActor()).getNick(), builder.toString().trim());
                }
            }
        }

        @Handler
        public void onInviteReceived(ChannelInviteEvent event) {
            String actorName = event.getActor().getName();
            actorName = actorName.substring(0, actorName.indexOf("!"));
            privateChatInvite = new PrivateChat(event.getChannel().getName(), actorName);
        }

        @Handler
        public void onNickRejected(NickRejectedEvent event) {
            String attemptedNick = event.getAttemptedNick();
            if (attemptedNick.contains("`")) {
                event.setNewNick(nick);
            } else {
                event.setNewNick(nick + "`");
            }
        }

        @Handler
        public void onUserBanned(ChannelModeEvent event) {
            List<ModeStatus<ChannelMode>> b = event.getStatusList().getByMode('b');
            b.stream().forEach(mode -> mode.getParameter().ifPresent(param -> host.userBanned(param.split("!")[0])));
        }
    }
}

