/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.gui.chat;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.creeperhost.minetogether.chat.ChatHandler;
import net.creeperhost.minetogether.gui.element.DropdownButton;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class Target
implements DropdownButton.IDropdownOption {
    private final String targetName;
    private static ArrayList<Target> possibleValsCache = new ArrayList();
    private static boolean updating = false;
    private final String internalTarget;
    private static Map<String, String> oldFriends;
    private static int oldMessagesSize;
    private final boolean isChannel;
    public static Target privateChannel;

    private Target(String targetName, String internalTarget, boolean isChannel) {
        this.internalTarget = internalTarget;
        this.targetName = targetName;
        this.isChannel = isChannel;
    }

    private Target(String targetName, String internalTarget) {
        this(targetName, internalTarget, false);
    }

    @Override
    public String getTranslate(DropdownButton.IDropdownOption currentDO, boolean dropdownOpen) {
        Target current = (Target)currentDO;
        boolean newMessages = false;
        if (current == this) {
            for (DropdownButton.IDropdownOption targetObj : this.getPossibleVals()) {
                Target target = (Target)targetObj;
                if (!ChatHandler.hasNewMessages(target.getInternalTarget()) || dropdownOpen) continue;
                newMessages = true;
                break;
            }
        } else {
            newMessages = ChatHandler.hasNewMessages(this.getInternalTarget());
        }
        if (newMessages) {
            TextComponentString str = new TextComponentString(this.targetName);
            str.func_150257_a(new TextComponentString(" \u2022").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            return str.func_150254_d();
        }
        return this.targetName;
    }

    @Override
    public void updateDynamic() {
        Target.updateCache(this);
    }

    public static void updateCache() {
        Target.updateCache(null);
    }

    public static void updateCache(Target current) {
        if (ChatHandler.messages == null) {
            return;
        }
        int chatSize = ChatHandler.messages.size();
        if (updating || oldFriends == ChatHandler.friends && chatSize == oldMessagesSize) {
            return;
        }
        updating = true;
        ArrayList<Target> oldVals = possibleValsCache;
        LinkedHashSet<Target> tempSet = new LinkedHashSet<Target>();
        if (current != null && current.targetName.equals("Main") && !current.internalTarget.equals(ChatHandler.CHANNEL)) {
            current = new Target("Main", ChatHandler.CHANNEL, true);
        }
        possibleValsCache = new ArrayList();
        tempSet.add(new Target("Main", ChatHandler.CHANNEL, true));
        if (current != null && !tempSet.contains(current)) {
            tempSet.add(current);
        }
        for (Map.Entry<String, String> friend : ChatHandler.friends.entrySet()) {
            Target tempTarget = new Target(friend.getValue(), friend.getKey());
            if (tempSet.contains(tempTarget)) continue;
            if (oldVals.contains(tempTarget)) {
                tempTarget = oldVals.get(oldVals.indexOf(tempTarget));
            }
            tempSet.add(tempTarget);
        }
        block1: for (String chat : ChatHandler.messages.keySet()) {
            if (chat.equals(ChatHandler.CHANNEL)) continue;
            for (Target target : oldVals) {
                if (!target.getInternalTarget().equals(chat) || target.targetName.equals("Group Chat") && (ChatHandler.privateChatList == null || !ChatHandler.privateChatList.getChannelname().equals(target.internalTarget))) continue;
                tempSet.add(target);
                continue block1;
            }
        }
        if (ChatHandler.privateChatList != null) {
            Target p;
            privateChannel = p = new Target("Group Chat", ChatHandler.privateChatList.getChannelname(), true);
            tempSet.add(p);
        }
        possibleValsCache = new ArrayList(tempSet);
        updating = false;
        oldFriends = ChatHandler.friends;
        oldMessagesSize = chatSize;
    }

    public static Target getMainTarget() {
        Target.updateCache();
        for (Target defTar : possibleValsCache) {
            if (!defTar.getInternalTarget().equals(ChatHandler.CHANNEL)) continue;
            return defTar;
        }
        return possibleValsCache.size() > 0 ? possibleValsCache.get(0) : new Target("Main", ChatHandler.CHANNEL, true);
    }

    @Override
    public List<DropdownButton.IDropdownOption> getPossibleVals() {
        return possibleValsCache;
    }

    public String getInternalTarget() {
        return this.internalTarget;
    }

    public boolean equals(Object obj) {
        return obj instanceof Target && ((Target)obj).internalTarget.equals(this.internalTarget) && ((Target)obj).targetName.equals(this.targetName);
    }

    public static Target getPrivateChannel() {
        return privateChannel;
    }

    public int hashCode() {
        return this.internalTarget.hashCode() + this.targetName.hashCode();
    }

    public boolean isChannel() {
        return this.isChannel;
    }
}

