/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.gui.element;

import java.util.ArrayList;
import net.creeperhost.minetogether.gui.element.GuiButtonChat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;

public class GuiButtonPair
extends GuiButton {
    GuiButtonChat button1;
    GuiButtonChat button2;
    ArrayList<GuiButtonChat> buttons = new ArrayList();
    public int activeButton;
    private final boolean stack;
    private final boolean swapOnClick;
    private final boolean vertical;

    public GuiButtonPair(int buttonId, int x, int y, int widthIn, int heightIn, int state, boolean stack, boolean swapOnClick, boolean vertical, String ... buttonTexts) {
        super(buttonId, x, y, widthIn, heightIn, buttonTexts[0]);
        this.activeButton = state;
        this.swapOnClick = swapOnClick;
        this.stack = stack;
        this.vertical = vertical;
        int fakeButtonId = 1;
        for (String button : buttonTexts) {
            this.buttons.add(new GuiButtonChat(fakeButtonId++, 0, 0, 0, heightIn, button));
        }
        this.buttons.get(this.activeButton).setActive(true);
        this.button1 = this.buttons.get(0);
        this.button2 = this.buttons.get(1);
        this.setButtonDetails();
    }

    private void setButtonDetails() {
        int buttWidth = this.field_146120_f / this.buttons.size();
        int baseX = this.field_146128_h;
        int baseY = this.field_146129_i;
        int buttonCount = this.buttons.size();
        for (int buttonNum = 0; buttonNum < buttonCount; ++buttonNum) {
            GuiButtonChat button = this.buttons.get(buttonNum);
            int visibleNum = buttonNum;
            if (this.swapOnClick) {
                visibleNum = (buttonNum + buttonCount - this.activeButton) % buttonCount;
            }
            button.field_146120_f = buttWidth;
            button.field_146121_g = this.field_146121_g;
            if (this.stack) {
                button.field_146128_h = baseX;
                button.field_146129_i = baseY + visibleNum * this.field_146121_g;
                continue;
            }
            button.field_146128_h = baseX + visibleNum * buttWidth;
            button.field_146129_i = baseY;
        }
    }

    public void func_191745_a(Minecraft p_191745_1_, int p_191745_2_, int p_191745_3_, float p_191745_4_) {
        double mouseX = p_191745_2_;
        double mouseY = p_191745_3_;
        float scale = 0.75f;
        float xTranslate = -this.buttons.get((int)0).field_146128_h;
        float yTranslate = -this.buttons.get((int)0).field_146129_i;
        int buttonCount = this.buttons.size();
        int[] cachedX = new int[buttonCount];
        int[] cachedY = new int[buttonCount];
        if (this.vertical) {
            float tempTranslateY;
            float tempTranslateX;
            double xDiff = mouseX - (double)this.button1.field_146128_h;
            double yDiff = mouseY - (double)this.button1.field_146129_i;
            mouseX = yDiff / (double)scale;
            mouseY = xDiff / (double)scale + (double)this.field_146121_g;
            int buttWidth = this.field_146120_f / this.buttons.size();
            for (int buttNum = 0; buttNum < buttonCount; ++buttNum) {
                GuiButtonChat button = this.buttons.get(buttNum);
                int visibleNum = buttNum;
                if (this.swapOnClick) {
                    visibleNum = (buttNum + buttonCount - this.activeButton) % buttonCount;
                }
                cachedX[buttNum] = button.field_146128_h;
                cachedY[buttNum] = button.field_146129_i;
                button.field_146128_h = buttWidth * visibleNum;
                button.field_146129_i = 0;
            }
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            GlStateManager.func_179094_E();
            if (this.stack) {
                tempTranslateX = -xTranslate + (float)(this.field_146121_g * 2);
                tempTranslateY = -yTranslate - (float)this.field_146120_f;
            } else {
                tempTranslateX = -xTranslate * (1.0f / scale);
                tempTranslateY = -yTranslate * (1.0f / scale);
            }
            GlStateManager.func_179109_b((float)tempTranslateX, (float)(tempTranslateY -= scale), (float)0.0f);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        for (GuiButtonChat button : this.buttons) {
            button.func_191745_a(p_191745_1_, (int)mouseX, (int)mouseY, p_191745_4_);
        }
        if (this.vertical) {
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179152_a((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
            for (int buttNum = 0; buttNum < buttonCount; ++buttNum) {
                GuiButtonChat button;
                button = this.buttons.get(buttNum);
                button.field_146128_h = cachedX[buttNum];
                button.field_146129_i = cachedY[buttNum];
            }
        }
    }

    public boolean func_146116_c(Minecraft mc, int mouseXIn, int mouseYIn) {
        double mouseX = mouseXIn;
        double mouseY = mouseYIn;
        if (this.vertical) {
            double xDiff = (mouseX - (double)this.button1.field_146128_h) / 0.75;
            double yDiff = (mouseY - (double)this.button1.field_146129_i) / 0.75;
            mouseX = (double)this.button1.field_146128_h + yDiff;
            mouseY = (double)this.button1.field_146129_i + xDiff + (double)this.field_146121_g;
        }
        boolean pressed = false;
        for (int buttonNum = 0; buttonNum < this.buttons.size(); ++buttonNum) {
            GuiButtonChat button = this.buttons.get(buttonNum);
            if (button.func_146116_c(mc, (int)mouseX, (int)mouseY)) {
                this.activeButton = buttonNum;
                button.setActive(true);
                pressed = true;
                continue;
            }
            button.setActive(false);
        }
        return pressed;
    }
}

