/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.command;

import java.util.ArrayList;
import java.util.List;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.Command;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CapabilityRequestCommand
extends Command<CapabilityRequestCommand> {
    private final List<String> requests = new ArrayList<String>();

    public CapabilityRequestCommand(@NonNull Client client) {
        super(client);
    }

    public synchronized @NonNull CapabilityRequestCommand enable(@NonNull String capability) {
        this.requests.add(Sanity.safeMessageCheck(capability, "Capability"));
        return this;
    }

    public synchronized @NonNull CapabilityRequestCommand disable(@NonNull String capability) {
        this.requests.add('-' + Sanity.safeMessageCheck(capability, "Capability"));
        return this;
    }

    @Override
    public synchronized void execute() {
        StringBuilder builder = new StringBuilder(200);
        for (String request : this.requests) {
            if (builder.length() > 0 && request.length() + builder.length() > 200) {
                this.send(builder.toString());
                builder.setLength(0);
            }
            builder.append(request).append(' ');
        }
        this.send(builder.toString());
    }

    private void send(@NonNull String requests) {
        this.sendCommandLine("CAP REQ :" + requests, true);
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("requests", this.requests);
    }
}

