/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.ChannelCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.mode.DefaultModeStatus;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.mode.DefaultModeStatusList;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ISupportParameter;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.User;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ChannelMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ChannelUserMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ModeStatus;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ChannelModeCommand
extends ChannelCommand<ChannelModeCommand> {
    private static final int PARAMETER_MODES_PER_LINE = 3;
    private final List<ModeStatus<ChannelMode>> changes = new ArrayList<ModeStatus<ChannelMode>>();

    public ChannelModeCommand(@NonNull Client client, @NonNull String channel) {
        super(client, channel);
    }

    public @NonNull ChannelModeCommand add(ModeStatus.Action action, @NonNull ChannelMode mode) {
        return this.addChange(action, mode, null);
    }

    public @NonNull ChannelModeCommand add(ModeStatus.Action action, @NonNull ChannelMode mode, @NonNull String parameter) {
        return this.addChange(action, mode, Sanity.nullCheck(parameter, "Parameter"));
    }

    public @NonNull ChannelModeCommand add(ModeStatus.Action action, @NonNull ChannelUserMode mode, @NonNull User parameter) {
        Sanity.nullCheck(parameter, "User");
        Sanity.truthiness(parameter.getClient() == this.getClient(), "User comes from a different Client");
        return this.addChange(action, mode, parameter.getNick());
    }

    private synchronized @NonNull ChannelModeCommand addChange(ModeStatus.Action action, @NonNull ChannelMode mode, @Nullable String parameter) {
        Sanity.nullCheck(mode, "Mode");
        Sanity.truthiness(mode.getClient() == this.getClient(), "Mode comes from a different Client");
        if (parameter != null) {
            Sanity.safeMessageCheck(parameter, "Parameter");
            this.changes.add(new DefaultModeStatus<ChannelMode>(action, mode, parameter));
        } else {
            this.changes.add(new DefaultModeStatus<ChannelMode>(action, mode));
        }
        return this;
    }

    @Override
    public synchronized void execute() {
        if (this.changes.isEmpty()) {
            this.sendCommandLine("MODE " + this.getChannel());
            return;
        }
        int parameterModesPerLine = -1;
        Optional<ISupportParameter.Modes> modes = this.getClient().getServerInfo().getISupportParameter("MODES", ISupportParameter.Modes.class);
        if (modes.isPresent()) {
            parameterModesPerLine = modes.get().getInteger();
        }
        if (parameterModesPerLine < 1) {
            parameterModesPerLine = 3;
        }
        ArrayList<ModeStatus<ChannelMode>> queue = new ArrayList<ModeStatus<ChannelMode>>();
        int currentParamModes = 0;
        for (ModeStatus<ChannelMode> modeChange : this.changes) {
            if (modeChange.getParameter().isPresent() && ++currentParamModes > parameterModesPerLine) {
                this.send(queue);
                currentParamModes = 0;
            }
            queue.add(modeChange);
        }
        if (!queue.isEmpty()) {
            this.send(queue);
        }
    }

    private void send(@NonNull List<ModeStatus<ChannelMode>> queue) {
        this.sendCommandLine("MODE " + this.getChannel() + ' ' + DefaultModeStatusList.of(new ArrayList(queue)).getAsString());
        queue.clear();
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("changes", this.changes);
    }
}

