/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.command;

import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.ChannelCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.User;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.defaultmessage.DefaultMessageType;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class KickCommand
extends ChannelCommand<KickCommand> {
    private String target;
    private @Nullable String reason = this.getClient().getDefaultMessageMap().getDefault(DefaultMessageType.KICK).orElse(null);

    public KickCommand(@NonNull Client client, @NonNull String channel) {
        super(client, channel);
    }

    public @NonNull KickCommand target(@NonNull String target) {
        this.target = Sanity.safeMessageCheck(target, "Target");
        return this;
    }

    public @NonNull KickCommand target(@NonNull User target) {
        Sanity.nullCheck(target, "Target");
        Sanity.truthiness(target.getClient() == this.getClient(), "User comes from a different client");
        this.target(target.getNick());
        return this;
    }

    public @NonNull KickCommand reason(@Nullable String reason) {
        this.reason = reason == null ? null : Sanity.safeMessageCheck(reason, "Reason");
        return this;
    }

    @Override
    public void execute() {
        if (this.target == null) {
            throw new IllegalStateException("Target not defined");
        }
        this.sendCommandLine("KICK " + this.getChannel() + ' ' + this.target + (this.reason != null ? " :" + this.reason : ""));
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("target", this.target).add("reason", this.reason);
    }
}

