/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.isupport;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportParameterValueRequired;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ISupportParameter;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.exception.KittehServerISupportException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DefaultISupportChanLimit
extends DefaultISupportParameterValueRequired
implements ISupportParameter.ChanLimit {
    private final Map<Character, Integer> limits;

    public DefaultISupportChanLimit(@NonNull Client client, @NonNull String name, @Nullable String value) {
        super(client, name, value);
        String[] pairs = value.split(",");
        HashMap<Character, Integer> limits = new HashMap<Character, Integer>();
        for (String p : pairs) {
            int limit;
            String[] pair = p.split(":");
            if (pair.length != 2) {
                throw new KittehServerISupportException(name, "Invalid format");
            }
            try {
                limit = Integer.parseInt(pair[1]);
            }
            catch (Exception e) {
                throw new KittehServerISupportException(name, "Non-integer limit", e);
            }
            for (char prefix : pair[0].toCharArray()) {
                limits.put(Character.valueOf(prefix), limit);
            }
        }
        this.limits = Collections.unmodifiableMap(limits);
    }

    @Override
    public @NonNull Map<Character, Integer> getLimits() {
        return this.limits;
    }
}

