/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.mode;

import java.util.Optional;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.Mode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ModeStatus;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DefaultModeStatus<ModeType extends Mode>
implements ModeStatus<ModeType> {
    private final ModeType mode;
    private final @Nullable String parameter;
    private final ModeStatus.Action action;

    public DefaultModeStatus(ModeStatus.Action action, @NonNull ModeType mode) {
        this.mode = (Mode)Sanity.nullCheck(mode, "Mode");
        this.parameter = null;
        this.action = action;
    }

    public DefaultModeStatus(ModeStatus.Action action, @NonNull ModeType mode, @NonNull String parameter) {
        this.mode = (Mode)Sanity.nullCheck(mode, "Mode");
        this.parameter = Sanity.safeMessageCheck(parameter, "Parameter");
        this.action = action;
    }

    @Override
    public @NonNull ModeStatus.Action getAction() {
        return this.action;
    }

    @Override
    public @NonNull Client getClient() {
        return this.getMode().getClient();
    }

    @Override
    public @NonNull ModeType getMode() {
        return this.mode;
    }

    @Override
    public @NonNull Optional<String> getParameter() {
        return Optional.ofNullable(this.parameter);
    }

    public @NonNull String toString() {
        return new ToStringer(this).add("client", this.getClient()).add("mode", this.mode).add("action", (Object)this.action).add("parameter", this.parameter).toString();
    }
}

