/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.feature;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.creeperhost.minetogether.net.engio.mbassy.bus.MBassador;
import net.creeperhost.minetogether.net.engio.mbassy.bus.config.BusConfiguration;
import net.creeperhost.minetogether.net.engio.mbassy.bus.config.Feature;
import net.creeperhost.minetogether.net.engio.mbassy.bus.error.IPublicationErrorHandler;
import net.creeperhost.minetogether.net.engio.mbassy.bus.error.PublicationError;
import net.creeperhost.minetogether.net.engio.mbassy.listener.Handler;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.feature.FilteringSubscriptionFactory;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.connection.ClientConnectionEndedEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.helper.ClientEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.exception.KittehEventException;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.exception.KittehNagException;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.exception.KittehServerMessageException;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.EventManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.CommandFilter;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.EchoMessage;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.FilterProcessor;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.NumericFilter;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.ToSelfOnly;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DefaultEventManager
implements EventManager {
    private final MBassador<Object> bus;
    private final Client client;
    private final Map<Class<? extends Annotation>, FilterProcessor<?, ? extends Annotation>> filters = new ConcurrentHashMap();
    private final Set<Object> listeners = new HashSet<Object>();

    public DefaultEventManager(@NonNull Client client) {
        BusConfiguration configuration = new BusConfiguration().addFeature(Feature.SyncPubSub.Default().setSubscriptionFactory(new FilteringSubscriptionFactory(this.filters))).addFeature(Feature.AsynchronousHandlerInvocation.Default()).addFeature(Feature.AsynchronousMessageDispatch.Default()).addPublicationErrorHandler(new Exceptional(client));
        this.bus = new MBassador(configuration);
        this.client = client;
        this.registerAnnotationFilter(CommandFilter.class, new CommandFilter.Processor());
        this.registerAnnotationFilter(EchoMessage.class, new EchoMessage.Processor());
        this.registerAnnotationFilter(NumericFilter.class, new NumericFilter.Processor());
        this.registerAnnotationFilter(ToSelfOnly.class, new ToSelfOnly.Processor());
        this.registerEventListener(this);
    }

    @Override
    public void callEvent(@NonNull Object event) {
        Sanity.nullCheck(event, "Event");
        if (event instanceof ClientEvent) {
            Sanity.truthiness(((ClientEvent)event).getClient() == this.client, "Event cannot be from another client!");
        }
        this.bus.publish(event);
    }

    @Override
    public synchronized @NonNull Set<Object> getRegisteredEventListeners() {
        return new HashSet<Object>(this.listeners);
    }

    @Override
    public @NonNull Map<Class<? extends Annotation>, FilterProcessor<?, ? extends Annotation>> getAnnotationFilters() {
        return Collections.unmodifiableMap(new HashMap(this.filters));
    }

    @Override
    public <A extends Annotation> void registerAnnotationFilter(Class<A> annotationClass, FilterProcessor<?, A> filterProcessor) {
        this.filters.put(annotationClass, filterProcessor);
    }

    @Override
    public synchronized void registerEventListener(@NonNull Object listener) {
        Sanity.nullCheck(listener, "Listener");
        this.listeners.add(listener);
        this.bus.subscribe(listener);
    }

    @Override
    public synchronized void unregisterEventListener(@NonNull Object listener) {
        Sanity.nullCheck(listener, "Listener");
        this.listeners.remove(listener);
        this.bus.unsubscribe(listener);
    }

    @Handler(priority=-2147483648)
    public void onShutdown(ClientConnectionEndedEvent event) {
        if (!event.canAttemptReconnect()) {
            this.bus.shutdown();
        }
    }

    public @NonNull String toString() {
        return new ToStringer(this).add("client", this.client).toString();
    }

    public static class Exceptional
    implements IPublicationErrorHandler {
        private final Client client;

        public Exceptional(@NonNull Client client) {
            this.client = client;
        }

        @Override
        public void handleError(@NonNull PublicationError publicationError) {
            Throwable thrown = publicationError.getCause();
            Exception exceptional = thrown instanceof InvocationTargetException && thrown.getCause() instanceof KittehServerMessageException ? (KittehServerMessageException)thrown.getCause() : (thrown instanceof InvocationTargetException && thrown.getCause() instanceof KittehNagException ? (KittehNagException)thrown.getCause() : new KittehEventException(thrown));
            this.client.getExceptionListener().queue(exceptional);
        }

        public @NonNull String toString() {
            return new ToStringer(this).toString();
        }
    }
}

