/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.feature.network;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.proxy.Socks4ProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.feature.network.JavaResolver;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.feature.network.NettyConnection;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.network.NetworkHandler;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.network.Resolver;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsClientState;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsMachine;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsPolicy;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.HostWithPort;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class NettyNetworkHandler
implements NetworkHandler {
    private static final NettyNetworkHandler instance = new NettyNetworkHandler();
    private @Nullable EventLoopGroup eventLoopGroup;
    private final Set<Client.WithManagement> clients = new HashSet<Client.WithManagement>();
    private Resolver resolver = new JavaResolver();

    public static @NonNull NettyNetworkHandler getInstance() {
        return instance;
    }

    private NettyNetworkHandler() {
    }

    private synchronized void removeClientConnection(@NonNull Client.WithManagement client) {
        this.clients.remove(client);
        if (this.clients.isEmpty()) {
            if (this.eventLoopGroup != null) {
                this.eventLoopGroup.shutdownGracefully();
            }
            this.eventLoopGroup = null;
        }
    }

    @Override
    public synchronized @NonNull NettyConnection connect(final @NonNull Client.WithManagement client) {
        InetSocketAddress server;
        if (client.getStsMachine().isPresent() && !client.isSecureConnection()) {
            String hostname = client.getServerAddress().getHost();
            StsMachine machine = client.getStsMachine().get();
            Optional<StsPolicy> policy = machine.getStorageManager().getEntry(hostname);
            if (policy.isPresent()) {
                machine.setStsPolicy(policy.get());
                machine.setCurrentState(StsClientState.STS_POLICY_CACHED);
            }
        }
        if (this.eventLoopGroup == null) {
            this.eventLoopGroup = new NioEventLoopGroup();
        }
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(NioSocketChannel.class)).group(this.eventLoopGroup)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel channel) {
                if (client.getProxyType().isPresent() && client.getProxyAddress().isPresent()) {
                    ChannelPipeline pipe = channel.pipeline();
                    HostWithPort proxyHostWithPort = client.getProxyAddress().get();
                    switch (client.getProxyType().get()) {
                        case SOCKS_5: {
                            pipe.addLast(new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)new InetSocketAddress(proxyHostWithPort.getHost(), proxyHostWithPort.getPort()))});
                            break;
                        }
                        case SOCKS_4: {
                            pipe.addLast(new ChannelHandler[]{new Socks4ProxyHandler((SocketAddress)new InetSocketAddress(proxyHostWithPort.getHost(), proxyHostWithPort.getPort()))});
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported proxy type: " + client.getProxyType());
                        }
                    }
                }
            }
        })).option(ChannelOption.TCP_NODELAY, (Object)true);
        InetSocketAddress bind = client.getBindAddress();
        String host = client.getServerAddress().getHost();
        try {
            InetAddress address = this.resolver.getAddress(host);
            server = new InetSocketAddress(address, client.getServerAddress().getPort());
        }
        catch (UnknownHostException e) {
            server = InetSocketAddress.createUnresolved(host, client.getServerAddress().getPort());
        }
        NettyConnection clientConnection = new NettyConnection(client, bootstrap.connect((SocketAddress)server, (SocketAddress)bind), this::removeClientConnection);
        this.clients.add(client);
        return clientConnection;
    }

    @Override
    public @NonNull Resolver getResolver() {
        return this.resolver;
    }

    @Override
    public void setResolver(@NonNull Resolver resolver) {
        this.resolver = Sanity.nullCheck(resolver, "Resolver");
    }

    public @NonNull String toString() {
        return new ToStringer(this).toString();
    }
}

