/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.listener;

import net.creeperhost.minetogether.net.engio.mbassy.listener.Handler;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.listener.AbstractDefaultListenerBase;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.Actor;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.Channel;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelInviteEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientReceiveCommandEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.CommandFilter;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DefaultInviteListener
extends AbstractDefaultListenerBase {
    public DefaultInviteListener(@NonNull Client.WithManagement client) {
        super(client);
    }

    @CommandFilter(value="INVITE")
    @Handler(priority=0x7FFFFFFE)
    public void invite(ClientReceiveCommandEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "INVITE message too short");
            return;
        }
        Channel channel = this.getTracker().getChannel(event.getParameters().get(1)).orElse(null);
        if (channel == null) {
            this.trackException(event, "INVITE message sent for invalid channel name");
            return;
        }
        if (this.getClient().getNick().equalsIgnoreCase(event.getParameters().get(0)) && this.getClient().getIntendedChannels().contains(channel.getName())) {
            this.getClient().sendRawLine("JOIN " + channel.getName());
        }
        this.fire(new ChannelInviteEvent(this.getClient(), event.getSource(), channel, (Actor)event.getActor(), event.getParameters().get(0)));
    }
}

