/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.listener;

import net.creeperhost.minetogether.net.engio.mbassy.listener.Handler;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.listener.AbstractDefaultListenerBase;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.Channel;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.User;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelPartEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.UnexpectedChannelLeaveViaPartEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientReceiveCommandEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.CommandFilter;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DefaultPartListener
extends AbstractDefaultListenerBase {
    public DefaultPartListener(@NonNull Client.WithManagement client) {
        super(client);
    }

    @CommandFilter(value="PART")
    @Handler(priority=0x7FFFFFFE)
    public void part(ClientReceiveCommandEvent event) {
        if (event.getParameters().size() < 1) {
            this.trackException(event, "PART message too short");
            return;
        }
        Channel channel = this.getTracker().getChannel(event.getParameters().get(0)).orElse(null);
        if (channel == null) {
            this.trackException(event, "PART message sent for invalid channel name");
            return;
        }
        if (!(event.getActor() instanceof User)) {
            this.trackException(event, "PART message sent for non-user");
            return;
        }
        User user = (User)event.getActor();
        boolean isSelf = user.getNick().equals(this.getClient().getNick());
        String partReason = event.getParameters().size() > 1 ? event.getParameters().get(1) : "";
        ChannelPartEvent partEvent = isSelf && this.getClient().getIntendedChannels().contains(channel.getName()) ? new UnexpectedChannelLeaveViaPartEvent((Client)this.getClient(), event.getSource(), channel, user, partReason) : new ChannelPartEvent((Client)this.getClient(), event.getSource(), channel, user, partReason);
        this.fire(partEvent);
        this.getTracker().trackUserPart(channel.getName(), user.getNick());
        if (isSelf) {
            this.getTracker().unTrackChannel(channel.getName());
        }
    }
}

