/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.event.abstractbase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.Actor;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.MessageTag;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ServerMessage;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.abstractbase.ActorEventBase;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.helper.ClientReceiveServerMessageEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ClientReceiveServerMessageEventBase
extends ActorEventBase<Actor>
implements ClientReceiveServerMessageEvent {
    private final List<String> parameters;
    private final String command;
    private final ServerMessage message;

    public ClientReceiveServerMessageEventBase(@NonNull Client client, @NonNull ServerMessage serverMessage, @NonNull Actor server, @NonNull String command, @NonNull List<String> parameters) {
        super(client, Sanity.nullCheck(serverMessage, "Server message cannot be null"), server);
        this.parameters = Collections.unmodifiableList(new ArrayList(Sanity.nullCheck(parameters, "Parameters")));
        this.message = serverMessage;
        this.command = Sanity.nullCheck(command, "Command");
    }

    @Override
    public @NonNull List<String> getParameters() {
        return this.parameters;
    }

    @Override
    public @NonNull String getCommand() {
        return this.command;
    }

    @Override
    public @NonNull List<MessageTag> getMessageTags() {
        return this.message.getTags();
    }

    @Override
    public @NonNull String getRawMessage() {
        return this.message.getMessage();
    }

    @Override
    public @NonNull ServerMessage getServerMessage() {
        return this.message;
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("message", this.message);
    }
}

