/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.auth;

import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import net.creeperhost.minetogether.net.engio.mbassy.listener.Handler;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientReceiveCommandEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.auth.AbstractAccountSaslProtocol;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.auth.AbstractSaslProtocol;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.CommandFilter;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SaslEcdsaNist256PChallenge
extends AbstractAccountSaslProtocol {
    private final ECPrivateKey privateKey;
    private @MonotonicNonNull Listener listener;

    public SaslEcdsaNist256PChallenge(@NonNull Client client, @NonNull String accountName, @NonNull ECPrivateKey privateKey) {
        super(client, "ECDSA-NIST256P-CHALLENGE", accountName);
        this.privateKey = Sanity.nullCheck(privateKey, "Private key cannot be null");
    }

    @Override
    protected @NonNull String getAuthLine() {
        return this.getAccountName() + '\u0000' + this.getAccountName() + '\u0000';
    }

    @Override
    public @NonNull Object getEventListener() {
        return this.listener == null ? (this.listener = new Listener()) : this.listener;
    }

    @Override
    protected void toString(ToStringer stringer) {
        super.toString(stringer);
        stringer.add("privateKey", this.privateKey);
    }

    public static @NonNull String base64Encode(@NonNull ECPrivateKey privateKey) {
        Sanity.nullCheck(privateKey, "Private key cannot be null");
        return Base64.getEncoder().encodeToString(privateKey.getEncoded());
    }

    public static @NonNull String base64Encode(@NonNull ECPublicKey publicKey) {
        Sanity.nullCheck(publicKey, "Public key cannot be null");
        return Base64.getEncoder().encodeToString(publicKey.getEncoded());
    }

    public static @NonNull ECPrivateKey getPrivateKey(@NonNull String base64Encoded) throws NoSuchAlgorithmException, InvalidKeySpecException {
        Sanity.nullCheck(base64Encoded, "Base64 encoded string cannot be null");
        KeyFactory keyFactory = KeyFactory.getInstance("EC");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(base64Encoded));
        return (ECPrivateKey)keyFactory.generatePrivate(keySpec);
    }

    public static @NonNull ECPublicKey getPublicKey(@NonNull String base64Encoded) throws NoSuchAlgorithmException, InvalidKeySpecException {
        Sanity.nullCheck(base64Encoded, "Base64 encoded string cannot be null");
        KeyFactory keyFactory = KeyFactory.getInstance("EC");
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(base64Encoded));
        return (ECPublicKey)keyFactory.generatePublic(keySpec);
    }

    public static @NonNull String getCompressedBase64PublicKey(@NonNull ECPublicKey publicKey) {
        Sanity.nullCheck(publicKey, "Public key cannot be null");
        ECPoint ecPoint = publicKey.getW();
        byte[] xBytes = ecPoint.getAffineX().toByteArray();
        int overflow = xBytes.length - 32;
        byte[] yBytes = ecPoint.getAffineY().toByteArray();
        byte finalYByte = yBytes[yBytes.length - 1];
        byte header = (byte)(finalYByte & 1 | 2);
        byte[] result = new byte[xBytes.length + 1 - overflow];
        System.arraycopy(xBytes, overflow, result, 1, 32);
        result[0] = header;
        return Base64.getEncoder().encodeToString(result);
    }

    public static @NonNull String sign(@NonNull ECPrivateKey privateKey, @NonNull String base64Challenge) throws SignatureException, NoSuchAlgorithmException, InvalidKeyException {
        Sanity.nullCheck(privateKey, "Private key cannot be null");
        Sanity.nullCheck(base64Challenge, "Base64 encoded challenge cannot be null");
        Signature signature = Signature.getInstance("NONEwithECDSA");
        signature.initSign(privateKey);
        signature.update(Base64.getDecoder().decode(base64Challenge));
        return Base64.getEncoder().encodeToString(signature.sign());
    }

    public static @NonNull ECKeyPair getNewKey() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        keyPairGenerator.initialize(256, secureRandom);
        KeyPair pair = keyPairGenerator.generateKeyPair();
        return new ECKeyPair((ECPrivateKey)pair.getPrivate(), (ECPublicKey)pair.getPublic());
    }

    public static boolean verify(@NonNull ECPublicKey publicKey, @NonNull String base64Challenge, @NonNull String signature) throws SignatureException, NoSuchAlgorithmException, InvalidKeyException {
        Sanity.nullCheck(publicKey, "Public key cannot be null");
        Sanity.nullCheck(base64Challenge, "Base64 encoded challenge cannot be null");
        Sanity.nullCheck(signature, "Signature");
        Signature ver = Signature.getInstance("NONEwithECDSA");
        ver.initVerify(publicKey);
        Base64.Decoder decoder = Base64.getDecoder();
        ver.update(decoder.decode(base64Challenge));
        return ver.verify(decoder.decode(signature));
    }

    private class Listener
    extends AbstractSaslProtocol.Listener {
        private Listener() {
        }

        @Override
        @CommandFilter(value="AUTHENTICATE")
        @Handler
        public void authenticate(ClientReceiveCommandEvent event) {
            if (!event.getParameters().isEmpty()) {
                String base64;
                if ("+".equals(event.getParameters().get(0))) {
                    base64 = Base64.getEncoder().encodeToString(SaslEcdsaNist256PChallenge.this.getAuthLine().getBytes());
                } else {
                    String challenge = event.getParameters().get(0);
                    try {
                        base64 = SaslEcdsaNist256PChallenge.sign(SaslEcdsaNist256PChallenge.this.privateKey, challenge);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                SaslEcdsaNist256PChallenge.this.getClient().sendRawLineImmediately("AUTHENTICATE " + base64);
            }
        }
    }

    public static final class ECKeyPair {
        private final ECPrivateKey privateKey;
        private final ECPublicKey publicKey;

        private ECKeyPair(@NonNull ECPrivateKey privateKey, @NonNull ECPublicKey publicKey) {
            this.privateKey = privateKey;
            this.publicKey = publicKey;
        }

        public @NonNull ECPrivateKey getPrivate() {
            return this.privateKey;
        }

        public @NonNull ECPublicKey getPublic() {
            return this.publicKey;
        }

        public @NonNull String toString() {
            return new ToStringer(this).add("privateKey", this.privateKey).add("publicKey", this.publicKey).toString();
        }
    }
}

