/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sending;

import java.util.Optional;
import java.util.Queue;
import java.util.function.Consumer;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sending.MessageSendingQueue;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.QueueProcessingThread;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import org.checkerframework.checker.nullness.qual.NonNull;

public class QueueProcessingThreadSender
extends QueueProcessingThread<String>
implements MessageSendingQueue {
    private final Client client;
    private Consumer<String> consumer = string -> {};
    private final Object sendingLock = new Object();
    private volatile boolean waiting = true;

    public QueueProcessingThreadSender(@NonNull Client client, @NonNull String name) {
        super("KICL " + Sanity.nullCheck(name, "Name") + " Sending Queue (" + Sanity.nullCheck(client, "Client").getName() + ')');
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processElement(@NonNull String message) {
        Sanity.nullCheck(message, "Message");
        Object object = this.sendingLock;
        synchronized (object) {
            if (this.waiting) {
                try {
                    this.sendingLock.wait();
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            if (this.checkReady(message)) {
                this.consumer.accept(message);
            }
        }
    }

    protected boolean checkReady(@NonNull String message) {
        return true;
    }

    @Override
    protected final void cleanup(@NonNull Queue<String> remainingQueue) {
    }

    protected @NonNull Client getClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginSending(@NonNull Consumer<String> consumer) {
        Sanity.nullCheck(consumer, "Consumer");
        Object object = this.sendingLock;
        synchronized (object) {
            this.consumer = consumer;
            this.waiting = false;
            this.sendingLock.notify();
        }
    }

    @Override
    public @NonNull Optional<Consumer<String>> getConsumer() {
        return Optional.ofNullable(this.consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.sendingLock;
        synchronized (object) {
            this.waiting = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull Queue<String> shutdown() {
        Object object = this.sendingLock;
        synchronized (object) {
            this.interrupt();
            this.sendingLock.notify();
            return this.getQueue();
        }
    }
}

