/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.CaseMapping;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CISet
implements Set<String> {
    private final Client client;
    private CaseMapping lastCaseMapping;
    private final Map<String, String> map = new ConcurrentHashMap<String, String>();

    public CISet(@NonNull Client client) {
        this.client = Sanity.nullCheck(client, "Client");
    }

    protected final synchronized String toLowerCase(@NonNull String input) {
        CaseMapping caseMapping = this.client.getServerInfo().getCaseMapping();
        if (caseMapping != this.lastCaseMapping) {
            HashSet<String> set = new HashSet<String>(this.map.values());
            this.lastCaseMapping = caseMapping;
            this.map.clear();
            set.forEach(this::add);
        }
        return caseMapping.toLowerCase(input);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return o instanceof String && this.map.containsKey(this.toLowerCase((String)o));
    }

    @Override
    public @NonNull Iterator<String> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public @NonNull Object[] toArray() {
        return this.map.values().toArray();
    }

    @Override
    public <T> @NonNull T[] toArray(@NonNull T[] a) {
        return this.map.values().toArray(a);
    }

    @Override
    public boolean add(@NonNull String s) {
        Sanity.nullCheck(s, "String");
        this.map.put(this.toLowerCase(s), s);
        return true;
    }

    @Override
    public boolean remove(@Nullable Object o) {
        return o instanceof String && this.map.remove(this.toLowerCase((String)o)) != null;
    }

    @Override
    public boolean containsAll(@NonNull Collection<?> c) {
        Sanity.nullCheck(c, "Collection");
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@NonNull Collection<? extends String> c) {
        Sanity.nullCheck(c, "Collection");
        c.forEach(this::add);
        return true;
    }

    @Override
    public boolean retainAll(@NonNull Collection<?> c) {
        Sanity.nullCheck(c, "Collection");
        return this.map.keySet().retainAll(c.stream().filter(i -> i instanceof String).map(i -> (String)i).map(this::toLowerCase).collect(Collectors.toSet()));
    }

    @Override
    public boolean removeAll(@NonNull Collection<?> c) {
        Sanity.nullCheck(c, "Collection");
        return this.map.keySet().removeAll(c.stream().filter(i -> i instanceof String).map(i -> (String)i).map(this::toLowerCase).collect(Collectors.toSet()));
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public @NonNull String toString() {
        return new ToStringer(this).add("client", this.client).add("set", this.map.values()).toString();
    }
}

