/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.util;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Sanity {
    private Sanity() {
    }

    public static <Type> @NonNull Type nullCheck(@Nullable Type object, @NonNull String name) {
        if (object == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
        return object;
    }

    public static <Type> @NonNull Type[] nullCheck(@Nullable Type[] array, @NonNull String name) {
        Sanity.nullCheck(array, name);
        for (Type element : array) {
            Sanity.nullCheck(element, name);
        }
        return array;
    }

    public static void truthiness(boolean bool, @NonNull String failMessage) {
        if (!bool) {
            throw new IllegalArgumentException(failMessage);
        }
    }

    public static @NonNull String safeMessageCheck(@NonNull String message) {
        return Sanity.safeMessageCheck(message, "message");
    }

    public static @NonNull String safeMessageCheck(@Nullable String message, @NonNull String name) {
        Sanity.nullCheck(message, name + " cannot be null");
        for (char ch : message.toCharArray()) {
            if (ch != '\n' && ch != '\r' && ch != '\u0000') continue;
            throw new IllegalArgumentException(name + " cannot contain CR, LF, or NUL");
        }
        return message;
    }

    public static @NonNull String noSpaces(@NonNull String string, @NonNull String name) {
        Sanity.truthiness(!string.contains(" "), name + " cannot contain spaces");
        return string;
    }
}

