/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.containerBuilder.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import reborncore.client.containerBuilder.IRightClickHandler;
import reborncore.client.containerBuilder.builder.IExtendedContainerListener;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.ItemUtils;

public class BuiltContainer
extends Container
implements IExtendedContainerListener {
    private final String name;
    private final Predicate<EntityPlayer> canInteract;
    private final List<Range<Integer>> playerSlotRanges;
    private final List<Range<Integer>> tileSlotRanges;
    private final ArrayList<MutableTriple<IntSupplier, IntConsumer, Short>> shortValues;
    private final ArrayList<MutableTriple<IntSupplier, IntConsumer, Integer>> integerValues;
    private final ArrayList<MutableTriple<LongSupplier, LongConsumer, Long>> longValues;
    private final ArrayList<MutableTriple<Supplier, Consumer, Object>> objectValues;
    private List<Consumer<InventoryCrafting>> craftEvents;
    private Integer[] integerParts;
    private final TileLegacyMachineBase tile;

    public BuiltContainer(String name, Predicate<EntityPlayer> canInteract, List<Range<Integer>> playerSlotRange, List<Range<Integer>> tileSlotRange, TileLegacyMachineBase tile) {
        this.name = name;
        this.canInteract = canInteract;
        this.playerSlotRanges = playerSlotRange;
        this.tileSlotRanges = tileSlotRange;
        this.shortValues = new ArrayList();
        this.integerValues = new ArrayList();
        this.longValues = new ArrayList();
        this.objectValues = new ArrayList();
        this.tile = tile;
    }

    public void addShortSync(List<Pair<IntSupplier, IntConsumer>> syncables) {
        for (Pair<IntSupplier, IntConsumer> syncable : syncables) {
            this.shortValues.add((MutableTriple<IntSupplier, IntConsumer, Short>)MutableTriple.of((Object)syncable.getLeft(), (Object)syncable.getRight(), (Object)0));
        }
        this.shortValues.trimToSize();
    }

    public void addLongSync(List<Pair<LongSupplier, LongConsumer>> syncables) {
        for (Pair<LongSupplier, LongConsumer> syncable : syncables) {
            this.longValues.add((MutableTriple<LongSupplier, LongConsumer, Long>)MutableTriple.of((Object)syncable.getLeft(), (Object)syncable.getRight(), (Object)0L));
        }
        this.longValues.trimToSize();
    }

    public void addIntegerSync(List<Pair<IntSupplier, IntConsumer>> syncables) {
        for (Pair<IntSupplier, IntConsumer> syncable : syncables) {
            this.integerValues.add((MutableTriple<IntSupplier, IntConsumer, Integer>)MutableTriple.of((Object)syncable.getLeft(), (Object)syncable.getRight(), (Object)0));
        }
        this.integerValues.trimToSize();
        this.integerParts = new Integer[this.integerValues.size()];
    }

    public void addObjectSync(List<Pair<Supplier, Consumer>> syncables) {
        for (Pair<Supplier, Consumer> syncable : syncables) {
            this.objectValues.add((MutableTriple<Supplier, Consumer, Object>)MutableTriple.of((Object)syncable.getLeft(), (Object)syncable.getRight(), null));
        }
        this.objectValues.trimToSize();
    }

    public void addCraftEvents(List<Consumer<InventoryCrafting>> craftEvents) {
        this.craftEvents = craftEvents;
    }

    public void addSlot(Slot slot) {
        this.func_75146_a(slot);
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        if (this.tile != null) {
            return this.tile.func_70300_a(playerIn);
        }
        return this.canInteract.test(playerIn);
    }

    public final void func_75130_a(IInventory inv) {
        if (!this.craftEvents.isEmpty()) {
            this.craftEvents.forEach(consumer -> consumer.accept((InventoryCrafting)inv));
        }
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        Slot slot;
        if (dragType == 1 && slotId > 0 && slotId < 1000 && (slot = (Slot)this.field_75151_b.get(slotId)) instanceof IRightClickHandler && ((IRightClickHandler)slot).handleRightClick(slot.getSlotIndex(), player, this)) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    /*
     * Could not resolve type clashes
     */
    public void func_75142_b() {
        super.func_75142_b();
        for (IContainerListener listener : this.field_75149_d) {
            int supplied;
            int i = 0;
            if (!this.shortValues.isEmpty()) {
                for (MutableTriple value : this.shortValues) {
                    supplied = ((IntSupplier)value.getLeft()).getAsInt();
                    if (supplied != (Short)value.getRight()) {
                        listener.func_71112_a((Container)this, i, supplied);
                        value.setRight((Object)((short)supplied));
                    }
                    ++i;
                }
            }
            if (!this.integerValues.isEmpty()) {
                for (MutableTriple value : this.integerValues) {
                    supplied = ((IntSupplier)value.getLeft()).getAsInt();
                    if (supplied != (Integer)value.getRight()) {
                        listener.func_71112_a((Container)this, i, supplied >> 16);
                        listener.func_71112_a((Container)this, i + 1, (int)((short)(supplied & 0xFFFF)));
                        value.setRight((Object)supplied);
                    }
                    i += 2;
                }
            }
            if (!this.longValues.isEmpty()) {
                int longs = 0;
                for (MutableTriple<LongSupplier, LongConsumer, Long> value : this.longValues) {
                    long supplied2 = ((LongSupplier)value.getLeft()).getAsLong();
                    if (supplied2 != (Long)value.getRight()) {
                        this.sendLong(listener, this, longs, supplied2);
                        value.setRight((Object)supplied2);
                    }
                    ++longs;
                }
            }
            if (this.objectValues.isEmpty()) continue;
            int objects = 0;
            for (MutableTriple value : this.objectValues) {
                Object supplied3 = value.getLeft();
                if (((Supplier)supplied3).get() != value.getRight()) {
                    this.sendObject(listener, this, objects, ((Supplier)supplied3).get());
                    value.setRight(((Supplier)supplied3).get());
                }
                ++objects;
            }
        }
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        int i = 0;
        if (!this.shortValues.isEmpty()) {
            for (MutableTriple<IntSupplier, IntConsumer, Short> mutableTriple : this.shortValues) {
                short s2 = (short)((IntSupplier)mutableTriple.getLeft()).getAsInt();
                listener.func_71112_a((Container)this, i, (int)s2);
                mutableTriple.setRight((Object)s2);
                ++i;
            }
        }
        if (!this.integerValues.isEmpty()) {
            for (MutableTriple mutableTriple : this.integerValues) {
                int n = ((IntSupplier)mutableTriple.getLeft()).getAsInt();
                listener.func_71112_a((Container)this, i, n >> 16);
                listener.func_71112_a((Container)this, i + 1, (int)((short)(n & 0xFFFF)));
                mutableTriple.setRight((Object)n);
                i += 2;
            }
        }
        if (!this.longValues.isEmpty()) {
            int longs = 0;
            for (MutableTriple<LongSupplier, LongConsumer, Long> mutableTriple : this.longValues) {
                long supplied2 = ((LongSupplier)mutableTriple.getLeft()).getAsLong();
                this.sendLong(listener, this, longs, supplied2);
                mutableTriple.setRight((Object)supplied2);
                ++longs;
            }
        }
        if (!this.objectValues.isEmpty()) {
            int objects = 0;
            for (MutableTriple<Supplier, Consumer, Object> mutableTriple : this.objectValues) {
                Object supplied3 = mutableTriple.getLeft();
                this.sendObject(listener, this, objects, ((Supplier)supplied3).get());
                mutableTriple.setRight(supplied3);
                ++objects;
            }
        }
    }

    @Override
    public void handleLong(int var, long value) {
        ((LongConsumer)this.longValues.get(var).getMiddle()).accept(value);
    }

    @Override
    public void handleObject(int var, Object value) {
        ((Consumer)this.objectValues.get(var).getMiddle()).accept(value);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int value) {
        if (id < this.shortValues.size()) {
            ((IntConsumer)this.shortValues.get(id).getMiddle()).accept((short)value);
            this.shortValues.get(id).setRight((Object)((short)value));
        } else if (id - this.shortValues.size() < this.integerValues.size() * 2) {
            if ((id - this.shortValues.size()) % 2 == 0) {
                this.integerParts[(id - this.shortValues.size()) / 2] = value;
            } else {
                ((IntConsumer)this.integerValues.get((id - this.shortValues.size()) / 2).getMiddle()).accept((this.integerParts[(id - this.shortValues.size()) / 2] & 0xFFFF) << 16 | value & 0xFFFF);
            }
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack originalStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            originalStack = stackInSlot.func_77946_l();
            boolean shifted = false;
            for (Range<Integer> range : this.playerSlotRanges) {
                if (!range.contains((Object)index)) continue;
                if (!this.shiftToTile(stackInSlot)) break;
                shifted = true;
                break;
            }
            if (!shifted) {
                for (Range<Integer> range : this.tileSlotRanges) {
                    if (!range.contains((Object)index)) continue;
                    if (!this.shiftToPlayer(stackInSlot)) break;
                    shifted = true;
                    break;
                }
            }
            slot.func_75220_a(stackInSlot, originalStack);
            if (stackInSlot.func_190916_E() <= 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stackInSlot.func_190916_E() == originalStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, stackInSlot);
        }
        return originalStack;
    }

    protected boolean shiftItemStack(ItemStack stackToShift, int start, int end) {
        ItemStack stackInSlot;
        Slot slot;
        int slotIndex;
        boolean changed = false;
        if (stackToShift.func_77985_e()) {
            for (slotIndex = start; stackToShift.func_190916_E() > 0 && slotIndex < end; ++slotIndex) {
                int max;
                slot = (Slot)this.field_75151_b.get(slotIndex);
                stackInSlot = slot.func_75211_c();
                if (stackInSlot.func_190926_b() || !ItemUtils.isItemEqual(stackInSlot, stackToShift, true, true) || !slot.func_75214_a(stackToShift)) continue;
                int resultingStackSize = stackInSlot.func_190916_E() + stackToShift.func_190916_E();
                if (resultingStackSize <= (max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a()))) {
                    stackToShift.func_190920_e(0);
                    stackInSlot.func_190920_e(resultingStackSize);
                    slot.func_75218_e();
                    changed = true;
                    continue;
                }
                if (stackInSlot.func_190916_E() >= max) continue;
                stackToShift.func_190918_g(max - stackInSlot.func_190916_E());
                stackInSlot.func_190920_e(max);
                slot.func_75218_e();
                changed = true;
            }
        }
        if (stackToShift.func_190916_E() > 0) {
            for (slotIndex = start; stackToShift.func_190916_E() > 0 && slotIndex < end; ++slotIndex) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                stackInSlot = slot.func_75211_c();
                if (!stackInSlot.func_190926_b() || !slot.func_75214_a(stackToShift)) continue;
                int max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a());
                stackInSlot = stackToShift.func_77946_l();
                stackInSlot.func_190920_e(Math.min(stackToShift.func_190916_E(), max));
                stackToShift.func_190918_g(stackInSlot.func_190916_E());
                slot.func_75215_d(stackInSlot);
                slot.func_75218_e();
                changed = true;
            }
        }
        return changed;
    }

    private boolean shiftToTile(ItemStack stackToShift) {
        if (!this.tile.getInventoryForTile().isPresent()) {
            return false;
        }
        for (Range<Integer> range : this.tileSlotRanges) {
            if (!this.shiftItemStack(stackToShift, (Integer)range.getMinimum(), (Integer)range.getMaximum() + 1)) continue;
            return true;
        }
        return false;
    }

    private boolean shiftToPlayer(ItemStack stackToShift) {
        for (Range<Integer> range : this.playerSlotRanges) {
            if (!this.shiftItemStack(stackToShift, (Integer)range.getMinimum(), (Integer)range.getMaximum() + 1)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }
}

