/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.gen.feature;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import rtg.RTGConfig;

public class WorldGenShrubRTG
extends WorldGenerator {
    private int varSize;
    private IBlockState logBlock;
    private IBlockState leaveBlock;
    private boolean varSand;

    public WorldGenShrubRTG(int size, IBlockState log, IBlockState leav, boolean sand) {
        this.varSize = size;
        this.varSand = sand;
        this.logBlock = log;
        this.leaveBlock = leav;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int width = this.varSize > 6 ? 6 : this.varSize;
        int height = this.varSize > 3 ? 2 : 1;
        for (int i = 0; i < this.varSize; ++i) {
            int rX = rand.nextInt(width * 2) - width;
            int rY = rand.nextInt(height);
            int rZ = rand.nextInt(width * 2) - width;
            if (i == 0 && this.varSize > 4) {
                this.buildLeaves(world, x + rX, y, z + rZ, 3);
                continue;
            }
            if (i == 1 && this.varSize > 2) {
                this.buildLeaves(world, x + rX, y, z + rZ, 2);
                continue;
            }
            this.buildLeaves(world, x + rX, y + rY, z + rZ, 1);
        }
        return true;
    }

    public void buildLeaves(World world, int x, int y, int z, int size) {
        IBlockState b = world.func_180495_p(new BlockPos(x, y - 2, z));
        IBlockState b1 = world.func_180495_p(new BlockPos(x, y - 1, z));
        if (!(b != Blocks.field_150354_m.func_176223_P() && b1 != Blocks.field_150354_m.func_176223_P() || RTGConfig.treesCanGenerateOnSand())) {
            return;
        }
        if ((b.func_185904_a() == Material.field_151577_b || b.func_185904_a() == Material.field_151578_c || this.varSand && b.func_185904_a() == Material.field_151595_p) && b1 != Blocks.field_150355_j.func_176223_P()) {
            if (!RTGConfig.shrubsBelowSurface() && b1.func_185904_a() != Material.field_151579_a && b1.func_185904_a() != Material.field_151582_l && b1.func_185904_a() != Material.field_151585_k && b1 != Blocks.field_150431_aC.func_176223_P()) {
                return;
            }
            for (int i = -size; i <= size; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -size; k <= size; ++k) {
                        if (Math.abs(i) + Math.abs(j) + Math.abs(k) > size) continue;
                        this.buildBlock(world, x + i, y + j, z + k, this.leaveBlock);
                    }
                }
            }
            world.func_180501_a(new BlockPos(x, y - 1, z), this.logBlock, 0);
        }
    }

    public void buildBlock(World world, int x, int y, int z, IBlockState block) {
        IBlockState b = world.func_180495_p(new BlockPos(x, y, z));
        if (b.func_177230_c() == Blocks.field_150436_aH) {
            return;
        }
        if (b.func_185904_a() == Material.field_151579_a || b.func_185904_a() == Material.field_151582_l || b.func_185904_a() == Material.field_151585_k || b == Blocks.field_150431_aC) {
            world.func_180501_a(new BlockPos(x, y, z), block, 0);
        }
    }
}

