/*
 * Decompiled with CFR 0.152.
 */
package rtg.world;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.ChunkGeneratorOverworld;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.DimensionManager;
import rtg.RTG;
import rtg.api.RTGAPI;
import rtg.api.util.Logger;
import rtg.api.world.RTGWorld;
import rtg.world.biome.BiomeProviderRTG;
import rtg.world.gen.ChunkGeneratorRTG;

public final class WorldTypeRTG
extends WorldType {
    private static WorldTypeRTG INSTANCE;

    private WorldTypeRTG() {
        super("RTG");
    }

    public static WorldTypeRTG getInstance() {
        if (INSTANCE == null) {
            WorldTypeRTG.init();
        }
        return INSTANCE;
    }

    public static void init() {
        INSTANCE = new WorldTypeRTG();
    }

    public BiomeProvider getBiomeProvider(World world) {
        if (RTGAPI.isAllowedDimensionType(world.field_73011_w.getDimension()) || DimensionManager.getProviderType((int)world.field_73011_w.getDimension()).func_186067_c().equals("_rtg") || DimensionManager.getProviderType((int)world.field_73011_w.getDimension()).name().startsWith("jed_surface")) {
            Logger.debug("WorldType#getBiomeProvider: Allowed DimensionType detected (ID:{}, Type:{}, Suffix:{}).. returning BiomeProviderRTG", world.field_73011_w.getDimension(), world.field_73011_w.func_186058_p(), DimensionManager.getProviderType((int)world.field_73011_w.getDimension()).func_186067_c());
            return new BiomeProviderRTG(RTGWorld.getInstance(world));
        }
        Logger.debug("WorldType#getBiomeProvider: DimensionType not in whitelist (ID:{}, Type:{}, Suffix:{}).. returning BiomeProvider", world.field_73011_w.getDimension(), world.field_73011_w.func_186058_p(), DimensionManager.getProviderType((int)world.field_73011_w.getDimension()).func_186067_c());
        return new BiomeProvider(world.func_72912_H());
    }

    public IChunkGenerator getChunkGenerator(World world, String generatorOptions) {
        if (RTGAPI.isAllowedDimensionType(world.field_73011_w.getDimension()) || DimensionManager.getProviderType((int)world.field_73011_w.getDimension()).func_186067_c().equals("_rtg") || DimensionManager.getProviderType((int)world.field_73011_w.getDimension()).name().startsWith("jed_surface")) {
            Logger.debug("WorldType#getChunkGenerator: Allowed DimensionType detected (ID:{}, Type:{}, Suffix:{}).. returning ChunkGeneratorRTG", world.field_73011_w.getDimension(), world.field_73011_w.func_186058_p(), DimensionManager.getProviderType((int)world.field_73011_w.getDimension()).func_186067_c());
            return new ChunkGeneratorRTG(RTGWorld.getInstance(world));
        }
        Logger.debug("WorldType#getChunkGenerator: DimensionType not in whitelist (ID:{}, Type:{}, Suffix:{}).. returning ChunkGeneratorOverworld", world.field_73011_w.getDimension(), world.field_73011_w.func_186058_p(), DimensionManager.getProviderType((int)world.field_73011_w.getDimension()).func_186067_c());
        return new ChunkGeneratorOverworld(world, world.func_72912_H().func_76063_b(), world.func_72912_H().func_76089_r(), world.func_72912_H().func_82571_y());
    }

    public float getCloudHeight() {
        return 256.0f;
    }

    public boolean isCustomizable() {
        return true;
    }

    public String func_77128_b() {
        return "gui.createWorld.worldtypename";
    }

    public void onCustomizeButton(Minecraft mc, GuiCreateWorld guiCreateWorld) {
        RTG.getProxy().displayCustomizeWorldScreen(guiCreateWorld);
    }
}

