/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.biomesoplenty;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.BlockUtil;
import rtg.api.util.noise.ISimplexData2D;
import rtg.api.util.noise.SimplexData2D;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.deco.DecoBoulder;
import rtg.api.world.deco.DecoFallenTree;
import rtg.api.world.deco.helper.DecoHelper5050;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.world.biome.realistic.biomesoplenty.RealisticBiomeBOPBase;

public class RealisticBiomeBOPShield
extends RealisticBiomeBOPBase {
    public static Biome biome = (Biome)BOPBiomes.shield.orNull();
    public static Biome river = Biomes.field_76781_i;
    private double lakeWaterLevel = 0.04;
    private double lakeDepressionLevel = 0.3;

    public RealisticBiomeBOPShield() {
        super(biome);
    }

    @Override
    public Biome preferredBeach() {
        return (Biome)BOPBiomes.gravel_beach.orNull();
    }

    @Override
    public void initConfig() {
        this.getConfig().addProperty(this.getConfig().ALLOW_LOGS).set(true);
        this.getConfig().addProperty(this.getConfig().FALLEN_LOG_DENSITY_MULTIPLIER);
        this.getConfig().addProperty(this.getConfig().SURFACE_MIX_BLOCK).set("");
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainBOPShield();
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceBOPShield(this.getConfig(), RealisticBiomeBOPShield.biome.field_76752_A, RealisticBiomeBOPShield.biome.field_76753_B, 0.0f, 1.5f, 60.0f, 65.0f, 1.5f, Blocks.field_150348_b.func_176223_P(), 0.1f);
    }

    @Override
    public float lakePressure(RTGWorld rtgWorld, int x, int y, float border, float lakeInterval, float largeBendSize, float mediumBendSize, float smallBendSize) {
        double pX = x;
        double pY = y;
        ISimplexData2D jitterData = SimplexData2D.newDisk();
        rtgWorld.simplexInstance(1).multiEval2D((double)x / 40.0, (double)y / 40.0, jitterData);
        return TerrainBase.bayesianAdjustment((float)rtgWorld.cellularInstance(0).eval2D((pX += jitterData.getDeltaX() * 35.0) / 150.0, (pY += jitterData.getDeltaY() * 35.0) / 150.0).interiorValue(), 0.25f);
    }

    @Override
    public float erodedNoise(RTGWorld rtgWorld, int x, int y, float river, float border, float biomeHeight) {
        float riverFlattening = 1.0f - river;
        if ((riverFlattening -= 0.90625f) < 0.0f) {
            return biomeHeight;
        }
        float r = 1.0f - (riverFlattening /= 0.09375f);
        if ((riverFlattening = riverFlattening * 1.4f - 0.4f) < 0.0f) {
            riverFlattening = 0.0f;
        }
        if (r < 1.0f && biomeHeight > 57.0f) {
            float irregularity = rtgWorld.simplexInstance(0).noise2f((float)x / 12.0f, (float)y / 12.0f) * 2.0f + rtgWorld.simplexInstance(0).noise2f((float)x / 8.0f, (float)y / 8.0f);
            return biomeHeight * r + (57.0f + (irregularity *= 1.0f + r)) * 1.0f * (1.0f - r);
        }
        return biomeHeight;
    }

    @Override
    public float lakeFlattening(float pressure, float bottomLevel, float topLevel) {
        return pressure;
    }

    @Override
    public void initDecos() {
        DecoBoulder decoBoulder = new DecoBoulder();
        decoBoulder.setBoulderBlock(Blocks.field_150347_e.func_176223_P());
        decoBoulder.setMaxY(80);
        decoBoulder.setChance(16);
        decoBoulder.setStrengthFactor(1.0f);
        this.addDeco(decoBoulder);
        DecoFallenTree decoFallenTree1 = new DecoFallenTree();
        decoFallenTree1.getDistribution().setNoiseDivisor(80.0f);
        decoFallenTree1.getDistribution().setNoiseFactor(60.0f);
        decoFallenTree1.getDistribution().setNoiseAddend(-15.0f);
        decoFallenTree1.setLogCondition(DecoFallenTree.LogCondition.RANDOM_CHANCE);
        decoFallenTree1.setLogConditionChance(6);
        decoFallenTree1.setMaxY(100);
        decoFallenTree1.setLogBlock(BOPBlocks.log_2.func_176203_a(6));
        decoFallenTree1.setLeavesBlock(Blocks.field_150362_t.func_176223_P());
        decoFallenTree1.setMinSize(3);
        decoFallenTree1.setMaxSize(4);
        DecoFallenTree decoFallenTree2 = new DecoFallenTree();
        decoFallenTree2.getDistribution().setNoiseDivisor(80.0f);
        decoFallenTree2.getDistribution().setNoiseFactor(60.0f);
        decoFallenTree2.getDistribution().setNoiseAddend(-15.0f);
        decoFallenTree2.setLogCondition(DecoFallenTree.LogCondition.RANDOM_CHANCE);
        decoFallenTree2.setLogConditionChance(6);
        decoFallenTree2.setMaxY(100);
        decoFallenTree2.setLogBlock(BlockUtil.getStateLog(BlockPlanks.EnumType.SPRUCE));
        decoFallenTree2.setLeavesBlock(BlockUtil.getStateLeaf(BlockPlanks.EnumType.SPRUCE));
        decoFallenTree2.setMinSize(3);
        decoFallenTree2.setMaxSize(4);
        DecoHelper5050 decoHelperHelper5050 = new DecoHelper5050(decoFallenTree1, decoFallenTree2);
        this.addDeco(decoHelperHelper5050, this.getConfig().ALLOW_LOGS.get());
    }

    public static class SurfaceBOPShield
    extends SurfaceBase {
        private float min;
        private float sCliff = 1.5f;
        private float sHeight = 60.0f;
        private float sStrength = 65.0f;
        private float cCliff = 1.5f;
        private IBlockState mixBlock;
        private float mixHeight;

        public SurfaceBOPShield(BiomeConfig config, IBlockState top, IBlockState fill, float minCliff, float stoneCliff, float stoneHeight, float stoneStrength, float clayCliff, IBlockState mix, float mixSize) {
            super(config, top, fill);
            this.min = minCliff;
            this.sCliff = stoneCliff;
            this.sHeight = stoneHeight;
            this.sStrength = stoneStrength;
            this.cCliff = clayCliff;
            this.mixBlock = this.getConfigBlock(config.SURFACE_MIX_BLOCK.get(), mix);
            this.mixHeight = mixSize;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            int cliff = 0;
            boolean m = false;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                if (++depth == 0) {
                    float p = simplex.noise3f((float)i / 8.0f, (float)j / 8.0f, (float)k / 8.0f) * 0.5f;
                    if (c > this.min && c > this.sCliff - ((float)k - this.sHeight) / this.sStrength + p) {
                        cliff = 1;
                    }
                    if (c > this.cCliff) {
                        cliff = 2;
                    }
                    if (cliff == 1) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (cliff == 2) {
                        primer.func_177855_a(x, k, z, this.getShadowStoneBlock());
                        continue;
                    }
                    if (k < 63) {
                        if (k < 62) {
                            primer.func_177855_a(x, k, z, this.fillerBlock);
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.topBlock);
                        continue;
                    }
                    if (simplex.noise2f((float)i / 12.0f, (float)j / 12.0f) > this.mixHeight) {
                        primer.func_177855_a(x, k, z, this.mixBlock);
                        m = true;
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 6) continue;
                if (cliff == 1) {
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (cliff == 2) {
                    primer.func_177855_a(x, k, z, this.getShadowStoneBlock());
                    continue;
                }
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainBOPShield
    extends TerrainBase {
        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainBOPShield.terrainPlains(x, y, rtgWorld, river, 160.0f, 10.0f, 60.0f, 200.0f, 64.0f);
        }
    }
}

