/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.biomesyougo;

import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import rtg.api.config.BiomeConfig;
import rtg.api.util.BlockUtil;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.deco.DecoWorldGen;
import rtg.api.world.gen.feature.WorldGenPond;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.world.biome.realistic.biomesyougo.RealisticBiomeBYGBase;

public class RealisticBiomeBYGDeadSea
extends RealisticBiomeBYGBase {
    private static IBlockState bygMixBlock = BlockUtil.getBlockStateFromCfgString("byg:sodalite", BlockUtil.getStateStone(BlockStone.EnumType.GRANITE));

    public RealisticBiomeBYGDeadSea(Biome biome) {
        super(biome, RealisticBiomeBase.RiverType.NORMAL, RealisticBiomeBase.BeachType.NORMAL);
    }

    @Override
    public Biome preferredBeach() {
        return this.baseBiome();
    }

    @Override
    public double waterLakeMult() {
        return 4.0;
    }

    @Override
    public void initConfig() {
        this.getConfig().addProperty(this.getConfig().SURFACE_MIX_BLOCK).set("");
        this.getConfig().addProperty(this.getConfig().SURFACE_MIX_2_BLOCK).set("");
        this.getConfig().addProperty(this.getConfig().PLATEAU_GRADIENT_BLOCK_LIST).set((Comparable[])Collections.unmodifiableCollection(Arrays.asList("minecraft:stone", "minecraft:cobblestone", "minecraft:stone", "minecraft:stone", "minecraft:cobblestone", "byg:sodalite")).toArray(new String[0]));
    }

    @Override
    public void initDecos() {
        WorldGenPond pond = new WorldGenPond(Blocks.field_150355_j.func_176223_P());
        DecoWorldGen decoPond = new DecoWorldGen(pond);
        decoPond.setChance(1);
        decoPond.setMinY(62);
        decoPond.setMaxY(66);
        decoPond.setEventType(DecorateBiomeEvent.Decorate.EventType.LAKE_WATER);
        this.addDeco(decoPond);
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainRTGMesaBryce();
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceVanillaMesaBryce(this.getConfig(), this.baseBiome().field_76752_A, this.baseBiome().field_76752_A, 0);
    }

    public class SurfaceVanillaMesaBryce
    extends SurfaceBase {
        private int grassRaise;
        private IBlockState mixBlock;
        private IBlockState mix2Block;

        public SurfaceVanillaMesaBryce(BiomeConfig config, IBlockState top, IBlockState fill, int grassHeight) {
            super(config, top, fill);
            this.grassRaise = 0;
            this.grassRaise = grassHeight;
            this.mixBlock = this.getConfigBlock(config.SURFACE_MIX_BLOCK.get(), top);
            this.mix2Block = this.getConfigBlock(config.SURFACE_MIX_2_BLOCK.get(), top);
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            float c = TerrainBase.calcCliff(x, z, noise);
            boolean cliff = c > 1.3f;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (cliff) {
                    if (depth > -1 && depth < 2) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (depth >= 10) continue;
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (k > 74 + this.grassRaise) {
                    if (depth == 0) {
                        if (rand.nextInt(5) == 0) {
                            primer.func_177855_a(x, k, z, this.mix2Block);
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.topBlock);
                        continue;
                    }
                    if (depth >= 4) continue;
                    primer.func_177855_a(x, k, z, this.fillerBlock);
                    continue;
                }
                if (depth == 0 && k > 61) {
                    int r = (int)((float)(k - (62 + this.grassRaise)) / 2.0f);
                    if (rand.nextInt(r + 2) == 0) {
                        primer.func_177855_a(x, k, z, this.mixBlock);
                        continue;
                    }
                    if (rand.nextInt((int)((float)r / 2.0f) + 2) == 0) {
                        primer.func_177855_a(x, k, z, this.mix2Block);
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 4) continue;
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public class TerrainRTGMesaBryce
    extends TerrainBase {
        private static final float height = 20.0f;

        TerrainRTGMesaBryce() {
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float sn = simplex.noise2f((float)x / 2.0f, (float)y / 2.0f) * 0.5f + 0.5f;
            sn = (float)((double)sn + ((double)simplex.noise2f(x, y) * 0.2 + 0.2));
            sn += simplex.noise2f((float)x / 4.0f, (float)y / 4.0f) * 4.0f + 4.0f;
            float n = 20.0f / (sn += simplex.noise2f((float)x / 8.0f, (float)y / 8.0f) * 2.0f + 2.0f) * 2.0f;
            n = sn < 6.0f ? (n += simplex.noise2f((float)x / 64.0f, (float)y / 64.0f) * 4.0f) : 0.0f;
            return TerrainRTGMesaBryce.riverized(TerrainRTGMesaBryce.getTerrainBase() + n, river);
        }
    }
}

