/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.forge_1_12_2;

import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.server.management.UserListBans;
import net.minecraft.server.management.UserListIPBans;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapCommonAPIListener;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapLocation;
import org.dynmap.DynmapWorld;
import org.dynmap.Log;
import org.dynmap.MapManager;
import org.dynmap.PlayerList;
import org.dynmap.common.BiomeMap;
import org.dynmap.common.DynmapCommandSender;
import org.dynmap.common.DynmapListenerManager;
import org.dynmap.common.DynmapPlayer;
import org.dynmap.common.DynmapServerInterface;
import org.dynmap.debug.Debug;
import org.dynmap.forge_1_12_2.DmapCommand;
import org.dynmap.forge_1_12_2.DmarkerCommand;
import org.dynmap.forge_1_12_2.DynmapCommand;
import org.dynmap.forge_1_12_2.DynmapExpCommand;
import org.dynmap.forge_1_12_2.DynmapMod;
import org.dynmap.forge_1_12_2.ForgeMapChunkCache;
import org.dynmap.forge_1_12_2.ForgeWorld;
import org.dynmap.forge_1_12_2.SnapshotCache;
import org.dynmap.forge_1_12_2.VersionCheck;
import org.dynmap.forge_1_12_2.permissions.FilePermissions;
import org.dynmap.forge_1_12_2.permissions.OpPermissions;
import org.dynmap.forge_1_12_2.permissions.PermissionProvider;
import org.dynmap.hdmap.HDBlockModels;
import org.dynmap.permissions.PermissionsHandler;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.utils.DynmapLogger;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.VisibilityLimit;

public class DynmapPlugin {
    private DynmapCore core;
    private PermissionProvider permissions;
    private boolean core_enabled;
    public SnapshotCache sscache;
    public PlayerList playerList;
    private MapManager mapManager;
    private MinecraftServer server;
    public static DynmapPlugin plugin;
    private ChatHandler chathandler;
    private HashMap<String, Integer> sortWeights = new HashMap();
    private long worldIdleTimeoutNS = 30000000000L;
    private HashMap<String, ForgeWorld> worlds = new HashMap();
    private World last_world;
    private ForgeWorld last_fworld;
    private Map<String, ForgePlayer> players = new HashMap<String, ForgePlayer>();
    private HashSet<String> modsused = new HashSet();
    private ForgeServer fserver = new ForgeServer();
    private boolean tickregistered = false;
    private double tps;
    private long lasttick;
    private long avgticklen;
    private long perTickLimit = 50000000L;
    private boolean isMCPC = false;
    private boolean useSaveFolder = true;
    private Field displayName = null;
    private static final String[] TRIGGER_DEFAULTS;
    private static final Pattern patternControlCode;
    ConcurrentLinkedQueue<BlockUpdateRec> blockupdatequeue = new ConcurrentLinkedQueue();
    public static DynmapBlockState[] stateByID;
    private static Biome[] biomelist;
    private ConcurrentLinkedQueue<ChatMessage> msgqueue = new ConcurrentLinkedQueue();
    private static HashMap<Integer, WorldBusyRecord> busy_worlds;
    private static final Gson gson;
    private PlayerTracker playerTracker = null;
    private boolean onblockchange = false;
    private boolean onlightingchange = false;
    private boolean onchunkpopulate = false;
    private boolean onchunkgenerate = false;
    private boolean onblockchange_with_id = false;
    private WorldTracker worldTracker = null;
    private HashMap<String, WorldUpdateTracker> updateTrackers = new HashMap();

    public void initializeBlockStates() {
        stateByID = new DynmapBlockState[8192];
        Arrays.fill(stateByID, DynmapBlockState.AIR);
        for (Block b : Block.field_149771_c) {
            String bn;
            int i = Block.func_149682_b((Block)b);
            if (i >= stateByID.length >> 4) {
                int plen = stateByID.length;
                stateByID = Arrays.copyOf(stateByID, i + 1 << 4);
                Arrays.fill(stateByID, plen, stateByID.length, DynmapBlockState.AIR);
            }
            ResourceLocation ui = null;
            try {
                ui = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)b);
            }
            catch (Exception x) {
                Log.warning("Exception caught reading unique ID for block " + i);
            }
            if (ui == null || (bn = ui.func_110624_b() + ":" + ui.func_110623_a()).equals(DynmapBlockState.AIR_BLOCK)) continue;
            DynmapBlockState basebs = null;
            for (int m = 0; m < 16; ++m) {
                Material mat = Material.field_151579_a;
                IBlockState blkstate = null;
                try {
                    blkstate = b.func_176203_a(m);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String statename = "meta=" + m;
                if (blkstate != null) {
                    mat = blkstate.func_185904_a();
                    String pstate = null;
                    for (Map.Entry p : blkstate.func_177228_b().entrySet()) {
                        pstate = pstate == null ? "" : pstate + ",";
                        pstate = pstate + ((IProperty)p.getKey()).func_177701_a() + "=" + ((Comparable)p.getValue()).toString();
                    }
                    if (pstate != null) {
                        statename = pstate;
                    }
                }
                DynmapBlockState bs = new DynmapBlockState(basebs, m, bn, statename, mat.toString(), i);
                if (basebs == null) {
                    basebs = bs;
                }
                DynmapPlugin.stateByID[(i << 4) + m] = bs;
                if (mat.func_76220_a()) {
                    bs.setSolid();
                }
                if (mat == Material.field_151579_a) {
                    bs.setAir();
                }
                if (mat == Material.field_151575_d) {
                    bs.setLog();
                }
                if (mat != Material.field_151584_j) continue;
                bs.setLeaves();
            }
        }
    }

    public static final int getBlockID(World w, int x, int y, int z) {
        return Block.func_149682_b((Block)w.func_180495_p(new BlockPos(x, y, z)).func_177230_c());
    }

    public static final Block getBlockByID(int id) {
        return Block.func_149729_e((int)id);
    }

    public static final Item getItemByID(int id) {
        return Item.func_150899_d((int)id);
    }

    public static final String getBlockUnlocalizedName(Block b) {
        String s = b.func_149739_a();
        if (s.startsWith("tile.")) {
            s = s.substring(5);
        }
        return s;
    }

    public static final Biome[] getBiomeList() {
        if (biomelist == null) {
            biomelist = new Biome[256];
            for (Biome b : Biome.field_185377_q) {
                int bidx = Biome.func_185362_a((Biome)b);
                if (bidx >= biomelist.length) {
                    biomelist = Arrays.copyOf(biomelist, bidx + biomelist.length);
                }
                DynmapPlugin.biomelist[bidx] = b;
            }
        }
        return biomelist;
    }

    public static final NetworkManager getNetworkManager(NetHandlerPlayServer nh) {
        return nh.field_147371_a;
    }

    private ForgePlayer getOrAddPlayer(EntityPlayer p) {
        String name = p.func_174793_f().func_70005_c_();
        ForgePlayer fp = this.players.get(name);
        if (fp != null) {
            fp.player = p;
        } else {
            fp = new ForgePlayer(p);
            this.players.put(name, fp);
        }
        return fp;
    }

    private void setBusy(World w) {
        DynmapPlugin.setBusy(w, null);
    }

    static void setBusy(World w, ForgeChunkManager.Ticket t) {
        if (w == null) {
            return;
        }
        if (!DynmapMod.useforcedchunks) {
            return;
        }
        WorldBusyRecord wbr = busy_worlds.get(w.field_73011_w.getDimension());
        if (wbr == null) {
            Debug.debug("World " + w.func_72912_H().func_76065_j() + "/" + w.field_73011_w.func_186058_p().func_186065_b() + " is busy");
            wbr = new WorldBusyRecord();
            wbr.ticket = t != null ? t : ForgeChunkManager.requestTicket((Object)DynmapMod.instance, (World)w, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            if (wbr.ticket != null) {
                BlockPos cc = w.func_175694_M();
                ChunkPos ccip = new ChunkPos(cc.func_177958_n() >> 4, cc.func_177952_p() >> 4);
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)wbr.ticket, (ChunkPos)ccip);
                busy_worlds.put(w.field_73011_w.getDimension(), wbr);
            }
        }
        wbr.last_ts = System.nanoTime();
    }

    private void doIdleOutOfWorlds() {
        if (!DynmapMod.useforcedchunks) {
            return;
        }
        long ts = System.nanoTime() - this.worldIdleTimeoutNS;
        Iterator<WorldBusyRecord> itr = busy_worlds.values().iterator();
        while (itr.hasNext()) {
            WorldBusyRecord wbr = itr.next();
            if (wbr.last_ts >= ts) continue;
            World w = wbr.ticket.world;
            Debug.debug("World " + w.func_72912_H().func_76065_j() + "/" + wbr.ticket.world.field_73011_w.func_186058_p().func_186065_b() + " is idle");
            if (wbr.ticket != null) {
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)wbr.ticket);
            }
            itr.remove();
        }
    }

    public DynmapPlugin(MinecraftServer srv) {
        plugin = this;
        this.server = srv;
        this.displayName = null;
        try {
            this.displayName = EntityPlayerMP.class.getField("displayName");
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    public boolean isOp(String player) {
        player = player.toLowerCase();
        return this.server.func_184103_al().func_152603_m().func_152700_a(player) != null || this.server.func_71264_H() && player.equalsIgnoreCase(this.server.func_71214_G());
    }

    private boolean hasPerm(ICommandSender sender, String permission) {
        PermissionsHandler ph = PermissionsHandler.getHandler();
        if (ph != null && sender instanceof EntityPlayer && ph.hasPermission(sender.func_174793_f().func_70005_c_(), permission)) {
            return true;
        }
        return this.permissions.has(sender, permission);
    }

    private boolean hasPermNode(ICommandSender sender, String permission) {
        PermissionsHandler ph = PermissionsHandler.getHandler();
        if (ph != null && sender instanceof EntityPlayer && ph.hasPermissionNode(sender.func_174793_f().func_70005_c_(), permission)) {
            return true;
        }
        return this.permissions.hasPermissionNode(sender, permission);
    }

    private Set<String> hasOfflinePermissions(String player, Set<String> perms) {
        Set<String> rslt = null;
        PermissionsHandler ph = PermissionsHandler.getHandler();
        if (ph != null) {
            rslt = ph.hasOfflinePermissions(player, perms);
        }
        Set<String> rslt2 = this.hasOfflinePermissions(player, perms);
        if (rslt != null && rslt2 != null) {
            HashSet<String> newrslt = new HashSet<String>(rslt);
            newrslt.addAll(rslt2);
            rslt = newrslt;
        } else if (rslt2 != null) {
            rslt = rslt2;
        }
        return rslt;
    }

    private boolean hasOfflinePermission(String player, String perm) {
        PermissionsHandler ph = PermissionsHandler.getHandler();
        if (ph != null && ph.hasOfflinePermission(player, perm)) {
            return true;
        }
        return this.permissions.hasOfflinePermission(player, perm);
    }

    public void loadExtraBiomes(String mcver) {
        int cnt = 0;
        BiomeMap.loadWellKnownByVersion(mcver);
        Biome[] list = DynmapPlugin.getBiomeList();
        for (int i = 0; i < list.length; ++i) {
            Biome bb = list[i];
            if (bb == null) continue;
            String id = bb.field_76791_y;
            float tmp = bb.func_185353_n();
            float hum = bb.func_76727_i();
            BiomeMap bmap = BiomeMap.byBiomeID(i);
            if (bmap.isDefault()) {
                BiomeMap m = new BiomeMap(i, id, tmp, hum);
                Log.verboseinfo("Add custom biome [" + m.toString() + "] (" + i + ")");
                ++cnt;
                continue;
            }
            bmap.setTemperature(tmp);
            bmap.setRainfall(hum);
        }
        if (cnt > 0) {
            Log.info("Added " + cnt + " custom biome mappings");
        }
    }

    private String[] getBiomeNames() {
        Biome[] list = DynmapPlugin.getBiomeList();
        String[] lst = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            Biome bb = list[i];
            if (bb == null) continue;
            lst[i] = bb.field_76791_y;
        }
        return lst;
    }

    public void onEnable() {
        File dataDirectory;
        String mcver = this.server.func_71249_w();
        this.loadExtraBiomes(mcver);
        this.registerPlayerLoginListener();
        this.permissions = FilePermissions.create();
        if (this.permissions == null) {
            this.permissions = new OpPermissions(new String[]{"webchat", "marker.icons", "marker.list", "webregister", "stats", "hide.self", "show.self"});
        }
        if (!(dataDirectory = new File("dynmap")).exists()) {
            dataDirectory.mkdirs();
        }
        if (this.core == null) {
            this.core = new DynmapCore();
        }
        this.core.setPluginJarFile(DynmapMod.jarfile);
        this.core.setPluginVersion("3.0-beta-4-213");
        this.core.setMinecraftVersion(mcver);
        this.core.setDataFolder(dataDirectory);
        this.core.setServer(this.fserver);
        ForgeMapChunkCache.init();
        this.core.setTriggerDefault(TRIGGER_DEFAULTS);
        this.core.setBiomeNames(this.getBiomeNames());
        if (!this.core.initConfiguration(null)) {
            return;
        }
        DynmapCommonAPIListener.apiInitialized(this.core);
    }

    public void onStart() {
        this.initializeBlockStates();
        if (!this.core.enableCore(null)) {
            return;
        }
        this.core_enabled = true;
        VersionCheck.runCheck(this.core);
        this.perTickLimit = this.core.getMaxTickUseMS() * 1000000;
        this.lasttick = System.nanoTime();
        this.tps = 20.0;
        if (!this.tickregistered) {
            MinecraftForge.EVENT_BUS.register((Object)this.fserver);
            this.tickregistered = true;
        }
        this.playerList = this.core.playerList;
        this.sscache = new SnapshotCache(this.core.getSnapShotCacheSize(), this.core.useSoftRefInSnapShotCache());
        this.mapManager = this.core.getMapManager();
        this.loadWorlds();
        if (this.server.field_71305_c != null) {
            for (WorldServer world : this.server.field_71305_c) {
                ForgeWorld forgeWorld = this.getWorld((World)world);
            }
        }
        for (ForgeWorld w : this.worlds.values()) {
            if (!this.core.processWorldLoad(w) || !w.isLoaded()) continue;
            this.core.listenerManager.processWorldEvent(DynmapListenerManager.EventType.WORLD_LOAD, w);
        }
        this.core.updateConfigHashcode();
        this.registerEvents();
        Log.info("Register events");
        ICommandManager cm = this.server.func_71187_D();
        if (cm instanceof CommandHandler) {
            CommandHandler scm = (CommandHandler)cm;
            scm.func_71560_a((ICommand)new DynmapCommand(this));
            scm.func_71560_a((ICommand)new DmapCommand(this));
            scm.func_71560_a((ICommand)new DmarkerCommand(this));
            scm.func_71560_a((ICommand)new DynmapExpCommand(this));
            Log.info("Register commands");
        }
        this.initMetrics();
        Log.info("Enabled");
    }

    public void onDisable() {
        DynmapCommonAPIListener.apiTerminated();
        this.saveWorlds();
        this.fserver.runqueue.clear();
        this.core.disableCore();
        this.core_enabled = false;
        if (this.sscache != null) {
            this.sscache.cleanup();
            this.sscache = null;
        }
        Log.info("Disabled");
    }

    void onCommand(ICommandSender sender, String cmd, String[] args) {
        ForgeCommandSender dsender = sender instanceof EntityPlayer ? this.getOrAddPlayer((EntityPlayer)sender) : new ForgeCommandSender(sender);
        this.core.processCommand(dsender, cmd, cmd, args);
    }

    private DynmapLocation toLoc(World worldObj, double x, double y, double z) {
        return new DynmapLocation(this.getWorld(worldObj).getName(), x, y, z);
    }

    private void registerPlayerLoginListener() {
        if (this.playerTracker == null) {
            this.playerTracker = new PlayerTracker();
            MinecraftForge.EVENT_BUS.register((Object)this.playerTracker);
        }
    }

    private void registerEvents() {
        if (this.worldTracker == null) {
            this.worldTracker = new WorldTracker();
            MinecraftForge.EVENT_BUS.register((Object)this.worldTracker);
        }
        this.onblockchange = this.core.isTrigger("blockupdate");
        this.onlightingchange = this.core.isTrigger("lightingupdate");
        this.onchunkpopulate = this.core.isTrigger("chunkpopulate");
        this.onchunkgenerate = this.core.isTrigger("chunkgenerate");
        this.onblockchange_with_id = this.core.isTrigger("blockupdate-with-id");
        if (this.onblockchange_with_id) {
            this.onblockchange = true;
        }
    }

    private ForgeWorld getWorldByName(String name) {
        return this.worlds.get(name);
    }

    private ForgeWorld getWorld(World w) {
        return this.getWorld(w, true);
    }

    private ForgeWorld getWorld(World w, boolean add_if_not_found) {
        if (this.last_world == w) {
            return this.last_fworld;
        }
        String wname = ForgeWorld.getWorldName(w);
        for (ForgeWorld fw : this.worlds.values()) {
            if (!fw.getRawName().equals(wname)) continue;
            this.last_world = w;
            this.last_fworld = fw;
            if (!fw.isLoaded()) {
                fw.setWorldLoaded(w);
                WorldUpdateTracker wit = new WorldUpdateTracker();
                wit.worldid = fw.getName();
                wit.world = w;
                this.updateTrackers.put(fw.getName(), wit);
                w.func_72954_a((IWorldEventListener)wit);
            }
            return fw;
        }
        ForgeWorld fw = null;
        if (add_if_not_found) {
            fw = new ForgeWorld(w);
            this.worlds.put(fw.getName(), fw);
            WorldUpdateTracker wit = new WorldUpdateTracker();
            wit.worldid = fw.getName();
            wit.world = w;
            this.updateTrackers.put(fw.getName(), wit);
            w.func_72954_a((IWorldEventListener)wit);
        }
        this.last_world = w;
        this.last_fworld = fw;
        return fw;
    }

    private void initMetrics() {
    }

    private void saveWorlds() {
        File f = new File(this.core.getDataFolder(), "forgeworlds.yml");
        ConfigurationNode cn = new ConfigurationNode(f);
        ArrayList lst = new ArrayList();
        for (DynmapWorld fw : this.core.mapManager.getWorlds()) {
            HashMap<String, Object> vals = new HashMap<String, Object>();
            vals.put("name", fw.getRawName());
            vals.put("height", fw.worldheight);
            vals.put("sealevel", fw.sealevel);
            vals.put("nether", fw.isNether());
            vals.put("the_end", ((ForgeWorld)fw).isTheEnd());
            vals.put("title", fw.getTitle());
            lst.add(vals);
        }
        cn.put("worlds", (Object)lst);
        cn.put("isMCPC", (Object)this.isMCPC);
        cn.put("useSaveFolderAsName", (Object)this.useSaveFolder);
        cn.put("maxWorldHeight", (Object)ForgeWorld.getMaxWorldHeight());
        cn.save();
    }

    private void loadWorlds() {
        this.isMCPC = this.server.getServerModName().contains("mcpc");
        File f = new File(this.core.getDataFolder(), "forgeworlds.yml");
        if (!f.canRead()) {
            this.useSaveFolder = true;
            if (this.isMCPC) {
                ForgeWorld.setMCPCMapping();
            } else {
                ForgeWorld.setSaveFolderMapping();
            }
            return;
        }
        ConfigurationNode cn = new ConfigurationNode(f);
        cn.load();
        ForgeWorld.setMaxWorldHeight(cn.getInteger("maxWorldHeight", 256));
        this.useSaveFolder = this.isMCPC;
        if (cn.containsKey("useSaveFolderAsName")) {
            this.useSaveFolder = cn.getBoolean("useSaveFolderAsName", this.useSaveFolder);
        }
        if (this.isMCPC) {
            ForgeWorld.setMCPCMapping();
        } else if (this.useSaveFolder) {
            ForgeWorld.setSaveFolderMapping();
        }
        if (this.isMCPC != cn.getBoolean("isMCPC", false)) {
            return;
        }
        List<Map<String, Object>> lst = cn.getMapList("worlds");
        if (lst == null) {
            Log.warning("Discarding bad forgeworlds.yml");
            return;
        }
        for (Map<String, Object> world : lst) {
            try {
                String name = (String)world.get("name");
                int height = (Integer)world.get("height");
                int sealevel = (Integer)world.get("sealevel");
                boolean nether = (Boolean)world.get("nether");
                boolean theend = (Boolean)world.get("the_end");
                String title = (String)world.get("title");
                if (name == null) continue;
                ForgeWorld fw = new ForgeWorld(name, height, sealevel, nether, theend, title);
                fw.setWorldUnloaded();
                this.core.processWorldLoad(fw);
                this.worlds.put(fw.getName(), fw);
            }
            catch (Exception x) {
                Log.warning("Unable to load saved worlds from forgeworlds.yml");
                return;
            }
        }
    }

    public void serverStarted() {
        this.onStart();
        if (this.core != null) {
            this.core.serverStarted();
        }
    }

    static {
        TRIGGER_DEFAULTS = new String[]{"blockupdate", "chunkpopulate", "chunkgenerate"};
        patternControlCode = Pattern.compile("(?i)\\u00A7[0-9A-FK-OR]");
        biomelist = null;
        busy_worlds = new HashMap();
        gson = new GsonBuilder().create();
    }

    public class WorldUpdateTracker
    implements IWorldEventListener {
        String worldid;
        World world;

        public void func_174959_b(BlockPos pos) {
            if (DynmapPlugin.this.sscache != null) {
                DynmapPlugin.this.sscache.invalidateSnapshot(this.worldid, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            if (DynmapPlugin.this.onlightingchange) {
                DynmapPlugin.this.mapManager.touch(this.worldid, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), "lightingchange");
            }
        }

        public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
        }

        public void func_72703_a(Entity entityIn) {
        }

        public void func_72709_b(Entity entityIn) {
        }

        public void func_180441_b(int breakerId, BlockPos pos, int progress) {
        }

        public void func_180442_a(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xOffset, double yOffset, double zOffset, int ... p_180442_15_) {
        }

        public void func_180440_a(int p_180440_1_, BlockPos p_180440_2_, int p_180440_3_) {
        }

        public void func_184376_a(World worldIn, BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
            if (DynmapPlugin.this.sscache != null) {
                DynmapPlugin.this.sscache.invalidateSnapshot(this.worldid, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            if (DynmapPlugin.this.onblockchange) {
                BlockUpdateRec r = new BlockUpdateRec();
                r.w = this.world;
                r.wid = this.worldid;
                r.x = pos.func_177958_n();
                r.y = pos.func_177956_o();
                r.z = pos.func_177952_p();
                DynmapPlugin.this.blockupdatequeue.add(r);
            }
        }

        public void func_184375_a(EntityPlayer player, SoundEvent soundIn, SoundCategory category, double x, double y, double z, float volume, float pitch) {
        }

        public void func_184377_a(SoundEvent soundIn, BlockPos pos) {
        }

        public void func_180439_a(EntityPlayer arg0, int arg1, BlockPos arg2, int arg3) {
        }

        public void func_190570_a(int arg0, boolean arg1, boolean arg2, double arg3, double arg4, double arg5, double arg6, double arg7, double arg8, int ... arg9) {
        }
    }

    public class WorldTracker {
        @SubscribeEvent
        public void handleWorldLoad(WorldEvent.Load event) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            World w = event.getWorld();
            if (!(w instanceof WorldServer)) {
                return;
            }
            final ForgeWorld fw = DynmapPlugin.this.getWorld(w);
            DynmapPlugin.this.core.getServer().scheduleServerTask(new Runnable(){

                @Override
                public void run() {
                    if (DynmapPlugin.this.core.processWorldLoad(fw)) {
                        ((DynmapPlugin)DynmapPlugin.this).core.listenerManager.processWorldEvent(DynmapListenerManager.EventType.WORLD_LOAD, fw);
                    }
                }
            }, 0L);
        }

        @SubscribeEvent
        public void handleWorldUnload(WorldEvent.Unload event) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            World w = event.getWorld();
            if (!(w instanceof WorldServer)) {
                return;
            }
            final ForgeWorld fw = DynmapPlugin.this.getWorld(w);
            if (fw != null) {
                DynmapPlugin.this.core.getServer().scheduleServerTask(new Runnable(){

                    @Override
                    public void run() {
                        ((DynmapPlugin)DynmapPlugin.this).core.listenerManager.processWorldEvent(DynmapListenerManager.EventType.WORLD_UNLOAD, fw);
                        DynmapPlugin.this.core.processWorldUnload(fw);
                    }
                }, 0L);
                fw.setWorldUnloaded();
                WorldUpdateTracker wut = (WorldUpdateTracker)DynmapPlugin.this.updateTrackers.remove(fw.getName());
                if (wut != null) {
                    wut.world = null;
                }
            }
        }

        @SubscribeEvent
        public void handleChunkLoad(ChunkEvent.Load event) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            if (!DynmapPlugin.this.onchunkgenerate) {
                return;
            }
            World w = event.getWorld();
            if (!(w instanceof WorldServer)) {
                return;
            }
            Chunk c = event.getChunk();
            if (c != null && !c.func_177419_t()) {
                ForgeWorld fw = DynmapPlugin.this.getWorld(w, false);
                if (fw == null) {
                    return;
                }
                int ymax = 0;
                ExtendedBlockStorage[] sections = c.func_76587_i();
                for (int i = 0; i < sections.length; ++i) {
                    if (sections[i] == null || sections[i].func_76663_a()) continue;
                    ymax = 16 * (i + 1);
                }
                int x = c.field_76635_g << 4;
                int z = c.field_76647_h << 4;
                if (ymax > 0) {
                    DynmapPlugin.this.mapManager.touchVolume(fw.getName(), x, 0, z, x + 15, ymax, z + 16, "chunkgenerate");
                }
            }
        }

        @SubscribeEvent
        public void handleChunkPopulate(PopulateChunkEvent.Post event) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            if (!DynmapPlugin.this.onchunkpopulate) {
                return;
            }
            World w = event.getWorld();
            if (!(w instanceof WorldServer)) {
                return;
            }
            Chunk c = w.func_72964_e(event.getChunkX(), event.getChunkZ());
            int ymin = 0;
            int ymax = 0;
            if (c != null) {
                ForgeWorld fw = DynmapPlugin.this.getWorld(event.getWorld(), false);
                if (fw == null) {
                    return;
                }
                ExtendedBlockStorage[] sections = c.func_76587_i();
                for (int i = 0; i < sections.length; ++i) {
                    if (sections[i] == null || sections[i].func_76663_a()) continue;
                    ymax = 16 * (i + 1);
                }
                int x = c.field_76635_g << 4;
                int z = c.field_76647_h << 4;
                if (ymax > 0) {
                    DynmapPlugin.this.mapManager.touchVolume(fw.getName(), x, ymin, z, x + 15, ymax, z + 16, "chunkpopulate");
                }
            }
        }
    }

    public class PlayerTracker {
        @SubscribeEvent
        public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            final ForgePlayer dp = DynmapPlugin.this.getOrAddPlayer(event.player);
            DynmapPlugin.this.core.getServer().scheduleServerTask(new Runnable(){

                @Override
                public void run() {
                    ((DynmapPlugin)DynmapPlugin.this).core.listenerManager.processPlayerEvent(DynmapListenerManager.EventType.PLAYER_JOIN, dp);
                }
            }, 2L);
        }

        @SubscribeEvent
        public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            final ForgePlayer dp = DynmapPlugin.this.getOrAddPlayer(event.player);
            final String name = event.player.func_174793_f().func_70005_c_();
            DynmapPlugin.this.core.getServer().scheduleServerTask(new Runnable(){

                @Override
                public void run() {
                    ((DynmapPlugin)DynmapPlugin.this).core.listenerManager.processPlayerEvent(DynmapListenerManager.EventType.PLAYER_QUIT, dp);
                    DynmapPlugin.this.players.remove(name);
                }
            }, 0L);
        }

        @SubscribeEvent
        public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            DynmapPlugin.this.getOrAddPlayer(event.player);
        }

        @SubscribeEvent
        public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            DynmapPlugin.this.getOrAddPlayer(event.player);
        }
    }

    public class ForgeCommandSender
    implements DynmapCommandSender {
        private ICommandSender sender;

        protected ForgeCommandSender() {
            this.sender = null;
        }

        public ForgeCommandSender(ICommandSender send) {
            this.sender = send;
        }

        @Override
        public boolean hasPrivilege(String privid) {
            return true;
        }

        @Override
        public void sendMessage(String msg) {
            if (this.sender != null) {
                TextComponentString ichatcomponent = new TextComponentString(msg);
                this.sender.func_145747_a((ITextComponent)ichatcomponent);
            }
        }

        @Override
        public boolean isConnected() {
            return false;
        }

        @Override
        public boolean isOp() {
            return true;
        }

        @Override
        public boolean hasPermissionNode(String node) {
            return true;
        }
    }

    public class ForgePlayer
    extends ForgeCommandSender
    implements DynmapPlayer {
        private EntityPlayer player;
        private final String skinurl;
        private final UUID uuid;

        public ForgePlayer(EntityPlayer p) {
            this.player = p;
            String url = null;
            if (this.player != null) {
                Property textureProperty;
                this.uuid = this.player.func_110124_au();
                GameProfile prof = this.player.func_146103_bH();
                if (prof != null && (textureProperty = (Property)Iterables.getFirst((Iterable)prof.getProperties().get((Object)"textures"), null)) != null) {
                    TexturesPayload result = null;
                    try {
                        String json = new String(Base64.decodeBase64((String)textureProperty.getValue()), Charsets.UTF_8);
                        result = (TexturesPayload)gson.fromJson(json, TexturesPayload.class);
                    }
                    catch (JsonParseException jsonParseException) {
                        // empty catch block
                    }
                    if (result != null && result.textures != null && result.textures.containsKey("SKIN")) {
                        url = result.textures.get((Object)"SKIN").url;
                    }
                }
            } else {
                this.uuid = null;
            }
            this.skinurl = url;
        }

        @Override
        public boolean isConnected() {
            return true;
        }

        @Override
        public String getName() {
            if (this.player != null) {
                return this.player.func_174793_f().func_70005_c_();
            }
            return "[Server]";
        }

        @Override
        public String getDisplayName() {
            if (this.player != null) {
                if (DynmapPlugin.this.displayName != null) {
                    try {
                        return (String)DynmapPlugin.this.displayName.get(this.player);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                return this.player.func_145748_c_().func_150260_c();
            }
            return "[Server]";
        }

        @Override
        public boolean isOnline() {
            return true;
        }

        @Override
        public DynmapLocation getLocation() {
            if (this.player == null) {
                return null;
            }
            return DynmapPlugin.this.toLoc(this.player.field_70170_p, this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v);
        }

        @Override
        public String getWorld() {
            if (this.player == null) {
                return null;
            }
            if (this.player.field_70170_p != null) {
                return DynmapPlugin.this.getWorld(this.player.field_70170_p).getName();
            }
            return null;
        }

        @Override
        public InetSocketAddress getAddress() {
            SocketAddress sa;
            NetHandlerPlayServer nsh;
            if (this.player != null && this.player instanceof EntityPlayerMP && (nsh = ((EntityPlayerMP)this.player).field_71135_a) != null && DynmapPlugin.getNetworkManager(nsh) != null && (sa = DynmapPlugin.getNetworkManager(nsh).func_74430_c()) instanceof InetSocketAddress) {
                return (InetSocketAddress)sa;
            }
            return null;
        }

        @Override
        public boolean isSneaking() {
            if (this.player != null) {
                return this.player.func_70093_af();
            }
            return false;
        }

        @Override
        public double getHealth() {
            if (this.player != null) {
                double h = this.player.func_110143_aJ();
                if (h > 20.0) {
                    h = 20.0;
                }
                return h;
            }
            return 0.0;
        }

        @Override
        public int getArmorPoints() {
            if (this.player != null) {
                return this.player.func_70658_aO();
            }
            return 0;
        }

        @Override
        public DynmapLocation getBedSpawnLocation() {
            return null;
        }

        @Override
        public long getLastLoginTime() {
            return 0L;
        }

        @Override
        public long getFirstLoginTime() {
            return 0L;
        }

        @Override
        public boolean hasPrivilege(String privid) {
            if (this.player != null) {
                return DynmapPlugin.this.hasPerm((ICommandSender)this.player, privid);
            }
            return false;
        }

        @Override
        public boolean isOp() {
            return DynmapPlugin.this.isOp(this.player.func_174793_f().func_70005_c_());
        }

        @Override
        public void sendMessage(String msg) {
            TextComponentString ichatcomponent = new TextComponentString(msg);
            this.player.func_145747_a((ITextComponent)ichatcomponent);
        }

        @Override
        public boolean isInvisible() {
            if (this.player != null) {
                return this.player.func_82150_aj();
            }
            return false;
        }

        @Override
        public int getSortWeight() {
            Integer wt = (Integer)DynmapPlugin.this.sortWeights.get(this.getName());
            if (wt != null) {
                return wt;
            }
            return 0;
        }

        @Override
        public void setSortWeight(int wt) {
            if (wt == 0) {
                DynmapPlugin.this.sortWeights.remove(this.getName());
            } else {
                DynmapPlugin.this.sortWeights.put(this.getName(), wt);
            }
        }

        @Override
        public boolean hasPermissionNode(String node) {
            if (this.player != null) {
                return DynmapPlugin.this.hasPermNode((ICommandSender)this.player, node);
            }
            return false;
        }

        @Override
        public String getSkinURL() {
            return this.skinurl;
        }

        @Override
        public UUID getUUID() {
            return this.uuid;
        }
    }

    public class ProfileTexture {
        public String url;
    }

    public class TexturesPayload {
        public long timestamp;
        public String profileId;
        public String profileName;
        public boolean isPublic;
        public Map<String, ProfileTexture> textures;
    }

    public class ForgeServer
    extends DynmapServerInterface {
        private Object schedlock = new Object();
        private long cur_tick;
        private long next_id;
        private long cur_tick_starttime;
        private PriorityQueue<TaskRecord> runqueue = new PriorityQueue();
        private Set<DynmapListenerManager.EventType> registered = new HashSet<DynmapListenerManager.EventType>();

        private GameProfile getProfileByName(String player) {
            PlayerProfileCache cache = DynmapPlugin.this.server.func_152358_ax();
            return cache.func_152655_a(player);
        }

        @Override
        public int getBlockIDAt(String wname, int x, int y, int z) {
            World w;
            DynmapWorld dw = this.getWorldByName(wname);
            if (dw != null && (w = ((ForgeWorld)dw).getWorld()) != null && w.func_175667_e(new BlockPos(x, y, z))) {
                return DynmapPlugin.getBlockID(w, x, y, z);
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void scheduleServerTask(Runnable run, long delay) {
            TaskRecord tr = new TaskRecord();
            tr.future = new FutureTask<Object>(run, null);
            Object object = this.schedlock;
            synchronized (object) {
                tr.id = this.next_id++;
                tr.ticktorun = this.cur_tick + delay;
                this.runqueue.add(tr);
            }
        }

        @Override
        public DynmapPlayer[] getOnlinePlayers() {
            if (DynmapPlugin.this.server.func_184103_al() == null) {
                return new DynmapPlayer[0];
            }
            List playlist = DynmapPlugin.this.server.func_184103_al().func_181057_v();
            int pcnt = playlist.size();
            DynmapPlayer[] dplay = new DynmapPlayer[pcnt];
            for (int i = 0; i < pcnt; ++i) {
                EntityPlayer p = (EntityPlayer)playlist.get(i);
                dplay[i] = DynmapPlugin.this.getOrAddPlayer(p);
            }
            return dplay;
        }

        @Override
        public void reload() {
            plugin.onDisable();
            plugin.onEnable();
            plugin.onStart();
        }

        @Override
        public DynmapPlayer getPlayer(String name) {
            List players = DynmapPlugin.this.server.func_184103_al().func_181057_v();
            for (Object o : players) {
                EntityPlayer p = (EntityPlayer)o;
                if (!p.func_174793_f().func_70005_c_().equalsIgnoreCase(name)) continue;
                return DynmapPlugin.this.getOrAddPlayer(p);
            }
            return null;
        }

        @Override
        public Set<String> getIPBans() {
            UserListIPBans bl = DynmapPlugin.this.server.func_184103_al().func_72363_f();
            HashSet<String> ips = new HashSet<String>();
            for (String s : bl.func_152685_a()) {
                ips.add(s);
            }
            return ips;
        }

        @Override
        public <T> Future<T> callSyncMethod(Callable<T> task) {
            return this.callSyncMethod(task, 0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> Future<T> callSyncMethod(Callable<T> task, long delay) {
            TaskRecord tr = new TaskRecord();
            FutureTask<T> ft = new FutureTask<T>(task);
            tr.future = ft;
            Object object = this.schedlock;
            synchronized (object) {
                tr.id = this.next_id++;
                tr.ticktorun = this.cur_tick + delay;
                this.runqueue.add(tr);
            }
            return ft;
        }

        @Override
        public String getServerName() {
            String sn = DynmapPlugin.this.server.func_71264_H() ? "Integrated" : DynmapPlugin.this.server.func_71211_k();
            if (sn == null) {
                sn = "Unknown Server";
            }
            return sn;
        }

        @Override
        public boolean isPlayerBanned(String pid) {
            UserListBans bl = DynmapPlugin.this.server.func_184103_al().func_152608_h();
            return bl.func_152702_a(this.getProfileByName(pid));
        }

        @Override
        public String stripChatColor(String s) {
            return patternControlCode.matcher(s).replaceAll("");
        }

        @Override
        public boolean requestEventNotification(DynmapListenerManager.EventType type) {
            if (this.registered.contains((Object)type)) {
                return true;
            }
            switch (type) {
                case WORLD_LOAD: 
                case WORLD_UNLOAD: {
                    break;
                }
                case WORLD_SPAWN_CHANGE: {
                    break;
                }
                case PLAYER_JOIN: 
                case PLAYER_QUIT: {
                    break;
                }
                case PLAYER_BED_LEAVE: {
                    break;
                }
                case PLAYER_CHAT: {
                    if (DynmapPlugin.this.chathandler != null) break;
                    DynmapPlugin.this.chathandler = new ChatHandler();
                    MinecraftForge.EVENT_BUS.register((Object)DynmapPlugin.this.chathandler);
                    break;
                }
                case BLOCK_BREAK: {
                    break;
                }
                case SIGN_CHANGE: {
                    break;
                }
                default: {
                    Log.severe("Unhandled event type: " + (Object)((Object)type));
                    return false;
                }
            }
            this.registered.add(type);
            return true;
        }

        @Override
        public boolean sendWebChatEvent(String source, String name, String msg) {
            return DynmapCommonAPIListener.fireWebChatEvent(source, name, msg);
        }

        @Override
        public void broadcastMessage(String msg) {
            TextComponentString component = new TextComponentString(msg);
            DynmapPlugin.this.server.func_184103_al().func_148539_a((ITextComponent)component);
            Log.info(this.stripChatColor(msg));
        }

        @Override
        public String[] getBiomeIDs() {
            BiomeMap[] b = BiomeMap.values();
            String[] bname = new String[b.length];
            for (int i = 0; i < bname.length; ++i) {
                bname[i] = b[i].toString();
            }
            return bname;
        }

        @Override
        public double getCacheHitRate() {
            if (DynmapPlugin.this.sscache != null) {
                return DynmapPlugin.this.sscache.getHitRate();
            }
            return 0.0;
        }

        @Override
        public void resetCacheStats() {
            if (DynmapPlugin.this.sscache != null) {
                DynmapPlugin.this.sscache.resetStats();
            }
        }

        @Override
        public DynmapWorld getWorldByName(String wname) {
            return DynmapPlugin.this.getWorldByName(wname);
        }

        @Override
        public DynmapPlayer getOfflinePlayer(String name) {
            return null;
        }

        @Override
        public Set<String> checkPlayerPermissions(String player, Set<String> perms) {
            net.minecraft.server.management.PlayerList scm = DynmapPlugin.this.server.func_184103_al();
            if (scm == null) {
                return Collections.emptySet();
            }
            UserListBans bl = scm.func_152608_h();
            if (bl == null) {
                return Collections.emptySet();
            }
            if (bl.func_152702_a(this.getProfileByName(player))) {
                return Collections.emptySet();
            }
            HashSet<String> rslt = DynmapPlugin.this.hasOfflinePermissions(player, perms);
            if (rslt == null) {
                rslt = new HashSet<String>();
                if (plugin.isOp(player)) {
                    rslt.addAll(perms);
                }
            }
            return rslt;
        }

        @Override
        public boolean checkPlayerPermission(String player, String perm) {
            net.minecraft.server.management.PlayerList scm = DynmapPlugin.this.server.func_184103_al();
            if (scm == null) {
                return false;
            }
            UserListBans bl = scm.func_152608_h();
            if (bl == null) {
                return false;
            }
            if (bl.func_152702_a(this.getProfileByName(player))) {
                return false;
            }
            return DynmapPlugin.this.hasOfflinePermission(player, perm);
        }

        @Override
        public MapChunkCache createMapChunkCache(DynmapWorld w, List<DynmapChunk> chunks, boolean blockdata, boolean highesty, boolean biome, boolean rawbiome) {
            ForgeMapChunkCache c = (ForgeMapChunkCache)w.getChunkCache(chunks);
            if (c == null) {
                return null;
            }
            if (w.visibility_limits != null) {
                for (VisibilityLimit limit : w.visibility_limits) {
                    c.setVisibleRange(limit);
                }
                c.setHiddenFillStyle(w.hiddenchunkstyle);
            }
            if (w.hidden_limits != null) {
                for (VisibilityLimit limit : w.hidden_limits) {
                    c.setHiddenRange(limit);
                }
                c.setHiddenFillStyle(w.hiddenchunkstyle);
            }
            if (!c.setChunkDataTypes(blockdata, biome, highesty, rawbiome)) {
                Log.severe("CraftBukkit build does not support biome APIs");
            }
            if (chunks.size() == 0) {
                c.loadChunks(0);
                return c;
            }
            final ForgeMapChunkCache cc = c;
            Future<Boolean> f = this.callSyncMethod(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    ForgeWorld fw = (ForgeWorld)cc.getWorld();
                    DynmapPlugin.this.setBusy(fw.getWorld());
                    cc.getLoadedChunks();
                    return true;
                }
            }, 0L);
            try {
                f.get();
            }
            catch (CancellationException cx) {
                return null;
            }
            catch (ExecutionException xx) {
                Log.severe("Exception while loading chunks", xx.getCause());
                return null;
            }
            catch (Exception ix) {
                Log.severe(ix);
                return null;
            }
            if (!w.isLoaded()) {
                return null;
            }
            c.readChunks(chunks.size());
            return c;
        }

        @Override
        public int getMaxPlayers() {
            return DynmapPlugin.this.server.func_71275_y();
        }

        @Override
        public int getCurrentPlayers() {
            return DynmapPlugin.this.server.func_184103_al().func_72394_k();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SubscribeEvent
        public void tickEvent(TickEvent.ServerTickEvent event) {
            long now;
            if (event.phase == TickEvent.Phase.START) {
                return;
            }
            this.cur_tick_starttime = System.nanoTime();
            long elapsed = this.cur_tick_starttime - DynmapPlugin.this.lasttick;
            DynmapPlugin.this.lasttick = this.cur_tick_starttime;
            DynmapPlugin.this.avgticklen = DynmapPlugin.this.avgticklen * 99L / 100L + elapsed / 100L;
            DynmapPlugin.this.tps = 1.0E9 / (double)DynmapPlugin.this.avgticklen;
            if (DynmapPlugin.this.core != null) {
                DynmapPlugin.this.core.serverTick(DynmapPlugin.this.tps);
            }
            boolean done = false;
            TaskRecord tr = null;
            while (!DynmapPlugin.this.blockupdatequeue.isEmpty()) {
                BlockUpdateRec r = (BlockUpdateRec)DynmapPlugin.this.blockupdatequeue.remove();
                int id = 0;
                int meta = 0;
                if (r.w != null && r.w.func_72863_F().func_186026_b(r.x >> 4, r.z >> 4) != null) {
                    id = DynmapPlugin.getBlockID(r.w, r.x, r.y, r.z);
                    IBlockState bs = r.w.func_180495_p(new BlockPos(r.x, r.y, r.z));
                    meta = bs.func_177230_c().func_176201_c(bs);
                }
                if (HDBlockModels.isChangeIgnoredBlock(stateByID[(id << 4) + meta])) continue;
                if (DynmapPlugin.this.onblockchange_with_id) {
                    DynmapPlugin.this.mapManager.touch(r.wid, r.x, r.y, r.z, "blockchange[" + id + ":" + meta + "]");
                    continue;
                }
                DynmapPlugin.this.mapManager.touch(r.wid, r.x, r.y, r.z, "blockchange");
            }
            Object meta = this.schedlock;
            synchronized (meta) {
                ++this.cur_tick;
                now = System.nanoTime();
                tr = this.runqueue.peek();
                if (tr == null || tr.ticktorun > this.cur_tick || now - this.cur_tick_starttime > DynmapPlugin.this.perTickLimit) {
                    done = true;
                } else {
                    tr = this.runqueue.poll();
                }
            }
            while (!done) {
                tr.future.run();
                meta = this.schedlock;
                synchronized (meta) {
                    tr = this.runqueue.peek();
                    now = System.nanoTime();
                    if (tr == null || tr.ticktorun > this.cur_tick || now - this.cur_tick_starttime > DynmapPlugin.this.perTickLimit) {
                        done = true;
                    } else {
                        tr = this.runqueue.poll();
                    }
                }
            }
            while (!DynmapPlugin.this.msgqueue.isEmpty()) {
                ChatMessage cm = (ChatMessage)DynmapPlugin.this.msgqueue.poll();
                ForgePlayer dp = null;
                dp = cm.sender != null ? DynmapPlugin.this.getOrAddPlayer(cm.sender) : new ForgePlayer(null);
                ((DynmapPlugin)DynmapPlugin.this).core.listenerManager.processChatEvent(DynmapListenerManager.EventType.PLAYER_CHAT, dp, cm.message);
            }
            if (this.cur_tick % 20L == 0L) {
                DynmapPlugin.this.doIdleOutOfWorlds();
            }
        }

        @Override
        public boolean isModLoaded(String name) {
            boolean loaded = Loader.isModLoaded((String)name);
            if (loaded) {
                DynmapPlugin.this.modsused.add(name);
            }
            return loaded;
        }

        @Override
        public String getModVersion(String name) {
            Map list = Loader.instance().getIndexedModList();
            ModContainer mod = (ModContainer)list.get(name);
            if (mod == null) {
                for (Map.Entry ent : list.entrySet()) {
                    if (!((String)ent.getKey()).equalsIgnoreCase(name)) continue;
                    mod = (ModContainer)ent.getValue();
                    break;
                }
            }
            if (mod == null) {
                return null;
            }
            return mod.getVersion();
        }

        @Override
        public double getServerTPS() {
            return DynmapPlugin.this.tps;
        }

        @Override
        public String getServerIP() {
            if (DynmapPlugin.this.server.func_71264_H()) {
                return "0.0.0.0";
            }
            return DynmapPlugin.this.server.func_71211_k();
        }

        @Override
        public File getModContainerFile(String name) {
            ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(name);
            if (mod == null) {
                return null;
            }
            return mod.getSource();
        }

        @Override
        public List<String> getModList() {
            return new ArrayList<String>(Loader.instance().getIndexedModList().keySet());
        }

        @Override
        public Map<Integer, String> getBlockIDMap() {
            HashMap<Integer, String> map = new HashMap<Integer, String>();
            for (Block b : Block.field_149771_c) {
                int i = Block.func_149682_b((Block)b);
                ResourceLocation ui = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)b);
                if (ui == null) continue;
                map.put(i, ui.func_110624_b() + ":" + ui.func_110623_a());
            }
            return map;
        }

        @Override
        public InputStream openResource(String modid, String rname) {
            if (modid != null) {
                InputStream is;
                Object mod;
                ModContainer mc = (ModContainer)Loader.instance().getIndexedModList().get(modid);
                Object object = mod = mc != null ? mc.getMod() : null;
                if (mod != null && (is = mod.getClass().getClassLoader().getResourceAsStream(rname)) != null) {
                    return is;
                }
            }
            List mcl = Loader.instance().getModList();
            for (ModContainer mc : mcl) {
                InputStream is;
                Object mod = mc.getMod();
                if (mod == null || (is = mod.getClass().getClassLoader().getResourceAsStream(rname)) == null) continue;
                return is;
            }
            return null;
        }

        @Override
        public Map<String, Integer> getBlockUniqueIDMap() {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (Block b : Block.field_149771_c) {
                int i = Block.func_149682_b((Block)b);
                ResourceLocation ui = null;
                try {
                    ui = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)b);
                }
                catch (Exception x) {
                    Log.warning("Exception caught reading unique ID for block " + i);
                }
                if (ui == null) continue;
                map.put(ui.func_110624_b() + ":" + ui.func_110623_a(), i);
            }
            return map;
        }

        @Override
        public Map<String, Integer> getItemUniqueIDMap() {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (int i = 0; i < 32000; ++i) {
                Item itm = DynmapPlugin.getItemByID(i);
                if (itm == null) continue;
                ResourceLocation ui = null;
                try {
                    ui = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)itm);
                }
                catch (Exception x) {
                    Log.warning("Exception caught reading unique ID for item " + i);
                }
                if (ui == null) continue;
                map.put(ui.func_110624_b() + ":" + ui.func_110623_a(), i - 256);
            }
            return map;
        }
    }

    public static class OurLog
    implements DynmapLogger {
        Logger log = LogManager.getLogger((String)"Dynmap");
        public static final String DM = "[Dynmap] ";

        OurLog() {
        }

        @Override
        public void info(String s) {
            this.log.info(DM + s);
        }

        @Override
        public void severe(Throwable t) {
            this.log.fatal((Object)t);
        }

        @Override
        public void severe(String s) {
            this.log.fatal(DM + s);
        }

        @Override
        public void severe(String s, Throwable t) {
            this.log.fatal(DM + s, t);
        }

        @Override
        public void verboseinfo(String s) {
            this.log.info(DM + s);
        }

        @Override
        public void warning(String s) {
            this.log.warn(DM + s);
        }

        @Override
        public void warning(String s, Throwable t) {
            this.log.warn(DM + s, t);
        }
    }

    private static class WorldBusyRecord {
        long last_ts;
        ForgeChunkManager.Ticket ticket;

        private WorldBusyRecord() {
        }
    }

    public class ChatHandler {
        @SubscribeEvent
        public void handleChat(ServerChatEvent event) {
            String msg = event.getMessage();
            if (!msg.startsWith("/")) {
                ChatMessage cm = new ChatMessage();
                cm.message = msg;
                cm.sender = event.getPlayer();
                DynmapPlugin.this.msgqueue.add(cm);
            }
        }
    }

    private class ChatMessage {
        String message;
        EntityPlayer sender;

        private ChatMessage() {
        }
    }

    private static class TaskRecord
    implements Comparable<Object> {
        private long ticktorun;
        private long id;
        private FutureTask<?> future;

        private TaskRecord() {
        }

        @Override
        public int compareTo(Object o) {
            TaskRecord tr = (TaskRecord)o;
            if (this.ticktorun < tr.ticktorun) {
                return -1;
            }
            if (this.ticktorun > tr.ticktorun) {
                return 1;
            }
            if (this.id < tr.id) {
                return -1;
            }
            if (this.id > tr.id) {
                return 1;
            }
            return 0;
        }
    }

    public static class BlockUpdateRec {
        World w;
        String wid;
        int x;
        int y;
        int z;
    }
}

