/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.Log;
import org.dynmap.MapManager;
import org.dynmap.debug.Debug;
import org.dynmap.hdmap.CustomBlockModel;
import org.dynmap.hdmap.HDBlockModel;
import org.dynmap.hdmap.HDBlockPatchModel;
import org.dynmap.hdmap.HDBlockVolumetricModel;
import org.dynmap.hdmap.HDScaledBlockModels;
import org.dynmap.hdmap.TexturePack;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;
import org.dynmap.utils.ForgeConfigFile;
import org.dynmap.utils.PatchDefinition;
import org.dynmap.utils.PatchDefinitionFactory;

public class HDBlockModels {
    private static int max_patches;
    static HashMap<Integer, HDBlockModel> models_by_id_data;
    static PatchDefinitionFactory pdf;
    static BitSet customModelsRequestingTileData;
    static BitSet changeIgnoredBlocks;
    private static HashSet<String> loadedmods;
    private static HashMap<Integer, HDScaledBlockModels> scaled_models_by_scale;
    public static final int[] boxPatchList;
    private static long[] vscale;

    public static final int getMaxPatchCount() {
        return max_patches;
    }

    public static final PatchDefinitionFactory getPatchDefinitionFactory() {
        return pdf;
    }

    public static boolean resetIfNotBlockSet(DynmapBlockState blk, String blockset) {
        HDBlockModel bm = models_by_id_data.get(blk.globalStateIndex);
        if (bm != null && !bm.getBlockSet().equals(blockset)) {
            Debug.debug("Reset block model for " + blk + " from " + bm.getBlockSet() + " due to new def from " + blockset);
            models_by_id_data.remove(blk.globalStateIndex);
            return true;
        }
        return false;
    }

    public static int getNeededTextureCount(DynmapBlockState blk) {
        HDBlockModel bm = models_by_id_data.get(blk.globalStateIndex);
        if (bm != null) {
            return bm.getTextureCount();
        }
        return 6;
    }

    public static final boolean isChangeIgnoredBlock(DynmapBlockState blk) {
        return changeIgnoredBlocks.get(blk.globalStateIndex);
    }

    public static void handleBlockAlias() {
        Set<String> aliasedblocks = MapManager.mapman.getAliasedBlocks();
        for (String bn : aliasedblocks) {
            String newid = MapManager.mapman.getBlockAlias(bn);
            if (newid.equals(bn)) continue;
            HDBlockModels.remapModel(bn, newid);
        }
    }

    private static void remapModel(String bn, String newbn) {
        DynmapBlockState frombs = DynmapBlockState.getBaseStateByName(bn);
        DynmapBlockState tobs = DynmapBlockState.getBaseStateByName(bn);
        int fcnt = frombs.getStateCount();
        for (int bs = 0; bs < tobs.getStateCount(); ++bs) {
            DynmapBlockState tb = tobs.getState(bs);
            DynmapBlockState fs = tobs.getState(bs % fcnt);
            HDBlockModel m = models_by_id_data.get(fs.globalStateIndex);
            if (m != null) {
                models_by_id_data.put(tb.globalStateIndex, m);
            } else {
                models_by_id_data.remove(tb.globalStateIndex);
            }
            customModelsRequestingTileData.set(tb.globalStateIndex, customModelsRequestingTileData.get(fs.globalStateIndex));
            changeIgnoredBlocks.set(tb.globalStateIndex, changeIgnoredBlocks.get(fs.globalStateIndex));
        }
    }

    public static final String[] getTileEntityFieldsNeeded(DynmapBlockState blk) {
        HDBlockModel mod;
        int idx = blk.globalStateIndex;
        if (customModelsRequestingTileData.get(idx) && (mod = models_by_id_data.get(idx)) instanceof CustomBlockModel) {
            return ((CustomBlockModel)mod).render.getTileEntityFieldsNeeded();
        }
        return null;
    }

    public static HDScaledBlockModels getModelsForScale(int scale) {
        HDScaledBlockModels model = scaled_models_by_scale.get(scale);
        if (model == null) {
            model = new HDScaledBlockModels(scale);
            scaled_models_by_scale.put(scale, model);
        }
        return model;
    }

    private static void addFiles(ArrayList<String> files, File dir, String path) {
        File[] listfiles = dir.listFiles();
        if (listfiles == null) {
            return;
        }
        for (File f : listfiles) {
            String fn = f.getName();
            if (fn.equals(".") || fn.equals("..")) continue;
            if (f.isFile()) {
                if (!fn.endsWith("-models.txt")) continue;
                files.add(path + fn);
                continue;
            }
            if (!f.isDirectory()) continue;
            HDBlockModels.addFiles(files, f, path + f.getName() + "/");
        }
    }

    public static String getModIDFromFileName(String fn) {
        int off = fn.lastIndexOf(47);
        if (off > 0) {
            fn = fn.substring(off + 1);
        }
        if ((off = fn.lastIndexOf(45)) > 0) {
            fn = fn.substring(0, off);
        }
        return fn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadModels(DynmapCore core, ConfigurationNode config) {
        ZipFile zf;
        File datadir = core.getDataFolder();
        max_patches = 6;
        models_by_id_data.clear();
        scaled_models_by_scale.clear();
        changeIgnoredBlocks.clear();
        loadedmods.clear();
        int i = 0;
        boolean done = false;
        InputStream in = null;
        while (!done) {
            in = TexturePack.class.getResourceAsStream("/models_" + i + ".txt");
            if (in != null) {
                HDBlockModels.loadModelFile(in, "models_" + i + ".txt", config, core, "core");
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                in = null;
            } else {
                done = true;
            }
            ++i;
        }
        for (String modid : core.getServer().getModList()) {
            File f = core.getServer().getModContainerFile(modid);
            if (!f.isFile()) continue;
            zf = null;
            in = null;
            try {
                zf = new ZipFile(f);
                String fn = "assets/" + modid.toLowerCase() + "/dynmap-models.txt";
                ZipEntry ze = zf.getEntry(fn);
                if (ze == null) continue;
                in = zf.getInputStream(ze);
                HDBlockModels.loadModelFile(in, fn, config, core, modid);
                loadedmods.add(modid);
            }
            catch (ZipException fn) {
            }
            catch (IOException fn) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException fn) {}
                    in = null;
                }
                if (zf == null) continue;
                try {
                    zf.close();
                }
                catch (IOException fn) {}
                zf = null;
            }
        }
        ArrayList<String> files = new ArrayList<String>();
        File customdir = new File(datadir, "renderdata");
        HDBlockModels.addFiles(files, customdir, "");
        for (String fn : files) {
            File custom = new File(customdir, fn);
            if (!custom.canRead()) continue;
            try {
                in = new FileInputStream(custom);
                HDBlockModels.loadModelFile(in, custom.getPath(), config, core, HDBlockModels.getModIDFromFileName(fn));
            }
            catch (IOException iox) {
                Log.severe("Error loading " + custom.getPath());
            }
            finally {
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (IOException iox) {}
                in = null;
            }
        }
        zf = null;
        try {
            zf = new ZipFile(core.getPluginJarFile());
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                String n = ze.getName();
                if (!n.startsWith("renderdata/") || !n.endsWith("-models.txt") || (in = zf.getInputStream(ze)) == null) continue;
                HDBlockModels.loadModelFile(in, n, config, core, HDBlockModels.getModIDFromFileName(n));
                try {
                    in.close();
                }
                catch (IOException x) {
                    in = null;
                }
            }
            return;
        }
        catch (IOException iox) {
            Log.severe("Error processing nodel files");
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                in = null;
            }
            if (zf != null) {
                try {
                    zf.close();
                }
                catch (IOException iOException) {}
                zf = null;
            }
        }
    }

    private static Integer getIntValue(Map<String, Integer> vars, String val) throws NumberFormatException {
        char c = val.charAt(0);
        if (Character.isLetter(c) || c == '%' || c == '&') {
            Integer v;
            int off = val.indexOf(43);
            int offset = 0;
            if (off > 0) {
                offset = Integer.valueOf(val.substring(off + 1));
                val = val.substring(0, off);
            }
            if ((v = vars.get(val)) == null) {
                if (c == '%' || c == '&') {
                    vars.put(val, 0);
                    v = 0;
                } else {
                    throw new NumberFormatException("invalid ID - " + val);
                }
            }
            if (offset != 0 && v > 0) {
                v = v + offset;
            }
            return v;
        }
        return Integer.valueOf(val);
    }

    private static String getBlockName(String modid, String val) throws NumberFormatException {
        char c = val.charAt(0);
        if (Character.isLetter(c) || c == '%' || c == '&') {
            int off;
            if (c == '%' || c == '&') {
                val = val.substring(1);
            }
            if ((off = val.indexOf(43)) > 0) {
                val = val.substring(0, off);
            }
            if (val.indexOf(58) < 0) {
                val = modid + ":" + val;
            }
            return val;
        }
        throw new NumberFormatException("invalid ID - " + val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadModelFile(InputStream in, String fname, ConfigurationNode config, DynmapCore core, String blockset) {
        BufferedReader rdr = null;
        int cnt = 0;
        boolean need_mod_cfg = false;
        boolean mod_cfg_loaded = false;
        BitSet databits = new BitSet();
        String modname = "minecraft";
        String modversion = null;
        String[] mcver = core.getDynmapPluginPlatformVersion();
        try {
            String line;
            ArrayList<HDBlockVolumetricModel> modlist = new ArrayList<HDBlockVolumetricModel>();
            ArrayList<HDBlockPatchModel> pmodlist = new ArrayList<HDBlockPatchModel>();
            HashMap<String, Integer> varvals = new HashMap<String, Integer>();
            HashMap<String, PatchDefinition> patchdefs = new HashMap<String, PatchDefinition>();
            pdf.setPatchNameMape(patchdefs);
            int layerbits = 0;
            int rownum = 0;
            int scale = 0;
            rdr = new LineNumberReader(new InputStreamReader(in));
            while ((line = ((LineNumberReader)rdr).readLine()) != null) {
                boolean skip = false;
                if (line.length() > 0 && line.charAt(0) == '[') {
                    int end = line.indexOf(93);
                    if (end < 0) {
                        Log.severe("Format error - line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname + ": bad version limit");
                        return;
                    }
                    String vertst = line.substring(1, end);
                    Object tver = mcver;
                    if (vertst.startsWith("mod:")) {
                        tver = modversion;
                        vertst = vertst.substring(4);
                    }
                    if (!HDBlockModels.checkVersionRange((String)tver, vertst)) {
                        skip = true;
                    }
                    line = line.substring(end + 1);
                }
                if (skip) continue;
                if (line.startsWith("block:")) {
                    ArrayList<String> blknames = new ArrayList<String>();
                    databits.clear();
                    scale = 0;
                    line = line.substring(6);
                    String[] args = line.split(",");
                    for (String a : args) {
                        String[] av = a.split("=");
                        if (av.length < 2) continue;
                        if (av[0].equals("id")) {
                            blknames.add(HDBlockModels.getBlockName(modname, av[1]));
                            continue;
                        }
                        if (av[0].equals("data")) {
                            if (av[1].equals("*")) {
                                databits.clear();
                                continue;
                            }
                            if (av[1].indexOf(45) > 0) {
                                String[] sp = av[1].split("-");
                                int m0 = HDBlockModels.getIntValue(varvals, sp[0]);
                                int m1 = HDBlockModels.getIntValue(varvals, sp[1]);
                                for (int m = m0; m <= m1; ++m) {
                                    databits.set(m);
                                }
                                continue;
                            }
                            databits.set(HDBlockModels.getIntValue(varvals, av[1]));
                            continue;
                        }
                        if (!av[0].equals("scale")) continue;
                        scale = Integer.parseInt(av[1]);
                    }
                    if (blknames.size() > 0 && scale > 0) {
                        modlist.clear();
                        for (String bname : blknames) {
                            DynmapBlockState bblk = DynmapBlockState.getBaseStateByName(bname);
                            if (bblk.isNotAir()) {
                                modlist.add(new HDBlockVolumetricModel(bblk, databits, scale, new long[0], blockset));
                                ++cnt;
                                continue;
                            }
                            Log.severe("Invalid model block name " + bname + " at line " + ((LineNumberReader)rdr).getLineNumber());
                        }
                    } else {
                        Log.severe("Block model missing required parameters = line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname);
                    }
                    layerbits = 0;
                    continue;
                }
                if (line.startsWith("layer:")) {
                    line = line.substring(6);
                    String[] args = line.split(",");
                    layerbits = 0;
                    rownum = 0;
                    for (String a : args) {
                        layerbits |= 1 << Integer.parseInt(a);
                    }
                    continue;
                }
                if (line.startsWith("rotate:")) {
                    line = line.substring(7);
                    String[] args = line.split(",");
                    String id = null;
                    int data = -1;
                    int rot = -1;
                    for (String a : args) {
                        String[] av = a.split("=");
                        if (av.length < 2) continue;
                        if (av[0].equals("id")) {
                            id = HDBlockModels.getBlockName(modname, av[1]);
                        }
                        if (av[0].equals("data")) {
                            data = HDBlockModels.getIntValue(varvals, av[1]);
                        }
                        if (!av[0].equals("rot")) continue;
                        rot = Integer.parseInt(av[1]);
                    }
                    DynmapBlockState bs = DynmapBlockState.getStateByNameAndIndex(id, data > 0 ? data : 0);
                    if (bs.isAir()) {
                        Log.severe("Invalid rotate ID: " + id + " on line " + ((LineNumberReader)rdr).getLineNumber());
                        return;
                    }
                    HDBlockModel mod = models_by_id_data.get(bs.globalStateIndex);
                    if (modlist.isEmpty()) continue;
                    if (mod != null && rot % 90 == 0 && mod instanceof HDBlockVolumetricModel) {
                        HDBlockVolumetricModel vmod = (HDBlockVolumetricModel)mod;
                        for (int x = 0; x < scale; ++x) {
                            for (int y = 0; y < scale; ++y) {
                                block76: for (int z = 0; z < scale; ++z) {
                                    if (!vmod.isSubblockSet(x, y, z)) continue;
                                    switch (rot) {
                                        case 0: {
                                            for (HDBlockVolumetricModel bm : modlist) {
                                                bm.setSubblock(x, y, z, true);
                                            }
                                            continue block76;
                                        }
                                        case 90: {
                                            for (HDBlockVolumetricModel bm : modlist) {
                                                bm.setSubblock(scale - z - 1, y, x, true);
                                            }
                                            continue block76;
                                        }
                                        case 180: {
                                            for (HDBlockVolumetricModel bm : modlist) {
                                                bm.setSubblock(scale - x - 1, y, scale - z - 1, true);
                                            }
                                            continue block76;
                                        }
                                        case 270: {
                                            for (HDBlockVolumetricModel bm : modlist) {
                                                bm.setSubblock(z, y, scale - x - 1, true);
                                            }
                                            continue block76;
                                        }
                                    }
                                }
                            }
                        }
                        continue;
                    }
                    Log.severe("Invalid rotate error - line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname);
                    return;
                }
                if (line.startsWith("patchrotate:")) {
                    line = line.substring(12);
                    String[] args = line.split(",");
                    String id = null;
                    int data = -1;
                    int rotx = 0;
                    int roty = 0;
                    int rotz = 0;
                    for (String a : args) {
                        String[] av = a.split("=");
                        if (av.length < 2) continue;
                        if (av[0].equals("id")) {
                            id = HDBlockModels.getBlockName(modname, av[1]);
                        }
                        if (av[0].equals("data")) {
                            data = HDBlockModels.getIntValue(varvals, av[1]);
                        }
                        if (av[0].equals("rot")) {
                            roty = Integer.parseInt(av[1]);
                        }
                        if (av[0].equals("roty")) {
                            roty = Integer.parseInt(av[1]);
                        }
                        if (av[0].equals("rotx")) {
                            rotx = Integer.parseInt(av[1]);
                        }
                        if (!av[0].equals("rotz")) continue;
                        rotz = Integer.parseInt(av[1]);
                    }
                    DynmapBlockState bs = DynmapBlockState.getStateByNameAndIndex(id, data > 0 ? data : 0);
                    if (bs.isAir()) {
                        Log.severe("Invalid patchrotate id: " + id + " on line " + ((LineNumberReader)rdr).getLineNumber());
                        return;
                    }
                    HDBlockModel mod = models_by_id_data.get(bs.globalStateIndex);
                    if (pmodlist.isEmpty()) continue;
                    if (mod != null && mod instanceof HDBlockPatchModel) {
                        HDBlockPatchModel pmod = (HDBlockPatchModel)mod;
                        PatchDefinition[] patches = pmod.getPatches();
                        PatchDefinition[] newpatches = new PatchDefinition[patches.length];
                        for (int i = 0; i < patches.length; ++i) {
                            newpatches[i] = (PatchDefinition)pdf.getRotatedPatch(patches[i], rotx, roty, rotz, patches[i].textureindex);
                        }
                        if (patches.length > max_patches) {
                            max_patches = patches.length;
                        }
                        for (HDBlockPatchModel patchmod : pmodlist) {
                            patchmod.setPatches(newpatches);
                        }
                        continue;
                    }
                    Log.severe("Invalid rotate error - line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname);
                    return;
                }
                if (line.startsWith("ignore-updates:")) {
                    ArrayList<String> blknames = new ArrayList<String>();
                    databits.clear();
                    line = line.substring(line.indexOf(58) + 1);
                    String[] args = line.split(",");
                    for (String a : args) {
                        String[] av = a.split("=");
                        if (av.length < 2) continue;
                        if (av[0].equals("id")) {
                            blknames.add(HDBlockModels.getBlockName(modname, av[1]));
                            continue;
                        }
                        if (!av[0].equals("data")) continue;
                        if (av[1].equals("*")) {
                            databits.clear();
                            continue;
                        }
                        if (av[1].indexOf(45) > 0) {
                            String[] sp = av[1].split("-");
                            int m0 = HDBlockModels.getIntValue(varvals, sp[0]);
                            int m1 = HDBlockModels.getIntValue(varvals, sp[1]);
                            for (int m = m0; m <= m1; ++m) {
                                databits.set(m);
                            }
                            continue;
                        }
                        databits.set(HDBlockModels.getIntValue(varvals, av[1]));
                    }
                    for (String nm : blknames) {
                        DynmapBlockState bbs = DynmapBlockState.getBaseStateByName(nm);
                        if (bbs.isNotAir()) {
                            for (int i = 0; i < bbs.getStateCount(); ++i) {
                                DynmapBlockState bs = bbs.getState(i);
                                if (!databits.isEmpty() && !databits.get(i)) continue;
                                changeIgnoredBlocks.set(bs.globalStateIndex);
                            }
                            continue;
                        }
                        Log.severe("Invalid update ignore block name " + nm + " at line " + ((LineNumberReader)rdr).getLineNumber());
                    }
                    continue;
                }
                if (line.startsWith("#") || line.startsWith(";")) continue;
                if (line.startsWith("enabled:")) {
                    if ((line = line.substring(8).trim()).startsWith("true")) continue;
                    if (line.startsWith("false")) {
                        return;
                    }
                    if (!config.getBoolean(line, false)) {
                        return;
                    }
                    Log.info(line + " models enabled");
                    continue;
                }
                if (line.startsWith("var:")) {
                    line = line.substring(4).trim();
                    String[] args = line.split(",");
                    for (int i = 0; i < args.length; ++i) {
                        String[] v = args[i].split("=");
                        if (v.length < 2) {
                            Log.severe("Format error - line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname);
                            return;
                        }
                        try {
                            int val = Integer.valueOf(v[1]);
                            int parmval = config.getInteger(v[0], val);
                            varvals.put(v[0], parmval);
                            continue;
                        }
                        catch (NumberFormatException nfx) {
                            Log.severe("Format error - line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname);
                            if (rdr != null) {
                                try {
                                    rdr.close();
                                    rdr = null;
                                }
                                catch (IOException parmval) {
                                    // empty catch block
                                }
                            }
                            pdf.setPatchNameMape(null);
                            return;
                        }
                    }
                    continue;
                }
                if (line.startsWith("cfgfile:")) {
                    File cfgfile = new File(line.substring(8).trim());
                    ForgeConfigFile cfg = new ForgeConfigFile(cfgfile);
                    if (!mod_cfg_loaded) {
                        need_mod_cfg = true;
                    }
                    if (!cfg.load()) continue;
                    cfg.addBlockIDs(varvals);
                    need_mod_cfg = false;
                    mod_cfg_loaded = true;
                    continue;
                }
                if (line.startsWith("patch:")) {
                    PatchDefinition pd;
                    String patchid = null;
                    line = line.substring(6);
                    String[] args = line.split(",");
                    double p_x0 = 0.0;
                    double p_y0 = 0.0;
                    double p_z0 = 0.0;
                    double p_xu = 0.0;
                    double p_yu = 1.0;
                    double p_zu = 0.0;
                    double p_xv = 1.0;
                    double p_yv = 0.0;
                    double p_zv = 0.0;
                    double p_umin = 0.0;
                    double p_umax = 1.0;
                    double p_vmin = 0.0;
                    double p_vmax = 1.0;
                    double p_vmaxatumax = -1.0;
                    double p_vminatumax = -1.0;
                    double p_uplusvmax = -1.0;
                    RenderPatchFactory.SideVisible p_sidevis = RenderPatchFactory.SideVisible.BOTH;
                    for (String a : args) {
                        String[] av = a.split("=");
                        if (av.length < 2) continue;
                        if (av[0].equals("id")) {
                            patchid = av[1];
                            continue;
                        }
                        if (av[0].equals("Ox")) {
                            p_x0 = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("Oy")) {
                            p_y0 = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("Oz")) {
                            p_z0 = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("Ux")) {
                            p_xu = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("Uy")) {
                            p_yu = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("Uz")) {
                            p_zu = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("Vx")) {
                            p_xv = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("Vy")) {
                            p_yv = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("Vz")) {
                            p_zv = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("Umin")) {
                            p_umin = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("Umax")) {
                            p_umax = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("Vmin")) {
                            p_vmin = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("Vmax")) {
                            p_vmax = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("UplusVmax")) {
                            Log.warning("UplusVmax deprecated - use VmaxAtUMax - line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname);
                            p_uplusvmax = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("VmaxAtUMax")) {
                            p_vmaxatumax = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("VminAtUMax")) {
                            p_vminatumax = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (!av[0].equals("visibility")) continue;
                        p_sidevis = av[1].equals("top") ? RenderPatchFactory.SideVisible.TOP : (av[1].equals("bottom") ? RenderPatchFactory.SideVisible.BOTTOM : (av[1].equals("flip") ? RenderPatchFactory.SideVisible.FLIP : RenderPatchFactory.SideVisible.BOTH));
                    }
                    if (p_uplusvmax >= 0.0) {
                        p_umax = p_uplusvmax;
                        p_vmax = p_uplusvmax;
                        p_vmaxatumax = 0.0;
                    }
                    if (p_vmaxatumax < 0.0) {
                        p_vmaxatumax = p_vmax;
                    }
                    if (p_vminatumax < 0.0) {
                        p_vminatumax = p_vmin;
                    }
                    if (patchid == null || (pd = pdf.getPatch(p_x0, p_y0, p_z0, p_xu, p_yu, p_zu, p_xv, p_yv, p_zv, p_umin, p_umax, p_vmin, p_vminatumax, p_vmax, p_vmaxatumax, p_sidevis, 0)) == null) continue;
                    patchdefs.put(patchid, pd);
                    continue;
                }
                if (line.startsWith("patchblock:")) {
                    ArrayList<String> blknames = new ArrayList<String>();
                    databits.clear();
                    line = line.substring(11);
                    String[] args = line.split(",");
                    ArrayList<PatchDefinition> patches = new ArrayList<PatchDefinition>();
                    for (String a : args) {
                        int patchnum0;
                        int patchnum1;
                        String[] av = a.split("=");
                        if (av.length < 2) continue;
                        if (av[0].equals("id")) {
                            blknames.add(HDBlockModels.getBlockName(modname, av[1]));
                            continue;
                        }
                        if (av[0].equals("data")) {
                            if (av[1].equals("*")) {
                                databits.clear();
                                continue;
                            }
                            if (av[1].indexOf(45) > 0) {
                                String[] sp = av[1].split("-");
                                int m0 = HDBlockModels.getIntValue(varvals, sp[0]);
                                int m1 = HDBlockModels.getIntValue(varvals, sp[1]);
                                for (int m = m0; m <= m1; ++m) {
                                    databits.set(m);
                                }
                                continue;
                            }
                            databits.set(HDBlockModels.getIntValue(varvals, av[1]));
                            continue;
                        }
                        if (!av[0].startsWith("patch")) continue;
                        String ids = av[0].substring(5);
                        String[] ids2 = ids.split("-");
                        if (ids2.length == 1) {
                            patchnum0 = patchnum1 = Integer.parseInt(ids2[0]);
                        } else {
                            patchnum0 = Integer.parseInt(ids2[0]);
                            patchnum1 = Integer.parseInt(ids2[1]);
                        }
                        if (patchnum0 < 0) {
                            Log.severe("Invalid patch index " + patchnum0 + " - line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname);
                            return;
                        }
                        if (patchnum1 < patchnum0) {
                            Log.severe("Invalid patch index " + patchnum1 + " - line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname);
                            return;
                        }
                        String patchid = av[1];
                        for (int i = patchnum0; i <= patchnum1; ++i) {
                            PatchDefinition pd = pdf.getPatchByName(patchid, i);
                            if (pd == null) {
                                Log.severe("Invalid patch ID " + patchid + " - line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname);
                                return;
                            }
                            patches.add(i, pd);
                        }
                    }
                    pmodlist.clear();
                    if (blknames.size() > 0) {
                        PatchDefinition[] patcharray = patches.toArray(new PatchDefinition[patches.size()]);
                        if (patcharray.length > max_patches) {
                            max_patches = patcharray.length;
                        }
                        for (String nm : blknames) {
                            DynmapBlockState bs = DynmapBlockState.getBaseStateByName(nm);
                            if (bs.isNotAir()) {
                                pmodlist.add(new HDBlockPatchModel(bs, databits, patcharray, blockset));
                                ++cnt;
                                continue;
                            }
                            Log.severe("Invalid patchmodel block name " + nm + " at line " + ((LineNumberReader)rdr).getLineNumber());
                        }
                        continue;
                    }
                    Log.severe("Patch block model missing required parameters = line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname);
                    continue;
                }
                if (line.startsWith("boxblock:")) {
                    ArrayList<String> blknames = new ArrayList<String>();
                    databits.clear();
                    line = line.substring(9);
                    String[] args = line.split(",");
                    double xmin = 0.0;
                    double xmax = 1.0;
                    double ymin = 0.0;
                    double ymax = 1.0;
                    double zmin = 0.0;
                    double zmax = 1.0;
                    for (String a : args) {
                        String[] av = a.split("=");
                        if (av.length < 2) continue;
                        if (av[0].equals("id")) {
                            blknames.add(HDBlockModels.getBlockName(modname, av[1]));
                            continue;
                        }
                        if (av[0].equals("data")) {
                            if (av[1].equals("*")) {
                                databits.clear();
                                continue;
                            }
                            if (av[1].indexOf(45) > 0) {
                                String[] sp = av[1].split("-");
                                int m0 = HDBlockModels.getIntValue(varvals, sp[0]);
                                int m1 = HDBlockModels.getIntValue(varvals, sp[1]);
                                for (int m = m0; m <= m1; ++m) {
                                    databits.set(m);
                                }
                                continue;
                            }
                            databits.set(HDBlockModels.getIntValue(varvals, av[1]));
                            continue;
                        }
                        if (av[0].equals("xmin")) {
                            xmin = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("xmax")) {
                            xmax = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("ymin")) {
                            ymin = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("ymax")) {
                            ymax = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("zmin")) {
                            zmin = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (!av[0].equals("zmax")) continue;
                        zmax = Double.parseDouble(av[1]);
                    }
                    pmodlist.clear();
                    if (blknames.size() > 0) {
                        ArrayList pd = new ArrayList();
                        CustomRenderer.addBox(pdf, pd, xmin, xmax, ymin, ymax, zmin, zmax, boxPatchList);
                        PatchDefinition[] patcharray = new PatchDefinition[pd.size()];
                        for (int i = 0; i < patcharray.length; ++i) {
                            patcharray[i] = (PatchDefinition)pd.get(i);
                        }
                        if (patcharray.length > max_patches) {
                            max_patches = patcharray.length;
                        }
                        for (String nm : blknames) {
                            DynmapBlockState bs = DynmapBlockState.getBaseStateByName(nm);
                            if (bs.isNotAir()) {
                                pmodlist.add(new HDBlockPatchModel(bs, databits, patcharray, blockset));
                                ++cnt;
                                continue;
                            }
                            Log.severe("Invalid boxmodel block name " + nm + " at line " + ((LineNumberReader)rdr).getLineNumber());
                        }
                        continue;
                    }
                    Log.severe("Box block model missing required parameters = line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname);
                    continue;
                }
                if (line.startsWith("boxlist:")) {
                    ArrayList<String> blknames = new ArrayList<String>();
                    databits.clear();
                    line = line.substring(8);
                    String[] args = line.split(",");
                    ArrayList<BoxLimits> boxes = new ArrayList<BoxLimits>();
                    for (String a : args) {
                        String[] av = a.split("=");
                        if (av.length < 2) continue;
                        if (av[0].equals("id")) {
                            blknames.add(HDBlockModels.getBlockName(modname, av[1]));
                            continue;
                        }
                        if (av[0].equals("data")) {
                            if (av[1].equals("*")) {
                                databits.clear();
                                continue;
                            }
                            if (av[1].indexOf(45) > 0) {
                                String[] sp = av[1].split("-");
                                int m0 = HDBlockModels.getIntValue(varvals, sp[0]);
                                int m1 = HDBlockModels.getIntValue(varvals, sp[1]);
                                for (int m = m0; m <= m1; ++m) {
                                    databits.set(m);
                                }
                                continue;
                            }
                            databits.set(HDBlockModels.getIntValue(varvals, av[1]));
                            continue;
                        }
                        if (!av[0].equals("box")) continue;
                        String[] prms = av[1].split(":");
                        BoxLimits box = new BoxLimits();
                        if (prms.length > 0) {
                            box.xmin = Double.parseDouble(prms[0]);
                        }
                        if (prms.length > 1) {
                            box.xmax = Double.parseDouble(prms[1]);
                        }
                        if (prms.length > 2) {
                            box.ymin = Double.parseDouble(prms[2]);
                        }
                        if (prms.length > 3) {
                            box.ymax = Double.parseDouble(prms[3]);
                        }
                        if (prms.length > 4) {
                            box.zmin = Double.parseDouble(prms[4]);
                        }
                        if (prms.length > 5) {
                            box.zmax = Double.parseDouble(prms[5]);
                        }
                        if (prms.length > 6) {
                            String[] pl = prms[6].split("/");
                            for (int p = 0; p < 6 && p < pl.length; ++p) {
                                box.patches[p] = Integer.parseInt(pl[p]);
                            }
                        }
                        boxes.add(box);
                    }
                    pmodlist.clear();
                    if (blknames.size() > 0) {
                        ArrayList<RenderPatch> pd = new ArrayList<RenderPatch>();
                        for (BoxLimits bl : boxes) {
                            CustomRenderer.addBox(pdf, pd, bl.xmin, bl.xmax, bl.ymin, bl.ymax, bl.zmin, bl.zmax, bl.patches);
                        }
                        PatchDefinition[] patcharray = new PatchDefinition[pd.size()];
                        for (int i = 0; i < patcharray.length; ++i) {
                            patcharray[i] = (PatchDefinition)pd.get(i);
                        }
                        if (patcharray.length > max_patches) {
                            max_patches = patcharray.length;
                        }
                        for (String nm : blknames) {
                            DynmapBlockState bs = DynmapBlockState.getBaseStateByName(nm);
                            if (bs.isNotAir()) {
                                pmodlist.add(new HDBlockPatchModel(bs, databits, patcharray, blockset));
                                ++cnt;
                                continue;
                            }
                            Log.severe("Invalid boxlist block name " + nm + " at line " + ((LineNumberReader)rdr).getLineNumber());
                        }
                        continue;
                    }
                    Log.severe("Box list block model missing required parameters = line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname);
                    continue;
                }
                if (line.startsWith("customblock:")) {
                    ArrayList<String> blknames = new ArrayList<String>();
                    HashMap<String, String> custargs = new HashMap<String, String>();
                    databits.clear();
                    line = line.substring(12);
                    String[] args = line.split(",");
                    String cls = null;
                    for (String a : args) {
                        String[] av = a.split("=");
                        if (av.length < 2) continue;
                        if (av[0].equals("id")) {
                            blknames.add(HDBlockModels.getBlockName(modname, av[1]));
                            continue;
                        }
                        if (av[0].equals("data")) {
                            if (av[1].equals("*")) {
                                databits.clear();
                                continue;
                            }
                            if (av[1].indexOf(45) > 0) {
                                String[] sp = av[1].split("-");
                                int m0 = HDBlockModels.getIntValue(varvals, sp[0]);
                                int m1 = HDBlockModels.getIntValue(varvals, sp[1]);
                                for (int m = m0; m <= m1; ++m) {
                                    databits.set(m);
                                }
                                continue;
                            }
                            databits.set(HDBlockModels.getIntValue(varvals, av[1]));
                            continue;
                        }
                        if (av[0].equals("class")) {
                            cls = av[1];
                            continue;
                        }
                        Integer vv = varvals.get(av[1]);
                        if (vv == null) {
                            custargs.put(av[0], av[1]);
                            continue;
                        }
                        custargs.put(av[0], vv.toString());
                    }
                    if (blknames.size() > 0 && cls != null) {
                        for (String nm : blknames) {
                            DynmapBlockState bs = DynmapBlockState.getBaseStateByName(nm);
                            if (bs.isNotAir()) {
                                CustomBlockModel cbm = new CustomBlockModel(bs, databits, cls, custargs, blockset);
                                if (cbm.render == null) {
                                    Log.severe("Custom block model failed to initialize = line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname);
                                } else {
                                    int texturecnt = cbm.getTextureCount();
                                    if (texturecnt > max_patches) {
                                        max_patches = texturecnt;
                                    }
                                }
                                ++cnt;
                                continue;
                            }
                            Log.severe("Invalid custommodel block name " + nm + " at line " + ((LineNumberReader)rdr).getLineNumber());
                        }
                        continue;
                    }
                    Log.severe("Custom block model missing required parameters = line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname);
                    continue;
                }
                if (line.startsWith("modname:")) {
                    String[] names = line.substring(8).split(",");
                    boolean found = false;
                    for (String n : names) {
                        String[] ntok = n.split("[\\[\\]]");
                        String rng = null;
                        if (ntok.length > 1) {
                            n = ntok[0].trim();
                            rng = ntok[1].trim();
                        }
                        if (loadedmods.contains(n = n.trim())) {
                            return;
                        }
                        String modver = core.getServer().getModVersion(n);
                        if (modver == null || rng != null && !HDBlockModels.checkVersionRange(modver, rng)) continue;
                        found = true;
                        Log.info(n + "[" + modver + "] models enabled");
                        modname = n;
                        modversion = modver;
                        loadedmods.add(n);
                        core.addModBlockItemIDs(modname, varvals);
                    }
                }
                if (line.startsWith("version:")) {
                    if (HDBlockModels.checkVersionRange((String)mcver, line = line.substring(line.indexOf(58) + 1))) continue;
                    return;
                }
                if (layerbits == 0) continue;
                for (int i = 0; i < scale && i < line.length(); ++i) {
                    if (line.charAt(i) != '*') continue;
                    for (int y = 0; y < scale; ++y) {
                        if ((layerbits & 1 << y) == 0) continue;
                        for (HDBlockVolumetricModel mod : modlist) {
                            mod.setSubblock(rownum, y, scale - i - 1, true);
                        }
                    }
                }
                if (++rownum < scale) continue;
                rownum = 0;
                layerbits = 0;
            }
            if (need_mod_cfg) {
                Log.severe("Error loading configuration file for " + modname);
            }
            Log.verboseinfo("Loaded " + cnt + " block models from " + fname);
        }
        catch (IOException iox) {
            Log.severe("Error reading models.txt - " + iox.toString());
        }
        catch (NumberFormatException nfx) {
            Log.severe("Format error - line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname + ": " + nfx.getMessage());
        }
        finally {
            if (rdr != null) {
                try {
                    rdr.close();
                    rdr = null;
                }
                catch (IOException iox) {}
            }
            pdf.setPatchNameMape(null);
        }
    }

    private static String normalizeVersion(String v) {
        StringBuilder v2 = new StringBuilder();
        boolean skip = false;
        for (int i = 0; i < v.length(); ++i) {
            char c = v.charAt(i);
            if (c == '.' || c >= '0' && c <= '9') {
                v2.append(c);
                skip = false;
                continue;
            }
            if (skip) continue;
            skip = true;
            v2.append('.');
        }
        return v2.toString();
    }

    private static long parseVersion(String v, boolean up) {
        v = HDBlockModels.normalizeVersion(v);
        String[] vv = v.split("\\.");
        long ver = 0L;
        for (int i = 0; i < vscale.length; ++i) {
            if (i < vv.length) {
                try {
                    ver += vscale[i] * (long)Integer.parseInt(vv[i]);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!up) continue;
            ver += vscale[i] * 99L;
        }
        return ver;
    }

    public static boolean checkVersionRange(String ver, String range) {
        String high;
        String low;
        if (ver.equals(range)) {
            return true;
        }
        String[] rng = range.split("-", -1);
        long v = HDBlockModels.parseVersion(ver, false);
        if (v == 0L) {
            return false;
        }
        if (rng.length == 1) {
            low = rng[0];
            high = rng[0];
        } else {
            low = rng[0];
            high = rng[1];
        }
        if (low.length() > 0 && HDBlockModels.parseVersion(low, false) > v) {
            return false;
        }
        return high.length() <= 0 || HDBlockModels.parseVersion(high, true) >= v;
    }

    static {
        models_by_id_data = new HashMap();
        pdf = new PatchDefinitionFactory();
        customModelsRequestingTileData = new BitSet();
        changeIgnoredBlocks = new BitSet();
        loadedmods = new HashSet();
        scaled_models_by_scale = new HashMap();
        boxPatchList = new int[]{1, 4, 0, 3, 2, 5};
        vscale = new long[]{10000000000L, 100000000L, 1000000L, 10000L, 100L, 1L};
    }

    private static class BoxLimits {
        double xmin = 0.0;
        double xmax = 1.0;
        double ymin = 0.0;
        double ymax = 1.0;
        double zmin = 0.0;
        double zmax = 1.0;
        int[] patches = new int[6];

        private BoxLimits() {
        }
    }
}

