/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap;

import java.util.BitSet;
import java.util.HashMap;
import org.dynmap.hdmap.HDBlockModel;
import org.dynmap.renderer.DynmapBlockState;

public class HDBlockVolumetricModel
extends HDBlockModel {
    private long[] blockflags;
    private int nativeres;
    private HashMap<Integer, short[]> scaledblocks;

    public HDBlockVolumetricModel(DynmapBlockState bs, BitSet databits, int nativeres, long[] blockflags, String blockset) {
        super(bs, databits, blockset);
        this.nativeres = nativeres;
        this.blockflags = new long[nativeres * nativeres];
        System.arraycopy(blockflags, 0, this.blockflags, 0, blockflags.length);
    }

    public final boolean isSubblockSet(int x, int y, int z) {
        return (this.blockflags[this.nativeres * y + z] & (long)(1 << x)) != 0L;
    }

    public final void setSubblock(int x, int y, int z, boolean isset) {
        if (isset) {
            int n = this.nativeres * y + z;
            this.blockflags[n] = this.blockflags[n] | (long)(1 << x);
        } else {
            int n = this.nativeres * y + z;
            this.blockflags[n] = this.blockflags[n] & (long)(~(1 << x));
        }
    }

    public short[] getScaledMap(int res) {
        short[] map;
        if (this.scaledblocks == null) {
            this.scaledblocks = new HashMap();
        }
        if ((map = this.scaledblocks.get(res)) == null) {
            map = new short[res * res * res];
            if (res == this.nativeres) {
                for (int i = 0; i < this.blockflags.length; ++i) {
                    for (int j = 0; j < this.nativeres; ++j) {
                        if ((this.blockflags[i] & (long)(1 << j)) == 0L) continue;
                        map[res * i + j] = 255;
                    }
                }
            } else if (res > this.nativeres) {
                int[] weights = new int[res];
                int[] offsets = new int[res];
                int v = 0;
                int idx = 0;
                while (v < res * this.nativeres) {
                    offsets[idx] = v / res;
                    if ((v + this.nativeres - 1) / res == offsets[idx]) {
                        weights[idx] = this.nativeres;
                    } else {
                        weights[idx] = offsets[idx] + res - v;
                        weights[idx] = offsets[idx] * res + res - v;
                    }
                    v += this.nativeres;
                    ++idx;
                }
                int off = 0;
                for (int y = 0; y < res; ++y) {
                    int ind_y = offsets[y];
                    int wgt_y = weights[y];
                    for (int z = 0; z < res; ++z) {
                        int ind_z = offsets[z];
                        int wgt_z = weights[z];
                        int x = 0;
                        while (x < res) {
                            int ind_x = offsets[x];
                            int wgt_x = weights[x];
                            int raw_w = 0;
                            for (int xx = 0; xx < 2; ++xx) {
                                int wx;
                                int n = wx = xx == 0 ? wgt_x : this.nativeres - wgt_x;
                                if (wx == 0) continue;
                                for (int yy = 0; yy < 2; ++yy) {
                                    int wy;
                                    int n2 = wy = yy == 0 ? wgt_y : this.nativeres - wgt_y;
                                    if (wy == 0) continue;
                                    for (int zz = 0; zz < 2; ++zz) {
                                        int wz;
                                        int n3 = wz = zz == 0 ? wgt_z : this.nativeres - wgt_z;
                                        if (wz == 0 || !this.isSubblockSet(ind_x + xx, ind_y + yy, ind_z + zz)) continue;
                                        raw_w += wx * wy * wz;
                                    }
                                }
                            }
                            map[off] = (short)(255 * raw_w / (this.nativeres * this.nativeres * this.nativeres));
                            if (map[off] > 255) {
                                map[off] = 255;
                            }
                            if (map[off] < 0) {
                                map[off] = 0;
                            }
                            ++x;
                            ++off;
                        }
                    }
                }
            } else {
                int[] weights = new int[this.nativeres];
                int[] offsets = new int[this.nativeres];
                int v = 0;
                int idx = 0;
                while (v < res * this.nativeres) {
                    offsets[idx] = v / this.nativeres;
                    weights[idx] = (v + res - 1) / this.nativeres == offsets[idx] ? res : offsets[idx] * this.nativeres + this.nativeres - v;
                    v += res;
                    ++idx;
                }
                long[] accum = new long[map.length];
                for (int y = 0; y < this.nativeres; ++y) {
                    int ind_y = offsets[y];
                    int wgt_y = weights[y];
                    for (int z = 0; z < this.nativeres; ++z) {
                        int ind_z = offsets[z];
                        int wgt_z = weights[z];
                        for (int x = 0; x < this.nativeres; ++x) {
                            if (!this.isSubblockSet(x, y, z)) continue;
                            int ind_x = offsets[x];
                            int wgt_x = weights[x];
                            for (int xx = 0; xx < 2; ++xx) {
                                int wx;
                                int n = wx = xx == 0 ? wgt_x : res - wgt_x;
                                if (wx == 0) continue;
                                for (int yy = 0; yy < 2; ++yy) {
                                    int wy;
                                    int n4 = wy = yy == 0 ? wgt_y : res - wgt_y;
                                    if (wy == 0) continue;
                                    for (int zz = 0; zz < 2; ++zz) {
                                        int wz;
                                        int n5 = wz = zz == 0 ? wgt_z : res - wgt_z;
                                        if (wz == 0) continue;
                                        int n6 = (ind_y + yy) * res * res + (ind_z + zz) * res + (ind_x + xx);
                                        accum[n6] = accum[n6] + (long)(wx * wy * wz);
                                    }
                                }
                            }
                        }
                    }
                }
                for (int i = 0; i < map.length; ++i) {
                    map[i] = (short)(accum[i] * 255L / (long)this.nativeres / (long)this.nativeres / (long)this.nativeres);
                    if (map[i] > 255) {
                        map[i] = 255;
                    }
                    if (map[i] >= 0) continue;
                    map[i] = 0;
                }
            }
            this.scaledblocks.put(res, map);
        }
        return map;
    }

    @Override
    public int getTextureCount() {
        return 6;
    }
}

