/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap;

import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import org.dynmap.Color;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.JSONUtils;
import org.dynmap.Log;
import org.dynmap.MapManager;
import org.dynmap.common.DynmapCommandSender;
import org.dynmap.exporter.OBJExport;
import org.dynmap.hdmap.HDLighting;
import org.dynmap.hdmap.HDMap;
import org.dynmap.hdmap.HDPerspectiveState;
import org.dynmap.hdmap.HDShader;
import org.dynmap.hdmap.HDShaderState;
import org.dynmap.hdmap.TexturePack;
import org.dynmap.json.simple.JSONObject;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.utils.BlockStep;
import org.dynmap.utils.DynLongHashMap;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.MapIterator;

public class TexturePackHDShader
implements HDShader {
    private final String tpname;
    private final String name;
    private TexturePack tp;
    private boolean did_tp_load = false;
    private final boolean biome_shaded;
    private final boolean bettergrass;
    private final int gridscale;
    private final DynmapCore core;
    private final BitSet hiddenids;

    public TexturePackHDShader(DynmapCore core, ConfigurationNode configuration) {
        this.tpname = configuration.getString("texturepack", "minecraft");
        this.name = configuration.getString("name", this.tpname);
        this.core = core;
        this.biome_shaded = configuration.getBoolean("biomeshaded", true);
        this.bettergrass = configuration.getBoolean("better-grass", MapManager.mapman.getBetterGrass());
        this.gridscale = configuration.getInteger("grid-scale", 0);
        List hidden = configuration.getList("hiddenids");
        if (hidden != null) {
            this.hiddenids = new BitSet();
            for (Object o : hidden) {
                if (!(o instanceof Integer)) continue;
                int v = (Integer)o;
                this.hiddenids.set(v);
            }
        } else {
            this.hiddenids = null;
        }
    }

    private final TexturePack getTexturePack() {
        if (!this.did_tp_load) {
            this.tp = TexturePack.getTexturePack(this.core, this.tpname);
            if (this.tp == null) {
                Log.severe("Error: shader '" + this.name + "' cannot load texture pack '" + this.tpname + "'");
            }
            this.did_tp_load = true;
        }
        return this.tp;
    }

    @Override
    public boolean isBiomeDataNeeded() {
        return this.biome_shaded;
    }

    @Override
    public boolean isRawBiomeDataNeeded() {
        return false;
    }

    @Override
    public boolean isHightestBlockYDataNeeded() {
        return false;
    }

    @Override
    public boolean isBlockTypeDataNeeded() {
        return true;
    }

    @Override
    public boolean isSkyLightLevelNeeded() {
        return false;
    }

    @Override
    public boolean isEmittedLightLevelNeeded() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public HDShaderState getStateInstance(HDMap map, MapChunkCache cache, MapIterator mapiter, int scale) {
        return new ShaderState(mapiter, map, cache, scale);
    }

    @Override
    public void addClientConfiguration(JSONObject mapObject) {
        JSONUtils.s(mapObject, "shader", this.name);
    }

    @Override
    public void exportAsMaterialLibrary(DynmapCommandSender sender, OBJExport out) throws IOException {
        if (this.tp == null) {
            this.getTexturePack();
        }
        if (this.tp != null) {
            this.tp.exportAsOBJMaterialLibrary(out, out.getBaseName());
            return;
        }
        throw new IOException("Export unsupported - invalid texture pack");
    }

    @Override
    public String[] getCurrentBlockMaterials(DynmapBlockState blk, MapIterator mapiter, int[] txtidx, BlockStep[] steps) {
        if (this.tp == null) {
            this.getTexturePack();
        }
        if (this.tp != null) {
            return this.tp.getCurrentBlockMaterials(blk, mapiter, txtidx, steps);
        }
        return new String[txtidx.length];
    }

    class ShaderState
    implements HDShaderState {
        private final Color[] color;
        private final Color[] tmpcolor;
        private final Color c;
        protected final MapIterator mapiter;
        protected final HDMap map;
        private final TexturePack scaledtp;
        private final HDLighting lighting;
        protected DynmapBlockState lastblk;
        protected DynmapBlockState lastblkhit;
        final boolean do_biome_shading;
        final boolean do_better_grass;
        DynLongHashMap ctm_cache;
        final int[] lightingTable;

        protected ShaderState(MapIterator mapiter, HDMap map, MapChunkCache cache, int scale) {
            this.mapiter = mapiter;
            this.map = map;
            this.lighting = map.getLighting();
            if (this.lighting.isNightAndDayEnabled()) {
                this.color = new Color[]{new Color(), new Color()};
                this.tmpcolor = new Color[]{new Color(), new Color()};
            } else {
                this.color = new Color[]{new Color()};
                this.tmpcolor = new Color[]{new Color()};
            }
            this.c = new Color();
            TexturePack tp = TexturePackHDShader.this.getTexturePack();
            this.scaledtp = tp != null ? tp.resampleTexturePack(scale) : null;
            this.do_biome_shading = TexturePackHDShader.this.biome_shaded;
            this.do_better_grass = TexturePackHDShader.this.bettergrass;
            this.lightingTable = (int[])(MapManager.mapman.useBrightnessTable() ? cache.getWorld().getBrightnessTable() : null);
        }

        @Override
        public HDShader getShader() {
            return TexturePackHDShader.this;
        }

        @Override
        public HDMap getMap() {
            return this.map;
        }

        @Override
        public HDLighting getLighting() {
            return this.lighting;
        }

        @Override
        public void reset(HDPerspectiveState ps) {
            for (int i = 0; i < this.color.length; ++i) {
                this.color[i].setTransparent();
            }
            this.setLastBlockState(DynmapBlockState.AIR);
            this.lastblkhit = DynmapBlockState.AIR;
        }

        @Override
        public boolean processBlock(HDPerspectiveState ps) {
            block23: {
                int i;
                int alpha2;
                block25: {
                    block24: {
                        DynmapBlockState blocktype = ps.getBlockState();
                        if (TexturePackHDShader.this.hiddenids != null && TexturePackHDShader.this.hiddenids.get(blocktype.globalStateIndex)) {
                            blocktype = DynmapBlockState.AIR;
                        }
                        if (blocktype.isAir()) {
                            this.lastblkhit = blocktype;
                            return false;
                        }
                        DynmapBlockState lastblocktype = this.lastblk;
                        if (this.scaledtp != null) {
                            this.scaledtp.readColor(ps, this.mapiter, this.c, blocktype, lastblocktype, this);
                        }
                        this.lastblkhit = blocktype;
                        if (this.c.getAlpha() <= 0) break block23;
                        if (this.lightingTable == null) break block24;
                        switch (ps.getLastBlockStep()) {
                            case X_MINUS: 
                            case X_PLUS: {
                                this.c.blendColor(-6710887);
                                break;
                            }
                            case Y_MINUS: {
                                if ((this.mapiter.getY() & 1) == 0) {
                                    this.c.blendColor(-789517);
                                    break;
                                }
                                break block25;
                            }
                            case Y_PLUS: {
                                this.c.blendColor(-8355712);
                                break;
                            }
                            default: {
                                this.c.blendColor(-3289651);
                                break;
                            }
                        }
                        break block25;
                    }
                    switch (ps.getLastBlockStep()) {
                        case X_MINUS: 
                        case X_PLUS: {
                            this.c.blendColor(-6250336);
                            break;
                        }
                        case Y_MINUS: 
                        case Y_PLUS: {
                            if ((this.mapiter.getY() & 1) == 0) {
                                this.c.blendColor(-2500135);
                                break;
                            }
                            this.c.blendColor(-1644826);
                            break;
                        }
                    }
                }
                this.lighting.applyLighting(ps, this, this.c, this.tmpcolor);
                if (TexturePackHDShader.this.gridscale > 0) {
                    int xx = this.mapiter.getX() % TexturePackHDShader.this.gridscale;
                    int zz = this.mapiter.getZ() % TexturePackHDShader.this.gridscale;
                    if (xx == 0 && (zz & 2) == 0 || zz == 0 && (xx & 2) == 0) {
                        for (int i2 = 0; i2 < this.tmpcolor.length; ++i2) {
                            int v = this.tmpcolor[i2].getARGB();
                            this.tmpcolor[i2].setARGB(v & 0xFF000000 | (v & 0xFEFEFE) >> 1 | 0x808080);
                        }
                    }
                }
                if (this.color[0].isTransparent()) {
                    for (int i3 = 0; i3 < this.color.length; ++i3) {
                        this.color[i3].setColor(this.tmpcolor[i3]);
                    }
                    return this.color[0].getAlpha() == 255;
                }
                int alpha = this.color[0].getAlpha();
                int talpha = alpha + (alpha2 = this.tmpcolor[0].getAlpha() * (255 - alpha) / 255);
                if (talpha > 0) {
                    for (i = 0; i < this.color.length; ++i) {
                        this.color[i].setRGBA((this.tmpcolor[i].getRed() * alpha2 + this.color[i].getRed() * alpha) / talpha, (this.tmpcolor[i].getGreen() * alpha2 + this.color[i].getGreen() * alpha) / talpha, (this.tmpcolor[i].getBlue() * alpha2 + this.color[i].getBlue() * alpha) / talpha, talpha);
                    }
                } else {
                    for (i = 0; i < this.color.length; ++i) {
                        this.color[i].setTransparent();
                    }
                }
                return talpha >= 254;
            }
            return false;
        }

        @Override
        public void rayFinished(HDPerspectiveState ps) {
        }

        @Override
        public void getRayColor(Color c, int index) {
            c.setColor(this.color[index]);
        }

        @Override
        public void cleanup() {
            if (this.ctm_cache != null) {
                this.ctm_cache.clear();
                this.ctm_cache = null;
            }
        }

        @Override
        public DynLongHashMap getCTMTextureCache() {
            if (this.ctm_cache == null) {
                this.ctm_cache = new DynLongHashMap();
            }
            return this.ctm_cache;
        }

        @Override
        public int[] getLightingTable() {
            return this.lightingTable;
        }

        @Override
        public void setLastBlockState(DynmapBlockState new_lastbs) {
            this.lastblk = new_lastbs;
        }

        public DynmapBlockState getLastBlockHit() {
            return this.lastblkhit;
        }
    }
}

