/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class FenceGateBlockStateRenderer
extends CustomRenderer {
    private static final int TEXTURE_SIDES = 0;
    private static final int TEXTURE_TOP = 1;
    private static final int TEXTURE_BOTTOM = 2;
    private static final int IDX_OPEN = 0;
    private static final int IDX_CLOSED = 1;
    private static final int IDX_INWALL = 0;
    private static final int IDX_NOTINWALL = 2;
    private static final int IDX_NORTH = 0;
    private static final int IDX_SOUTH = 4;
    private static final int IDX_WEST = 8;
    private static final int IDX_EAST = 12;
    protected RenderPatch[][] meshes = new RenderPatch[16][];
    private static final int[] patchlist = new int[]{2, 1, 0, 0, 0, 0};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, String blkname, BitSet blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkname, blockdatamask, custparm)) {
            return false;
        }
        this.buildMeshes(rpf);
        return true;
    }

    @Override
    public int getMaximumTextureCount() {
        return 3;
    }

    private void addBox(RenderPatchFactory rpf, List<RenderPatch> list, double xmin, double xmax, double ymin, double ymax, double zmin, double zmax) {
        FenceGateBlockStateRenderer.addBox(rpf, list, xmin, xmax, ymin, ymax, zmin, zmax, patchlist);
    }

    private void rotateModel(RenderPatchFactory rpf, int srcidx, int destidx, int rot) {
        this.meshes[destidx] = new RenderPatch[this.meshes[srcidx].length];
        for (int i = 0; i < this.meshes[destidx].length; ++i) {
            this.meshes[destidx][i] = rpf.getRotatedPatch(this.meshes[srcidx][i], 0, rot, 0, patchlist[i % 6]);
        }
    }

    private void buildMeshes(RenderPatchFactory rpf) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        this.addBox(rpf, list, 0.0, 0.125, 0.3125, 1.0, 0.4375, 0.5625);
        this.addBox(rpf, list, 0.875, 1.0, 0.3125, 1.0, 0.4375, 0.5625);
        this.addBox(rpf, list, 0.375, 0.5, 0.375, 0.9375, 0.4375, 0.5625);
        this.addBox(rpf, list, 0.5, 0.625, 0.375, 0.9375, 0.4375, 0.5625);
        this.addBox(rpf, list, 0.125, 0.375, 0.375, 0.5625, 0.4375, 0.5625);
        this.addBox(rpf, list, 0.125, 0.375, 0.75, 0.9375, 0.4375, 0.5625);
        this.addBox(rpf, list, 0.625, 0.875, 0.375, 0.5625, 0.4375, 0.5625);
        this.addBox(rpf, list, 0.625, 0.875, 0.75, 0.9375, 0.4375, 0.5625);
        this.meshes[7] = list.toArray(new RenderPatch[list.size()]);
        list.clear();
        this.rotateModel(rpf, 7, 3, 180);
        this.rotateModel(rpf, 7, 11, 90);
        this.rotateModel(rpf, 7, 15, 270);
        this.addBox(rpf, list, 0.0, 0.125, 0.3125, 1.0, 0.4375, 0.5625);
        this.addBox(rpf, list, 0.875, 1.0, 0.3125, 1.0, 0.4375, 0.5625);
        this.addBox(rpf, list, 0.0, 0.125, 0.375, 0.9375, 0.8125, 0.9375);
        this.addBox(rpf, list, 0.875, 1.0, 0.375, 0.9375, 0.8125, 0.9375);
        this.addBox(rpf, list, 0.0, 0.125, 0.375, 0.5625, 0.5625, 0.8125);
        this.addBox(rpf, list, 0.0, 0.125, 0.75, 0.9375, 0.5625, 0.8125);
        this.addBox(rpf, list, 0.875, 1.0, 0.375, 0.5625, 0.5625, 0.8125);
        this.addBox(rpf, list, 0.875, 1.0, 0.75, 0.9375, 0.5625, 0.8125);
        this.meshes[6] = list.toArray(new RenderPatch[list.size()]);
        list.clear();
        this.rotateModel(rpf, 6, 2, 180);
        this.rotateModel(rpf, 6, 10, 90);
        this.rotateModel(rpf, 6, 14, 270);
        this.addBox(rpf, list, 0.0, 0.125, 0.125, 0.8125, 0.4375, 0.5625);
        this.addBox(rpf, list, 0.875, 1.0, 0.125, 0.8125, 0.4375, 0.5625);
        this.addBox(rpf, list, 0.375, 0.5, 0.1875, 0.75, 0.4375, 0.5625);
        this.addBox(rpf, list, 0.5, 0.625, 0.1875, 0.75, 0.4375, 0.5625);
        this.addBox(rpf, list, 0.125, 0.375, 0.1875, 0.375, 0.4375, 0.5625);
        this.addBox(rpf, list, 0.125, 0.375, 0.5625, 0.75, 0.4375, 0.5625);
        this.addBox(rpf, list, 0.625, 0.875, 0.1875, 0.375, 0.4375, 0.5625);
        this.addBox(rpf, list, 0.625, 0.875, 0.5625, 0.75, 0.4375, 0.5625);
        this.meshes[5] = list.toArray(new RenderPatch[list.size()]);
        list.clear();
        this.rotateModel(rpf, 5, 1, 180);
        this.rotateModel(rpf, 5, 9, 90);
        this.rotateModel(rpf, 5, 13, 270);
        this.addBox(rpf, list, 0.0, 0.125, 0.125, 0.8125, 0.4375, 0.5625);
        this.addBox(rpf, list, 0.875, 1.0, 0.125, 0.8125, 0.4375, 0.5625);
        this.addBox(rpf, list, 0.0, 0.125, 0.1875, 0.75, 0.8125, 0.9375);
        this.addBox(rpf, list, 0.875, 1.0, 0.1875, 0.75, 0.8125, 0.9375);
        this.addBox(rpf, list, 0.0, 0.125, 0.1875, 0.375, 0.5625, 0.8125);
        this.addBox(rpf, list, 0.0, 0.125, 0.5625, 0.75, 0.5625, 0.8125);
        this.addBox(rpf, list, 0.875, 1.0, 0.1875, 0.375, 0.5625, 0.8125);
        this.addBox(rpf, list, 0.875, 1.0, 0.5625, 0.75, 0.5625, 0.8125);
        this.meshes[4] = list.toArray(new RenderPatch[list.size()]);
        this.rotateModel(rpf, 4, 0, 180);
        this.rotateModel(rpf, 4, 8, 90);
        this.rotateModel(rpf, 4, 12, 270);
        list.clear();
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext ctx) {
        int meta = ctx.getBlockType().stateIndex;
        return this.meshes[meta >> 1 & 0xF];
    }
}

