/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.markers.impl;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.dynmap.ConfigurationNode;
import org.dynmap.markers.MarkerIcon;
import org.dynmap.markers.impl.MarkerAPIImpl;

class MarkerIconImpl
implements MarkerIcon {
    private String iconid;
    private String label;
    private boolean is_builtin;
    private MarkerIcon.MarkerSize size = MarkerIcon.MarkerSize.MARKER_16x16;

    MarkerIconImpl(String id) {
        this.iconid = id;
        this.label = id;
        this.is_builtin = false;
    }

    MarkerIconImpl(String id, String lbl, boolean is_builtin) {
        this.iconid = id;
        this.label = lbl != null ? lbl : id;
        this.is_builtin = is_builtin;
    }

    void cleanup() {
    }

    @Override
    public String getMarkerIconID() {
        return this.iconid;
    }

    @Override
    public String getMarkerIconLabel() {
        return this.label;
    }

    @Override
    public void setMarkerIconLabel(String lbl) {
        if (lbl == null) {
            lbl = this.iconid;
        }
        if (!this.label.equals(lbl)) {
            this.label = lbl;
            MarkerAPIImpl.saveMarkers();
        }
    }

    @Override
    public void setMarkerIconImage(InputStream in) {
        if (MarkerAPIImpl.api.loadMarkerIconStream(this.iconid, in)) {
            MarkerAPIImpl.api.publishMarkerIcon(this);
        }
    }

    @Override
    public void deleteIcon() {
        MarkerAPIImpl.removeIcon(this);
    }

    @Override
    public boolean isBuiltIn() {
        return this.is_builtin;
    }

    Map<String, Object> getPersistentData() {
        if (this.is_builtin) {
            return null;
        }
        HashMap<String, Object> node = new HashMap<String, Object>();
        node.put("label", this.label);
        return node;
    }

    boolean loadPersistentData(ConfigurationNode node) {
        if (this.is_builtin) {
            return false;
        }
        this.label = node.getString("label", this.iconid);
        return true;
    }

    @Override
    public MarkerIcon.MarkerSize getMarkerIconSize() {
        return this.size;
    }

    void setMarkerIconSize(MarkerIcon.MarkerSize sz) {
        this.size = sz;
    }
}

