/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.ui.element.view;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.shadowfacts.shadowmc.ui.UIDimensions;
import net.shadowfacts.shadowmc.ui.UIElement;
import net.shadowfacts.shadowmc.ui.element.view.UIView;
import net.shadowfacts.shadowmc.ui.style.UIAttribute;
import net.shadowfacts.shadowmc.ui.util.UIHelper;
import net.shadowfacts.shadowmc.util.MouseButton;
import org.lwjgl.opengl.GL11;

public class UIListView
extends UIView {
    private int preferredWidth;
    private int preferredHeight;
    private int scroll;
    private int totalHeight;

    public UIListView(int preferredWidth, int preferredHeight, String id, String ... classes) {
        super("list", id, classes);
        this.preferredWidth = preferredWidth;
        this.preferredHeight = preferredHeight;
    }

    private void setScroll(int scroll) {
        if (scroll > 0) {
            scroll = 0;
        } else if ((scroll + 1) * 10 < -(this.totalHeight - this.preferredHeight)) {
            scroll = -(this.totalHeight - this.preferredHeight) / 10 - 1;
        }
        int originalScroll = this.scroll;
        this.scroll = scroll;
        for (UIElement e : this.children) {
            e.setY(e.getY() - originalScroll * 10 + scroll * 10);
        }
    }

    @Override
    public void mouseScroll(int mouseX, int mouseY, int delta) {
        if (UIHelper.isWithinBounds(mouseX, mouseY, this)) {
            this.setScroll(this.scroll + Integer.signum(delta));
        }
    }

    @Override
    public void mouseMove(int mouseX, int mouseY, MouseButton button, long timeSinceLastClick) {
        int barWidth = this.getStyle(UIAttribute.SCROLLBAR_WIDTH);
        if (UIHelper.isWithinBounds(mouseX, mouseY, this.x + this.dimensions.width - barWidth, this.y, this.x + this.dimensions.width, this.y + this.dimensions.height)) {
            int dist = mouseY - this.y;
            int maxScroll = -(this.totalHeight - this.preferredHeight) / 10 - 1;
            this.setScroll((int)((float)maxScroll * ((float)dist / (float)this.preferredHeight)));
        } else {
            super.mouseMove(mouseX, mouseY, button, timeSinceLastClick);
        }
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        int barWidth = this.getStyle(UIAttribute.SCROLLBAR_WIDTH);
        UIHelper.drawRect(this.x + this.dimensions.width - barWidth - 1, this.y - 1, barWidth + 2, this.dimensions.height + 2, this.getStyle(UIAttribute.SCROLLBAR_BACKGROUND_COLOR));
        int scrollbarTop = (int)((float)(this.scroll * 10) / (float)this.totalHeight * (float)this.preferredHeight);
        int scrollbarHeight = (int)((float)this.preferredHeight / (float)this.totalHeight * (float)this.preferredHeight);
        Color secondary = this.getStyle(UIAttribute.SCROLLBAR_SCEONDARY_COLOR);
        Color primary = this.getStyle(UIAttribute.SCROLLBAR_PRIMARY_COLOR);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(this.y - scrollbarTop * 2), (float)0.0f);
        UIHelper.drawRect(this.x + this.dimensions.width - barWidth, scrollbarTop, barWidth, scrollbarHeight, secondary);
        UIHelper.drawRect(this.x + this.dimensions.width - barWidth, scrollbarTop, barWidth - 1, scrollbarHeight - 1, primary);
        GL11.glPopMatrix();
        ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
        int width = this.dimensions.width * res.func_78325_e();
        int height = this.dimensions.height * res.func_78325_e();
        int x = this.x * res.func_78325_e();
        int y = this.mc.field_71440_d - this.y * res.func_78325_e() - height;
        GL11.glPushMatrix();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)x, (int)y, (int)width, (int)height);
        super.draw(mouseX, mouseY);
        GL11.glDisable((int)3089);
        GL11.glPopMatrix();
    }

    @Override
    public void layout(int minX, int maxX, int minY, int maxY) {
        super.layout(minX, maxX, minY, maxY);
        int currentY = 0;
        for (UIElement e : this.children) {
            int marginLeft = e.getStyle(UIAttribute.MARGIN_LEFT);
            int marginRight = e.getStyle(UIAttribute.MARGIN_RIGHT);
            UIDimensions elementDimensions = e.getPreferredDimensions();
            e.layout(marginLeft, elementDimensions.width - marginRight - 40 - this.getStyle(UIAttribute.SCROLLBAR_WIDTH) - 2, currentY, currentY + elementDimensions.height);
            e.setX(this.x + e.getX());
            e.setY(this.y + currentY);
            currentY += elementDimensions.height;
        }
        this.totalHeight = this.children.stream().map(UIElement::getDimensions).mapToInt(dimensions -> dimensions.height).sum();
    }

    @Override
    public UIDimensions getMinDimensions() {
        return this.getPreferredDimensions();
    }

    @Override
    public UIDimensions getPreferredDimensions() {
        return new UIDimensions(this.preferredWidth, this.preferredHeight);
    }

    @Override
    public UIDimensions getMaxDimensions() {
        return this.getPreferredDimensions();
    }
}

