/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.coremod.asm;

import aroma1997.core.coremod.MCPNames;
import aroma1997.core.coremod.asm.AsmUtils;
import aroma1997.core.coremod.asm.BasicTransformer;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public abstract class CallHookInsertionTransformer
extends BasicTransformer {
    private final String hookClass;
    private final boolean ret;
    protected Map<String, String> methods = new HashMap<String, String>();

    protected CallHookInsertionTransformer(String hookClass) {
        this(hookClass, false);
    }

    protected CallHookInsertionTransformer(String hookClass, boolean ret) {
        this.hookClass = hookClass.replace('.', '/');
        this.ret = ret;
    }

    protected void addMethodHook(String srgname, String targetName) {
        this.methods.put(MCPNames.method(srgname), targetName);
    }

    @Override
    public void transform(ClassNode classNode) {
        for (MethodNode mn : classNode.methods) {
            if (!this.methods.containsKey(mn.name)) continue;
            String hookMethod = this.methods.get(mn.name);
            logger.info("Transforming " + classNode.name + "/" + mn.name + mn.desc);
            InsnList toInsert = new InsnList();
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
            int num = 1;
            String params = AsmUtils.extractParameters(mn.desc);
            String returnType = AsmUtils.extractReturnType(mn.desc);
            for (String parameter : () -> AsmUtils.splitParams(params)) {
                toInsert.add((AbstractInsnNode)new VarInsnNode(AsmUtils.getLoadCodeForType(parameter), num++));
            }
            String hookDescriptor = this.buildCallHookDescriptor(classNode.name, params, returnType);
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, this.hookClass, hookMethod, hookDescriptor, false));
            if (this.ret) {
                toInsert.add((AbstractInsnNode)new InsnNode(AsmUtils.getReturnCodeForType(returnType)));
            }
            mn.instructions.insert(mn.instructions.get(1), toInsert);
            logger.info("Now using " + this.hookClass + "/" + hookMethod + hookDescriptor);
        }
    }

    private String buildCallHookDescriptor(String className, String params, String returnType) {
        String prefix = "(L" + className + ";" + params + ")";
        prefix = this.ret ? prefix + returnType : prefix + AsmUtils.getDescriptorForClass(Void.TYPE);
        return prefix;
    }
}

