/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.block;

import epicsquid.mysticallib.LibRegistry;
import epicsquid.mysticallib.block.CustomStateMapper;
import epicsquid.mysticallib.block.IBlock;
import epicsquid.mysticallib.model.CustomModelBlock;
import epicsquid.mysticallib.model.CustomModelLoader;
import epicsquid.mysticallib.model.ICustomModeledObject;
import epicsquid.mysticallib.model.IModeledObject;
import epicsquid.mysticallib.model.block.BakedModelBlock;
import epicsquid.mysticallib.model.block.BakedModelPressurePlate;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPressurePlateBase
extends BlockPressurePlate
implements IBlock,
IModeledObject,
ICustomModeledObject {
    @Nonnull
    private Item itemBlock;
    public List<ItemStack> drops = null;
    private boolean isOpaque = false;
    private boolean hasCustomModel = false;
    private boolean isFlammable = false;
    private BlockRenderLayer layer = BlockRenderLayer.CUTOUT;
    private Block parent;
    public String name = "";
    private final PressurePlateType plateType;

    public BlockPressurePlateBase(@Nonnull Block base, @Nonnull PressurePlateType plateType, @Nonnull SoundType type, float hardness, @Nonnull String name) {
        super(base.func_176223_P().func_185904_a(), BlockPressurePlate.Sensitivity.EVERYTHING);
        this.parent = base;
        this.name = name;
        this.func_149647_a(null);
        this.func_149663_c(name);
        this.setRegistryName(LibRegistry.getActiveModid(), name);
        this.func_149672_a(type);
        this.func_149713_g(0);
        this.func_149711_c(hardness);
        this.setOpacity(false);
        this.field_149787_q = false;
        this.itemBlock = (Item)new ItemBlock((Block)this).func_77655_b(name).setRegistryName(LibRegistry.getActiveModid(), name);
        this.plateType = plateType;
    }

    @Nonnull
    public BlockPressurePlateBase setFlammable(boolean flammable) {
        this.isFlammable = flammable;
        return this;
    }

    @Nonnull
    public BlockPressurePlateBase setResistance(float resistance) {
        super.func_149752_b(resistance);
        return this;
    }

    @Nonnull
    public BlockPressurePlateBase setModelCustom(boolean custom) {
        this.hasCustomModel = custom;
        return this;
    }

    @Nonnull
    public BlockPressurePlateBase setHarvestReqs(String tool, int level) {
        this.setHarvestLevel(tool, level);
        return this;
    }

    @Nonnull
    public BlockPressurePlateBase setOpacity(boolean isOpaque) {
        this.isOpaque = isOpaque;
        return this;
    }

    @Nonnull
    public BlockPressurePlateBase setLayer(@Nonnull BlockRenderLayer layer) {
        this.layer = layer;
        return this;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return this.isOpaque;
    }

    public boolean hasCustomModel() {
        return this.hasCustomModel;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public boolean canPlaceTorchOnTop(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return true;
    }

    public boolean isFlammable(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return this.isFlammable || super.isFlammable(world, pos, face);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.isFlammable ? 100 : super.getFlammability(world, pos, face);
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return this.layer;
    }

    @Override
    @Nonnull
    public Item getItemBlock() {
        return this.itemBlock;
    }

    @Override
    public ItemBlock setItemBlock(ItemBlock block) {
        this.itemBlock = block;
        return block;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.itemBlock);
    }

    @Nonnull
    public Block getParent() {
        return this.parent;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        if (this.hasCustomModel) {
            ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new CustomStateMapper());
        }
        if (!this.hasCustomModel) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "handlers"));
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "handlers"));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initCustomModel() {
        if (this.hasCustomModel) {
            ResourceLocation defaultTex = new ResourceLocation(this.parent.getRegistryName().func_110624_b() + ":blocks/" + this.parent.getRegistryName().func_110623_a());
            CustomModelLoader.blockmodels.put(new ResourceLocation(this.getRegistryName().func_110624_b() + ":models/block/" + this.name), new CustomModelBlock(this.getModelClass(), defaultTex, defaultTex));
            CustomModelLoader.itemmodels.put(new ResourceLocation(this.getRegistryName().func_110624_b() + ":" + this.name + "#handlers"), new CustomModelBlock(this.getModelClass(), defaultTex, defaultTex));
        }
    }

    protected int func_180669_e(@Nonnull World worldIn, @Nonnull BlockPos pos) {
        List list;
        AxisAlignedBB axisalignedbb = field_185511_c.func_186670_a(pos);
        switch (this.plateType) {
            case ALL: {
                list = worldIn.func_72839_b((Entity)null, axisalignedbb);
                break;
            }
            case MOBS: {
                list = worldIn.func_72872_a(EntityLivingBase.class, axisalignedbb);
                break;
            }
            case ITEMS: {
                list = worldIn.func_72872_a(EntityItem.class, axisalignedbb);
                break;
            }
            case PLAYER: {
                list = worldIn.func_72872_a(EntityPlayer.class, axisalignedbb);
                break;
            }
            default: {
                return 0;
            }
        }
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.func_145773_az()) continue;
                return 15;
            }
        }
        return 0;
    }

    @Nonnull
    protected Class<? extends BakedModelBlock> getModelClass() {
        return BakedModelPressurePlate.class;
    }

    public static enum PressurePlateType {
        ALL,
        ITEMS,
        MOBS,
        PLAYER;

    }
}

