/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node.cover;

import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.ICoverable;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeCable;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.cover.Cover;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.cover.CoverType;
import com.raoulvdberge.refinedstorage.item.ItemCover;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class CoverManager {
    private static final String NBT_DIRECTION = "Direction";
    private static final String NBT_ITEM = "Item";
    private static final String NBT_TYPE = "Type";
    private Map<EnumFacing, Cover> covers = new HashMap<EnumFacing, Cover>();
    private NetworkNode node;

    public CoverManager(NetworkNode node) {
        this.node = node;
    }

    public boolean canConduct(EnumFacing direction) {
        Cover cover = this.getCover(direction);
        if (cover != null && cover.getType() != CoverType.HOLLOW) {
            return false;
        }
        INetworkNode neighbor = API.instance().getNetworkNodeManager(this.node.getWorld()).getNode(this.node.getPos().func_177972_a(direction));
        return !(neighbor instanceof ICoverable) || (cover = ((ICoverable)((Object)neighbor)).getCoverManager().getCover(direction.func_176734_d())) == null || cover.getType() == CoverType.HOLLOW;
    }

    @Nullable
    public Cover getCover(EnumFacing facing) {
        return this.covers.get(facing);
    }

    public boolean hasCover(EnumFacing facing) {
        return this.covers.containsKey(facing);
    }

    public boolean setCover(EnumFacing facing, @Nullable Cover cover) {
        if (cover == null || CoverManager.isValidCover(cover.getStack()) && !this.hasCover(facing)) {
            if (cover != null && facing == this.node.getDirection() && !(this.node instanceof NetworkNodeCable) && cover.getType() != CoverType.HOLLOW) {
                return false;
            }
            if (cover == null) {
                this.covers.remove(facing);
            } else {
                this.covers.put(facing, cover);
            }
            this.node.markDirty();
            if (this.node.getNetwork() != null) {
                this.node.getNetwork().getNodeGraph().invalidate(Action.PERFORM, this.node.getNetwork().world(), this.node.getNetwork().getPosition());
            }
            return true;
        }
        return false;
    }

    public void readFromNbt(NBTTagList list) {
        this.covers.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            int type;
            NBTTagCompound tag = list.func_150305_b(i);
            if (!tag.func_74764_b(NBT_DIRECTION) || !tag.func_74764_b(NBT_ITEM)) continue;
            EnumFacing direction = EnumFacing.func_82600_a((int)tag.func_74762_e(NBT_DIRECTION));
            ItemStack item = new ItemStack(tag.func_74775_l(NBT_ITEM));
            int n = type = tag.func_74764_b(NBT_TYPE) ? tag.func_74762_e(NBT_TYPE) : 0;
            if (type >= CoverType.values().length) {
                type = 0;
            }
            if (!CoverManager.isValidCover(item)) continue;
            this.covers.put(direction, new Cover(item, CoverType.values()[type]));
        }
    }

    public NBTTagList writeToNbt() {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<EnumFacing, Cover> entry : this.covers.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a(NBT_DIRECTION, entry.getKey().ordinal());
            tag.func_74782_a(NBT_ITEM, (NBTBase)entry.getValue().getStack().serializeNBT());
            tag.func_74768_a(NBT_TYPE, entry.getValue().getType().ordinal());
            list.func_74742_a((NBTBase)tag);
        }
        return list;
    }

    public IItemHandlerModifiable getAsInventory() {
        ItemStackHandler handler = new ItemStackHandler(this.covers.size());
        int i = 0;
        for (Map.Entry<EnumFacing, Cover> entry : this.covers.entrySet()) {
            ItemStack cover = entry.getValue().getType().createStack();
            ItemCover.setItem(cover, entry.getValue().getStack());
            handler.setStackInSlot(i++, cover);
        }
        return handler;
    }

    public static boolean isValidCover(ItemStack item) {
        if (item.func_190926_b()) {
            return false;
        }
        Block block = CoverManager.getBlock(item);
        IBlockState state = CoverManager.getBlockState(item);
        return block != null && state != null && (CoverManager.isModelSupported(state) && block.func_185481_k(state) && !block.func_149653_t() && !block.hasTileEntity(state) || block instanceof BlockGlass || block instanceof BlockStainedGlass);
    }

    private static boolean isModelSupported(IBlockState state) {
        if (state.func_185901_i() != EnumBlockRenderType.MODEL || state instanceof IExtendedBlockState) {
            return false;
        }
        return state.func_185917_h();
    }

    @Nullable
    public static Block getBlock(@Nullable ItemStack item) {
        if (item == null) {
            return null;
        }
        Block block = Block.func_149634_a((Item)item.func_77973_b());
        if (block == Blocks.field_150350_a) {
            return null;
        }
        return block;
    }

    @Nullable
    public static IBlockState getBlockState(@Nullable ItemStack item) {
        Block block = CoverManager.getBlock(item);
        if (block == null) {
            return null;
        }
        try {
            return block.func_176203_a(item.func_77973_b().getMetadata(item));
        }
        catch (Exception e) {
            return null;
        }
    }
}

