/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.item;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.inventory.fluid.FluidInventoryFilter;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerFilterItems;
import com.raoulvdberge.refinedstorage.item.ItemBase;
import com.raoulvdberge.refinedstorage.item.info.ItemInfo;
import com.raoulvdberge.refinedstorage.render.IModelRegistration;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFilter
extends ItemBase {
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_MOD_FILTER = "ModFilter";
    private static final String NBT_NAME = "Name";
    private static final String NBT_ICON = "Icon";
    private static final String NBT_FLUID_ICON = "FluidIcon";
    private static final String NBT_TYPE = "Type";
    public static final String NBT_FLUID_FILTERS = "FluidFilters";

    public ItemFilter() {
        super(new ItemInfo("refinedstorage", "filter"));
        this.func_77625_d(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(IModelRegistration modelRegistration) {
        modelRegistration.setModel(this, 0, new ModelResourceLocation(this.info.getId(), "inventory"));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack((Item)RSItems.FILTER));
            }
            player.openGui((Object)RS.INSTANCE, 13, world, hand.ordinal(), 0, 0);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)("sidebutton.refinedstorage:mode." + (ItemFilter.getMode(stack) == 0 ? "whitelist" : "blacklist")), (Object[])new Object[0]) + TextFormatting.RESET);
        if (ItemFilter.isModFilter(stack)) {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"gui.refinedstorage:filter.mod_filter", (Object[])new Object[0]) + TextFormatting.RESET);
        }
        ItemHandlerFilterItems items = new ItemHandlerFilterItems(stack);
        RenderUtils.addCombinedItemsToTooltip(tooltip, false, items.getFilteredItems());
        FluidInventoryFilter fluids = new FluidInventoryFilter(stack);
        RenderUtils.addCombinedFluidsToTooltip(tooltip, false, fluids.getFilteredFluids());
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public static int getCompare(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_COMPARE) ? stack.func_77978_p().func_74762_e(NBT_COMPARE) : 3;
    }

    public static void setCompare(ItemStack stack, int compare) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a(NBT_COMPARE, compare);
    }

    public static int getMode(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_MODE) ? stack.func_77978_p().func_74762_e(NBT_MODE) : 0;
    }

    public static void setMode(ItemStack stack, int mode) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a(NBT_MODE, mode);
    }

    public static boolean isModFilter(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_MOD_FILTER) && stack.func_77978_p().func_74767_n(NBT_MOD_FILTER);
    }

    public static void setModFilter(ItemStack stack, boolean modFilter) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74757_a(NBT_MOD_FILTER, modFilter);
    }

    public static String getName(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_NAME) ? stack.func_77978_p().func_74779_i(NBT_NAME) : "";
    }

    public static void setName(ItemStack stack, String name) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74778_a(NBT_NAME, name);
    }

    @Nonnull
    public static ItemStack getIcon(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_ICON) ? new ItemStack(stack.func_77978_p().func_74775_l(NBT_ICON)) : ItemStack.field_190927_a;
    }

    public static void setIcon(ItemStack stack, ItemStack icon) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74782_a(NBT_ICON, (NBTBase)icon.serializeNBT());
    }

    public static void setFluidIcon(ItemStack stack, @Nullable FluidStack icon) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (icon == null) {
            stack.func_77978_p().func_82580_o(NBT_FLUID_ICON);
        } else {
            stack.func_77978_p().func_74782_a(NBT_FLUID_ICON, (NBTBase)icon.writeToNBT(new NBTTagCompound()));
        }
    }

    @Nullable
    public static FluidStack getFluidIcon(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_FLUID_ICON) ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l(NBT_FLUID_ICON)) : null;
    }

    public static int getType(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_TYPE) ? stack.func_77978_p().func_74762_e(NBT_TYPE) : 0;
    }

    public static void setType(ItemStack stack, int type) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a(NBT_TYPE, type);
    }
}

