/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.proxy;

import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.RSKeyBindings;
import com.raoulvdberge.refinedstorage.block.BlockBase;
import com.raoulvdberge.refinedstorage.gui.KeyInputListener;
import com.raoulvdberge.refinedstorage.item.ItemBase;
import com.raoulvdberge.refinedstorage.proxy.ProxyCommon;
import com.raoulvdberge.refinedstorage.render.IModelRegistration;
import com.raoulvdberge.refinedstorage.render.collision.BlockHighlightListener;
import com.raoulvdberge.refinedstorage.render.teisr.TileEntityItemStackRendererPattern;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

public class ProxyClient
extends ProxyCommon
implements IModelRegistration {
    private Map<ResourceLocation, Function<IBakedModel, IBakedModel>> bakedModelOverrides = new HashMap<ResourceLocation, Function<IBakedModel, IBakedModel>>();
    private List<Pair<Item, IItemColor>> itemColors = new LinkedList<Pair<Item, IItemColor>>();

    @Override
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        MinecraftForge.EVENT_BUS.register((Object)new BlockHighlightListener());
        MinecraftForge.EVENT_BUS.register((Object)new KeyInputListener());
        RSItems.PATTERN.setTileEntityItemStackRenderer(new TileEntityItemStackRendererPattern());
    }

    @Override
    public void init(FMLInitializationEvent e) {
        super.init(e);
        RSKeyBindings.init();
        this.itemColors.forEach(p -> Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)p.getRight(), new Item[]{(Item)p.getKey()}));
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent e) {
        for (BlockBase block : this.blocksToRegister) {
            block.registerModels(this);
        }
        for (Item item : this.itemsToRegister) {
            if (!(item instanceof ItemBase)) continue;
            ((ItemBase)item).registerModels(this);
        }
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent e) {
        for (ModelResourceLocation resource : e.getModelRegistry().func_148742_b()) {
            ResourceLocation key = new ResourceLocation(resource.func_110624_b(), resource.func_110623_a());
            if (!this.bakedModelOverrides.containsKey(key)) continue;
            e.getModelRegistry().func_82595_a((Object)resource, (Object)this.bakedModelOverrides.get(key).apply((IBakedModel)e.getModelRegistry().func_82594_a((Object)resource)));
        }
    }

    @Override
    public void addBakedModelOverride(ResourceLocation resource, Function<IBakedModel, IBakedModel> override) {
        this.bakedModelOverrides.put(resource, override);
    }

    @Override
    public void setModel(Block block, int meta, ModelResourceLocation resource) {
        this.setModel(Item.func_150898_a((Block)block), meta, resource);
    }

    @Override
    public void setModel(Item item, int meta, ModelResourceLocation resource) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)resource);
    }

    @Override
    public void setModelVariants(Item item, ResourceLocation ... variants) {
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])variants);
    }

    @Override
    public void setModelMeshDefinition(Block block, ItemMeshDefinition meshDefinition) {
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)block), (ItemMeshDefinition)meshDefinition);
    }

    @Override
    public void addModelLoader(Supplier<ICustomModelLoader> modelLoader) {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)modelLoader.get());
    }

    @Override
    public void setStateMapper(Block block, IStateMapper stateMapper) {
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)stateMapper);
    }

    @Override
    public void setTesr(Class<? extends TileEntity> tile, TileEntitySpecialRenderer tesr) {
        ClientRegistry.bindTileEntitySpecialRenderer(tile, (TileEntitySpecialRenderer)tesr);
    }

    @Override
    public void addItemColor(Item item, IItemColor itemColor) {
        this.itemColors.add((Pair<Item, IItemColor>)Pair.of((Object)item, (Object)itemColor));
    }
}

