/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.render;

import com.raoulvdberge.refinedstorage.util.RenderUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import org.lwjgl.util.vector.Vector3f;

public class CubeBuilder {
    private Vector3f from;
    private Vector3f to;
    private VertexFormat format = DefaultVertexFormats.field_176599_b;
    private Map<EnumFacing, Face> faces = new HashMap<EnumFacing, Face>();
    private int color = -1;

    public CubeBuilder from(float x, float y, float z) {
        this.from = new Vector3f(x / 16.0f, y / 16.0f, z / 16.0f);
        return this;
    }

    public CubeBuilder to(float x, float y, float z) {
        this.to = new Vector3f(x / 16.0f, y / 16.0f, z / 16.0f);
        return this;
    }

    public CubeBuilder color(int color) {
        this.color = color;
        return this;
    }

    public CubeBuilder lightmap() {
        this.format = RenderUtils.getFormatWithLightMap(this.format);
        return this;
    }

    public CubeBuilder addFaces(Function<EnumFacing, Face> faceSupplier) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.addFace(faceSupplier.apply(facing));
        }
        return this;
    }

    public CubeBuilder addFace(Face face) {
        this.faces.put(face.face, face);
        return this;
    }

    public List<BakedQuad> bake() {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (Map.Entry<EnumFacing, Face> entry : this.faces.entrySet()) {
            quads.add(this.bakeFace(entry.getKey(), entry.getValue()));
        }
        return quads;
    }

    private BakedQuad bakeFace(EnumFacing facing, Face cubeFace) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.format);
        builder.setTexture(cubeFace.sprite);
        builder.setQuadOrientation(facing);
        builder.setQuadTint(-1);
        builder.setApplyDiffuseLighting(true);
        Uv uv = this.getDefaultUv(facing, cubeFace.sprite, this.from.x, this.from.y, this.from.z, this.to.x, this.to.y, this.to.z);
        switch (facing) {
            case DOWN: {
                this.addVertexTopRight(builder, cubeFace, this.to.x, this.from.y, this.from.z, uv);
                this.addVertexBottomRight(builder, cubeFace, this.to.x, this.from.y, this.to.z, uv);
                this.addVertexBottomLeft(builder, cubeFace, this.from.x, this.from.y, this.to.z, uv);
                this.addVertexTopLeft(builder, cubeFace, this.from.x, this.from.y, this.from.z, uv);
                break;
            }
            case UP: {
                this.addVertexTopLeft(builder, cubeFace, this.from.x, this.to.y, this.from.z, uv);
                this.addVertexBottomLeft(builder, cubeFace, this.from.x, this.to.y, this.to.z, uv);
                this.addVertexBottomRight(builder, cubeFace, this.to.x, this.to.y, this.to.z, uv);
                this.addVertexTopRight(builder, cubeFace, this.to.x, this.to.y, this.from.z, uv);
                break;
            }
            case NORTH: {
                this.addVertexBottomRight(builder, cubeFace, this.to.x, this.to.y, this.from.z, uv);
                this.addVertexTopRight(builder, cubeFace, this.to.x, this.from.y, this.from.z, uv);
                this.addVertexTopLeft(builder, cubeFace, this.from.x, this.from.y, this.from.z, uv);
                this.addVertexBottomLeft(builder, cubeFace, this.from.x, this.to.y, this.from.z, uv);
                break;
            }
            case SOUTH: {
                this.addVertexBottomLeft(builder, cubeFace, this.from.x, this.to.y, this.to.z, uv);
                this.addVertexTopLeft(builder, cubeFace, this.from.x, this.from.y, this.to.z, uv);
                this.addVertexTopRight(builder, cubeFace, this.to.x, this.from.y, this.to.z, uv);
                this.addVertexBottomRight(builder, cubeFace, this.to.x, this.to.y, this.to.z, uv);
                break;
            }
            case WEST: {
                this.addVertexTopLeft(builder, cubeFace, this.from.x, this.from.y, this.from.z, uv);
                this.addVertexTopRight(builder, cubeFace, this.from.x, this.from.y, this.to.z, uv);
                this.addVertexBottomRight(builder, cubeFace, this.from.x, this.to.y, this.to.z, uv);
                this.addVertexBottomLeft(builder, cubeFace, this.from.x, this.to.y, this.from.z, uv);
                break;
            }
            case EAST: {
                this.addVertexBottomRight(builder, cubeFace, this.to.x, this.to.y, this.from.z, uv);
                this.addVertexBottomLeft(builder, cubeFace, this.to.x, this.to.y, this.to.z, uv);
                this.addVertexTopLeft(builder, cubeFace, this.to.x, this.from.y, this.to.z, uv);
                this.addVertexTopRight(builder, cubeFace, this.to.x, this.from.y, this.from.z, uv);
            }
        }
        return builder.build();
    }

    private Uv getDefaultUv(EnumFacing face, TextureAtlasSprite texture, float fromX, float fromY, float fromZ, float toX, float toY, float toZ) {
        Uv uv = new Uv();
        switch (face) {
            case DOWN: {
                uv.xFrom = texture.func_94214_a((double)(fromX * 16.0f));
                uv.yFrom = texture.func_94207_b((double)(16.0f - fromZ * 16.0f));
                uv.xTo = texture.func_94214_a((double)(toX * 16.0f));
                uv.yTo = texture.func_94207_b((double)(16.0f - toZ * 16.0f));
                break;
            }
            case UP: {
                uv.xFrom = texture.func_94214_a((double)(fromX * 16.0f));
                uv.yFrom = texture.func_94207_b((double)(fromZ * 16.0f));
                uv.xTo = texture.func_94214_a((double)(toX * 16.0f));
                uv.yTo = texture.func_94207_b((double)(toZ * 16.0f));
                break;
            }
            case NORTH: {
                uv.xFrom = texture.func_94214_a((double)(16.0f - fromX * 16.0f));
                uv.yFrom = texture.func_94207_b((double)(16.0f - fromY * 16.0f));
                uv.xTo = texture.func_94214_a((double)(16.0f - toX * 16.0f));
                uv.yTo = texture.func_94207_b((double)(16.0f - toY * 16.0f));
                break;
            }
            case SOUTH: {
                uv.xFrom = texture.func_94214_a((double)(fromX * 16.0f));
                uv.yFrom = texture.func_94207_b((double)(16.0f - fromY * 16.0f));
                uv.xTo = texture.func_94214_a((double)(toX * 16.0f));
                uv.yTo = texture.func_94207_b((double)(16.0f - toY * 16.0f));
                break;
            }
            case WEST: {
                uv.xFrom = texture.func_94214_a((double)(fromZ * 16.0f));
                uv.yFrom = texture.func_94207_b((double)(16.0f - fromY * 16.0f));
                uv.xTo = texture.func_94214_a((double)(toZ * 16.0f));
                uv.yTo = texture.func_94207_b((double)(16.0f - toY * 16.0f));
                break;
            }
            case EAST: {
                uv.xFrom = texture.func_94214_a((double)(16.0f - toZ * 16.0f));
                uv.yFrom = texture.func_94207_b((double)(16.0f - fromY * 16.0f));
                uv.xTo = texture.func_94214_a((double)(16.0f - fromZ * 16.0f));
                uv.yTo = texture.func_94207_b((double)(16.0f - toY * 16.0f));
            }
        }
        return uv;
    }

    private void addVertexTopLeft(UnpackedBakedQuad.Builder builder, Face face, float x, float y, float z, Uv uv) {
        float v;
        float u;
        switch (face.uvRotation) {
            default: {
                u = uv.xFrom;
                v = uv.yFrom;
                break;
            }
            case CLOCKWISE_90: {
                u = uv.xFrom;
                v = uv.yTo;
                break;
            }
            case CLOCKWISE_180: {
                u = uv.xTo;
                v = uv.yTo;
                break;
            }
            case CLOCKWISE_270: {
                u = uv.xTo;
                v = uv.yFrom;
            }
        }
        this.addVertex(builder, face, x, y, z, u, v);
    }

    private void addVertexTopRight(UnpackedBakedQuad.Builder builder, Face face, float x, float y, float z, Uv uv) {
        float v;
        float u;
        switch (face.uvRotation) {
            default: {
                u = uv.xTo;
                v = uv.yFrom;
                break;
            }
            case CLOCKWISE_90: {
                u = uv.xFrom;
                v = uv.yFrom;
                break;
            }
            case CLOCKWISE_180: {
                u = uv.xFrom;
                v = uv.yTo;
                break;
            }
            case CLOCKWISE_270: {
                u = uv.xTo;
                v = uv.yTo;
            }
        }
        this.addVertex(builder, face, x, y, z, u, v);
    }

    private void addVertexBottomRight(UnpackedBakedQuad.Builder builder, Face face, float x, float y, float z, Uv uv) {
        float v;
        float u;
        switch (face.uvRotation) {
            default: {
                u = uv.xTo;
                v = uv.yTo;
                break;
            }
            case CLOCKWISE_90: {
                u = uv.xTo;
                v = uv.yFrom;
                break;
            }
            case CLOCKWISE_180: {
                u = uv.xFrom;
                v = uv.yFrom;
                break;
            }
            case CLOCKWISE_270: {
                u = uv.xFrom;
                v = uv.yTo;
            }
        }
        this.addVertex(builder, face, x, y, z, u, v);
    }

    private void addVertexBottomLeft(UnpackedBakedQuad.Builder builder, Face face, float x, float y, float z, Uv uv) {
        float v;
        float u;
        switch (face.uvRotation) {
            default: {
                u = uv.xFrom;
                v = uv.yTo;
                break;
            }
            case CLOCKWISE_90: {
                u = uv.xTo;
                v = uv.yTo;
                break;
            }
            case CLOCKWISE_180: {
                u = uv.xTo;
                v = uv.yFrom;
                break;
            }
            case CLOCKWISE_270: {
                u = uv.xFrom;
                v = uv.yFrom;
            }
        }
        this.addVertex(builder, face, x, y, z, u, v);
    }

    private void addVertex(UnpackedBakedQuad.Builder builder, Face face, float x, float y, float z, float u, float v) {
        VertexFormat format = builder.getVertexFormat();
        block6: for (int i = 0; i < format.func_177345_h(); ++i) {
            VertexFormatElement e = format.func_177348_c(i);
            switch (e.func_177375_c()) {
                case POSITION: {
                    builder.put(i, new float[]{x, y, z});
                    continue block6;
                }
                case NORMAL: {
                    builder.put(i, new float[]{face.face.func_82601_c(), face.face.func_96559_d(), face.face.func_82599_e()});
                    continue block6;
                }
                case COLOR: {
                    float r = (float)(this.color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(this.color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(this.color & 0xFF) / 255.0f;
                    float a = (float)(this.color >> 24 & 0xFF) / 255.0f;
                    builder.put(i, new float[]{r, g, b, a});
                    continue block6;
                }
                case UV: {
                    if (e.func_177369_e() == 0) {
                        builder.put(i, new float[]{u, v});
                        continue block6;
                    }
                    builder.put(i, new float[]{(float)(face.light * 32) / 65535.0f, (float)(face.light * 32) / 65535.0f});
                    continue block6;
                }
                default: {
                    builder.put(i, new float[0]);
                }
            }
        }
    }

    public static class Face {
        private EnumFacing face;
        private TextureAtlasSprite sprite;
        private int light;
        private UvRotation uvRotation = UvRotation.CLOCKWISE_0;

        public Face(EnumFacing face, TextureAtlasSprite sprite) {
            this.face = face;
            this.sprite = sprite;
        }

        public Face(EnumFacing face, TextureAtlasSprite sprite, UvRotation uvRotation) {
            this(face, sprite);
            this.uvRotation = uvRotation;
        }

        public Face(EnumFacing face, TextureAtlasSprite sprite, UvRotation uvRotation, int light) {
            this(face, sprite, uvRotation);
            this.light = light;
        }
    }

    private static class Uv {
        private float xFrom;
        private float xTo;
        private float yFrom;
        private float yTo;

        private Uv() {
        }
    }

    public static enum UvRotation {
        CLOCKWISE_0,
        CLOCKWISE_90,
        CLOCKWISE_180,
        CLOCKWISE_270;

    }
}

