/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile.grid;

import com.raoulvdberge.refinedstorage.api.network.grid.GridType;
import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeGrid;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileGrid
extends TileNode<NetworkNodeGrid> {
    public static final TileDataParameter<Integer, TileGrid> VIEW_TYPE = new TileDataParameter<Integer, TileGrid>(DataSerializers.field_187192_b, 0, t -> ((NetworkNodeGrid)t.getNode()).getViewType(), (t, v) -> {
        if (IGrid.isValidViewType(v)) {
            ((NetworkNodeGrid)t.getNode()).setViewType((int)v);
            ((NetworkNodeGrid)t.getNode()).markDirty();
        }
    }, (initial, p) -> TileGrid.trySortGrid(initial));
    public static final TileDataParameter<Integer, TileGrid> SORTING_DIRECTION = new TileDataParameter<Integer, TileGrid>(DataSerializers.field_187192_b, 0, t -> ((NetworkNodeGrid)t.getNode()).getSortingDirection(), (t, v) -> {
        if (IGrid.isValidSortingDirection(v)) {
            ((NetworkNodeGrid)t.getNode()).setSortingDirection((int)v);
            ((NetworkNodeGrid)t.getNode()).markDirty();
        }
    }, (initial, p) -> TileGrid.trySortGrid(initial));
    public static final TileDataParameter<Integer, TileGrid> SORTING_TYPE = new TileDataParameter<Integer, TileGrid>(DataSerializers.field_187192_b, 0, t -> ((NetworkNodeGrid)t.getNode()).getSortingType(), (t, v) -> {
        if (IGrid.isValidSortingType(v)) {
            ((NetworkNodeGrid)t.getNode()).setSortingType((int)v);
            ((NetworkNodeGrid)t.getNode()).markDirty();
        }
    }, (initial, p) -> TileGrid.trySortGrid(initial));
    public static final TileDataParameter<Integer, TileGrid> SEARCH_BOX_MODE = new TileDataParameter<Integer, TileGrid>(DataSerializers.field_187192_b, 0, t -> ((NetworkNodeGrid)t.getNode()).getSearchBoxMode(), (t, v) -> {
        if (IGrid.isValidSearchBoxMode(v)) {
            ((NetworkNodeGrid)t.getNode()).setSearchBoxMode((int)v);
            ((NetworkNodeGrid)t.getNode()).markDirty();
        }
    }, (initial, p) -> GuiBase.executeLater(GuiGrid.class, grid -> grid.getSearchField().setMode((int)p)));
    public static final TileDataParameter<Integer, TileGrid> SIZE = new TileDataParameter<Integer, TileGrid>(DataSerializers.field_187192_b, 0, t -> ((NetworkNodeGrid)t.getNode()).getSize(), (t, v) -> {
        if (IGrid.isValidSize(v)) {
            ((NetworkNodeGrid)t.getNode()).setSize((int)v);
            ((NetworkNodeGrid)t.getNode()).markDirty();
        }
    }, (initial, p) -> GuiBase.executeLater(GuiGrid.class, GuiBase::func_73866_w_));
    public static final TileDataParameter<Integer, TileGrid> TAB_SELECTED = new TileDataParameter<Integer, TileGrid>(DataSerializers.field_187192_b, 0, t -> ((NetworkNodeGrid)t.getNode()).getTabSelected(), (t, v) -> {
        ((NetworkNodeGrid)t.getNode()).setTabSelected(v.intValue() == ((NetworkNodeGrid)t.getNode()).getTabSelected() ? -1 : v);
        ((NetworkNodeGrid)t.getNode()).markDirty();
    }, (initial, p) -> GuiBase.executeLater(GuiGrid.class, grid -> grid.getView().sort()));
    public static final TileDataParameter<Integer, TileGrid> TAB_PAGE = new TileDataParameter<Integer, TileGrid>(DataSerializers.field_187192_b, 0, t -> ((NetworkNodeGrid)t.getNode()).getTabPage(), (t, v) -> {
        if (v >= 0 && v <= ((NetworkNodeGrid)t.getNode()).getTotalTabPages()) {
            ((NetworkNodeGrid)t.getNode()).setTabPage((int)v);
            ((NetworkNodeGrid)t.getNode()).markDirty();
        }
    });
    public static final TileDataParameter<Boolean, TileGrid> OREDICT_PATTERN = new TileDataParameter<Boolean, TileGrid>(DataSerializers.field_187198_h, false, t -> ((NetworkNodeGrid)t.getNode()).isOredictPattern(), (t, v) -> {
        ((NetworkNodeGrid)t.getNode()).setOredictPattern((boolean)v);
        ((NetworkNodeGrid)t.getNode()).markDirty();
    }, (initial, p) -> GuiBase.executeLater(GuiGrid.class, grid -> grid.updateOredictPattern((boolean)p)));
    public static final TileDataParameter<Boolean, TileGrid> PROCESSING_PATTERN = new TileDataParameter<Boolean, TileGrid>(DataSerializers.field_187198_h, false, t -> ((NetworkNodeGrid)t.getNode()).isProcessingPattern(), (t, v) -> {
        ((NetworkNodeGrid)t.getNode()).setProcessingPattern((boolean)v);
        ((NetworkNodeGrid)t.getNode()).clearMatrix();
        ((NetworkNodeGrid)t.getNode()).markDirty();
    }, (initial, p) -> GuiBase.executeLater(GuiGrid.class, GuiBase::func_73866_w_));
    public static final TileDataParameter<Integer, TileGrid> PROCESSING_TYPE = IType.createParameter((initial, p) -> GuiBase.executeLater(GuiGrid.class, GuiBase::func_73866_w_));

    public static void trySortGrid(boolean initial) {
        if (!initial) {
            GuiBase.executeLater(GuiGrid.class, grid -> grid.getView().sort());
        }
    }

    public TileGrid() {
        this.dataManager.addWatchedParameter(VIEW_TYPE);
        this.dataManager.addWatchedParameter(SORTING_DIRECTION);
        this.dataManager.addWatchedParameter(SORTING_TYPE);
        this.dataManager.addWatchedParameter(SEARCH_BOX_MODE);
        this.dataManager.addWatchedParameter(SIZE);
        this.dataManager.addWatchedParameter(TAB_SELECTED);
        this.dataManager.addWatchedParameter(TAB_PAGE);
        this.dataManager.addWatchedParameter(OREDICT_PATTERN);
        this.dataManager.addWatchedParameter(PROCESSING_PATTERN);
        this.dataManager.addWatchedParameter(PROCESSING_TYPE);
    }

    @Override
    @Nonnull
    public NetworkNodeGrid createNode(World world, BlockPos pos) {
        return new NetworkNodeGrid(world, pos);
    }

    @Override
    public String getNodeId() {
        return "grid";
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing side) {
        return ((NetworkNodeGrid)this.getNode()).getGridType() == GridType.PATTERN && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing side) {
        if (((NetworkNodeGrid)this.getNode()).getGridType() == GridType.PATTERN && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)((NetworkNodeGrid)this.getNode()).getPatterns());
        }
        return super.getCapability(capability, side);
    }
}

