/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile.grid;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.grid.GridType;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridCraftingListener;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridNetworkAware;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridTab;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.api.util.IFilter;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageCacheListenerGridFluid;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerFilter;
import com.raoulvdberge.refinedstorage.item.ItemWirelessFluidGrid;
import com.raoulvdberge.refinedstorage.network.MessageWirelessFluidGridSettingsUpdate;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class WirelessFluidGrid
implements IGridNetworkAware {
    public static int ID;
    private ItemStack stack;
    private int networkDimension;
    private BlockPos network;
    private int sortingType;
    private int sortingDirection;
    private int searchBoxMode;
    private int tabSelected;
    private int tabPage;
    private int size;
    private List<IFilter> filters = new ArrayList<IFilter>();
    private List<IGridTab> tabs = new ArrayList<IGridTab>();
    private ItemHandlerFilter filter = new ItemHandlerFilter(this.filters, this.tabs, null){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (!WirelessFluidGrid.this.stack.func_77942_o()) {
                WirelessFluidGrid.this.stack.func_77982_d(new NBTTagCompound());
            }
            StackUtils.writeItems((IItemHandler)this, 0, WirelessFluidGrid.this.stack.func_77978_p());
        }
    };

    public WirelessFluidGrid(ItemStack stack) {
        this.networkDimension = ItemWirelessFluidGrid.getDimensionId(stack);
        this.network = new BlockPos(ItemWirelessFluidGrid.getX(stack), ItemWirelessFluidGrid.getY(stack), ItemWirelessFluidGrid.getZ(stack));
        this.stack = stack;
        this.sortingType = ItemWirelessFluidGrid.getSortingType(stack);
        this.sortingDirection = ItemWirelessFluidGrid.getSortingDirection(stack);
        this.searchBoxMode = ItemWirelessFluidGrid.getSearchBoxMode(stack);
        this.tabSelected = ItemWirelessFluidGrid.getTabSelected(stack);
        this.tabPage = ItemWirelessFluidGrid.getTabPage(stack);
        this.size = ItemWirelessFluidGrid.getSize(stack);
        if (stack.func_77942_o()) {
            StackUtils.readItems((IItemHandlerModifiable)this.filter, 0, stack.func_77978_p());
        }
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public GridType getGridType() {
        return GridType.FLUID;
    }

    @Override
    @Nullable
    public INetwork getNetwork() {
        WorldServer world = DimensionManager.getWorld((int)this.networkDimension);
        if (world != null) {
            TileEntity tile = world.func_175625_s(this.network);
            return tile instanceof INetwork ? (INetwork)tile : null;
        }
        return null;
    }

    @Override
    public IStorageCacheListener createListener(EntityPlayerMP player) {
        return new StorageCacheListenerGridFluid(player, this.getNetwork());
    }

    @Override
    @Nullable
    public IStorageCache getStorageCache() {
        INetwork network = this.getNetwork();
        return network != null ? network.getFluidStorageCache() : null;
    }

    @Override
    @Nullable
    public IItemGridHandler getItemHandler() {
        return null;
    }

    @Override
    @Nullable
    public IFluidGridHandler getFluidHandler() {
        INetwork network = this.getNetwork();
        return network != null ? network.getFluidGridHandler() : null;
    }

    @Override
    public void addCraftingListener(IGridCraftingListener listener) {
    }

    @Override
    public void removeCraftingListener(IGridCraftingListener listener) {
    }

    @Override
    public String getGuiTitle() {
        return "gui.refinedstorage:fluid_grid";
    }

    @Override
    public int getViewType() {
        return 0;
    }

    @Override
    public int getSortingType() {
        return this.sortingType;
    }

    @Override
    public int getSortingDirection() {
        return this.sortingDirection;
    }

    @Override
    public int getSearchBoxMode() {
        return this.searchBoxMode;
    }

    @Override
    public int getTabSelected() {
        return this.tabSelected;
    }

    @Override
    public int getTabPage() {
        return Math.min(this.tabPage, this.getTotalTabPages());
    }

    @Override
    public int getTotalTabPages() {
        return (int)Math.floor((float)Math.max(0, this.tabs.size() - 1) / 5.0f);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void onViewTypeChanged(int type) {
    }

    @Override
    public void onSortingTypeChanged(int type) {
        RS.INSTANCE.network.sendToServer((IMessage)new MessageWirelessFluidGridSettingsUpdate(this.getSortingDirection(), type, this.getSearchBoxMode(), this.getSize(), this.getTabSelected(), this.getTabPage()));
        this.sortingType = type;
        GuiBase.executeLater(GuiGrid.class, grid -> grid.getView().sort());
    }

    @Override
    public void onSortingDirectionChanged(int direction) {
        RS.INSTANCE.network.sendToServer((IMessage)new MessageWirelessFluidGridSettingsUpdate(direction, this.getSortingType(), this.getSearchBoxMode(), this.getSize(), this.getTabSelected(), this.getTabPage()));
        this.sortingDirection = direction;
        GuiBase.executeLater(GuiGrid.class, grid -> grid.getView().sort());
    }

    @Override
    public void onSearchBoxModeChanged(int searchBoxMode) {
        RS.INSTANCE.network.sendToServer((IMessage)new MessageWirelessFluidGridSettingsUpdate(this.getSortingDirection(), this.getSortingType(), searchBoxMode, this.getSize(), this.getTabSelected(), this.getTabPage()));
        this.searchBoxMode = searchBoxMode;
    }

    @Override
    public void onSizeChanged(int size) {
        RS.INSTANCE.network.sendToServer((IMessage)new MessageWirelessFluidGridSettingsUpdate(this.getSortingDirection(), this.getSortingType(), this.getSearchBoxMode(), size, this.getTabSelected(), this.getTabPage()));
        this.size = size;
        if (Minecraft.func_71410_x().field_71462_r != null) {
            Minecraft.func_71410_x().field_71462_r.func_73866_w_();
        }
    }

    @Override
    public void onTabSelectionChanged(int tab) {
        this.tabSelected = tab == this.tabSelected ? -1 : tab;
        RS.INSTANCE.network.sendToServer((IMessage)new MessageWirelessFluidGridSettingsUpdate(this.getSortingDirection(), this.getSortingType(), this.getSearchBoxMode(), this.getSize(), this.tabSelected, this.getTabPage()));
        GuiBase.executeLater(GuiGrid.class, grid -> grid.getView().sort());
    }

    @Override
    public void onTabPageChanged(int page) {
        if (page >= 0 && page <= this.getTotalTabPages()) {
            RS.INSTANCE.network.sendToServer((IMessage)new MessageWirelessFluidGridSettingsUpdate(this.getSortingDirection(), this.getSortingType(), this.getSearchBoxMode(), this.getSize(), this.getTabSelected(), page));
            this.tabPage = page;
        }
    }

    @Override
    public List<IFilter> getFilters() {
        return this.filters;
    }

    @Override
    public List<IGridTab> getTabs() {
        return this.tabs;
    }

    @Override
    public IItemHandlerModifiable getFilter() {
        return this.filter;
    }

    @Override
    public InventoryCrafting getCraftingMatrix() {
        return null;
    }

    @Override
    public InventoryCraftResult getCraftingResult() {
        return null;
    }

    @Override
    public void onCraftingMatrixChanged() {
    }

    @Override
    public void onCrafted(EntityPlayer player) {
    }

    @Override
    public void onCraftedShift(EntityPlayer player) {
    }

    @Override
    public void onRecipeTransfer(EntityPlayer player, ItemStack[][] recipe) {
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void onClosed(EntityPlayer player) {
        INetwork network = this.getNetwork();
        if (network != null) {
            network.getNetworkItemHandler().close(player);
        }
    }
}

