/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.client.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.EntityLivingBase;
import tonius.simplyjetpacks.client.model.ModelFluxPack;
import tonius.simplyjetpacks.client.model.ModelJetpack;
import tonius.simplyjetpacks.item.Fluxpack;
import tonius.simplyjetpacks.item.Jetpack;

public abstract class RenderUtils {
    private static final Minecraft mc = Minecraft.func_71410_x();

    public static void drawStringLeft(String string, FontRenderer fontRenderer, int x, int y, int color, boolean shadow) {
        fontRenderer.func_175065_a(string, (float)x, (float)y, color, shadow);
    }

    public static void drawStringCenter(String string, FontRenderer fontRenderer, int x, int y, int color, boolean shadow) {
        fontRenderer.func_175065_a(string, (float)(x - fontRenderer.func_78256_a(string) / 2), (float)y, color, shadow);
    }

    public static void drawStringRight(String string, FontRenderer fontRenderer, int x, int y, int color, boolean shadow) {
        fontRenderer.func_175065_a(string, (float)(x - fontRenderer.func_78256_a(string)), (float)y, color, shadow);
    }

    public static void drawStringAtHUDPosition(String string, HUDPositions position, FontRenderer fontRenderer, int xOffset, int yOffset, double scale, int color, boolean shadow, int lineOffset) {
        ScaledResolution res = new ScaledResolution(mc);
        int screenWidth = res.func_78326_a();
        screenWidth = (int)((double)screenWidth / scale);
        int screenHeight = res.func_78328_b();
        screenHeight = (int)((double)screenHeight / scale);
        switch (position) {
            case TOP_LEFT: {
                RenderUtils.drawStringLeft(string, fontRenderer, 2 + xOffset, 2 + (yOffset += lineOffset * 9), color, shadow);
                break;
            }
            case TOP_CENTER: {
                RenderUtils.drawStringCenter(string, fontRenderer, screenWidth / 2 + xOffset, 2 + (yOffset += lineOffset * 9), color, shadow);
                break;
            }
            case TOP_RIGHT: {
                RenderUtils.drawStringRight(string, fontRenderer, screenWidth - 2 + xOffset, 2 + (yOffset += lineOffset * 9), color, shadow);
                break;
            }
            case LEFT: {
                RenderUtils.drawStringLeft(string, fontRenderer, 2 + xOffset, screenHeight / 2 + (yOffset += lineOffset * 9), color, shadow);
                break;
            }
            case RIGHT: {
                RenderUtils.drawStringRight(string, fontRenderer, screenWidth - 2 + xOffset, screenHeight / 2 + (yOffset += lineOffset * 9), color, shadow);
                break;
            }
            case BOTTOM_LEFT: {
                RenderUtils.drawStringLeft(string, fontRenderer, 2 + xOffset, screenHeight - 9 + (yOffset -= lineOffset * 9), color, shadow);
                break;
            }
            case BOTTOM_RIGHT: {
                RenderUtils.drawStringRight(string, fontRenderer, screenWidth - 2 + xOffset, screenHeight - 9 + (yOffset -= lineOffset * 9), color, shadow);
            }
        }
    }

    public static ModelBiped getArmorModel(Jetpack pack, EntityLivingBase entity) {
        ModelJetpack model = null;
        switch (pack.armorModel) {
            case JETPACK: {
                model = ModelJetpack.INSTANCE;
                break;
            }
        }
        if (model == null) {
            return null;
        }
        model.field_78117_n = entity.func_70093_af();
        model.field_78093_q = entity.func_184218_aH();
        model.field_78091_s = entity.func_70631_g_();
        return model;
    }

    public static ModelBiped getArmorModel(Fluxpack pack, EntityLivingBase entity) {
        ModelFluxPack model = null;
        switch (pack.armorModel) {
            case FLUX_PACK: {
                model = ModelFluxPack.INSTANCE;
            }
        }
        if (model == null) {
            return null;
        }
        model.field_78117_n = entity.func_70093_af();
        model.field_78093_q = entity.func_184218_aH();
        model.field_78091_s = entity.func_70631_g_();
        return model;
    }

    public static enum HUDPositions {
        TOP_LEFT,
        TOP_CENTER,
        TOP_RIGHT,
        LEFT,
        RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

